/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.bio.Annotatable;
import org.biojava.ontology.Term;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Note;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNote;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichAnnotation
extends AbstractChangeable
implements RichAnnotation {
    private Set notes = new TreeSet();

    public void clear() throws ChangeVetoException {
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            this.removeNote((Note)i.next());
        }
    }

    public Map asMap() {
        TreeMap<ComparableTerm, String> m = new TreeMap<ComparableTerm, String>();
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            m.put(n.getTerm(), n.getValue());
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNote(Note note) throws ChangeVetoException {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null");
        }
        if (!this.hasListeners(Annotatable.ANNOTATION)) {
            this.notes.add(note);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Annotatable.ANNOTATION, note, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Annotatable.ANNOTATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.notes.add(note);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public boolean contains(Note note) {
        return this.notes.contains(note);
    }

    public boolean containsProperty(Object key) {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            if (!n.getTerm().equals(key)) continue;
            return true;
        }
        return false;
    }

    public Note getNote(Note note) throws NoSuchElementException {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null");
        }
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            if (!note.equals(n)) continue;
            return n;
        }
        throw new NoSuchElementException("No such property: " + note.getTerm() + ", rank " + note.getRank());
    }

    public Object getProperty(Object key) throws NoSuchElementException {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            if (!n.getTerm().equals(key)) continue;
            return n.getValue();
        }
        throw new NoSuchElementException("No such property: " + key);
    }

    public Note[] getProperties(Object key) {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        LinkedList<Note> l = new LinkedList<Note>();
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            if (!n.getTerm().equals(key)) continue;
            l.add(n);
        }
        Collections.sort(l);
        Note[] na = new Note[l.size()];
        l.toArray(na);
        return na;
    }

    public Set keys() {
        return this.asMap().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(Note note) throws ChangeVetoException {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null");
        }
        if (!this.hasListeners(Annotatable.ANNOTATION)) {
            this.notes.remove(note);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Annotatable.ANNOTATION, null, note);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Annotatable.ANNOTATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.notes.remove(note);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public void removeProperty(Object key) throws NoSuchElementException, ChangeVetoException {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            if (!n.getTerm().equals(key)) continue;
            this.removeNote(n);
            return;
        }
        throw new NoSuchElementException("No such property: " + key);
    }

    public void setProperty(Object key, Object value) throws IllegalArgumentException, ChangeVetoException {
        if (key == null) {
            throw new IllegalArgumentException("Property keys cannot be null");
        }
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        this.addNote(new SimpleNote((ComparableTerm)key, (String)(value == null ? value : value.toString()), 0));
    }

    public Set getNoteSet() {
        return this.notes;
    }

    public void setNoteSet(Set notes) throws ChangeVetoException {
        this.notes = notes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.notes.iterator();
        while (i.hasNext()) {
            sb.append("[");
            sb.append(i.next());
            sb.append("]");
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

