/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.ontology.InvalidTermException;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RankedCrossRefable;
import org.biojavax.RichAnnotatable;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.RichFeatureHolder;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimpleRichFeature;

public interface RichFeature
extends StrandedFeature,
RankedCrossRefable,
RichAnnotatable,
RichFeatureHolder,
Comparable {
    public static final ChangeType NAME = new ChangeType("This feature's name has changed", "org.biojavax.bio.seq.RichFeature", "NAME");
    public static final ChangeType RANK = new ChangeType("This feature's rank has changed", "org.biojavax.bio.seq.RichFeature", "RANK");
    public static final ChangeType SOURCETERM = new ChangeType("This feature's source term has changed", "org.biojavax.bio.seq.RichFeature", "SOURCETERM");
    public static final ChangeType TYPETERM = new ChangeType("This feature's type term has changed", "org.biojavax.bio.seq.RichFeature", "TYPETERM");
    public static final ChangeType LOCATION = new ChangeType("This feature's location has changed", "org.biojavax.bio.seq.RichFeature", "LOCATION");
    public static final ChangeType PARENT = new ChangeType("This feature's parent has changed", "org.biojavax.bio.seq.RichFeature", "PARENT");
    public static final ChangeType CROSSREF = new ChangeType("This feature's crossrefs have changed", "org.biojavax.bio.seq.RichFeature", "CROSSREF");
    public static final ChangeType RELATION = new ChangeType("This feature's relations have changed", "org.biojavax.bio.seq.RichFeature", "RELATION");

    public void setParent(FeatureHolder var1) throws ChangeVetoException;

    public String getName();

    public void setName(String var1) throws ChangeVetoException;

    public int getRank();

    public void setRank(int var1) throws ChangeVetoException;

    public static class Tools {
        private Tools() {
        }

        public static RichFeature enrich(Feature f) throws ChangeVetoException {
            try {
                if (f instanceof RichFeature) {
                    return (RichFeature)f;
                }
                return new SimpleRichFeature(f.getParent(), f.makeTemplate());
            }
            catch (InvalidTermException e) {
                throw new ChangeVetoException("Unable to convert one of the feature's terms", e);
            }
        }

        public static RichFeature makeEmptyFeature() {
            Template templ = new Template();
            templ.annotation = new SimpleRichAnnotation();
            templ.featureRelationshipSet = new TreeSet();
            templ.rankedCrossRefs = new TreeSet();
            templ.type = "none";
            templ.source = "none";
            templ.location = RichLocation.full;
            try {
                return new SimpleRichFeature(new SimpleFeatureHolder(), templ);
            }
            catch (Exception ex) {
                throw new BioError(ex);
            }
        }
    }

    public static class Template
    extends Feature.Template {
        public Set featureRelationshipSet;
        public Set rankedCrossRefs;
    }
}

