/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.MergeLocation;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.CrossReferenceResolver;
import org.biojavax.RichAnnotatable;
import org.biojavax.bio.seq.CompoundRichLocation;
import org.biojavax.bio.seq.EmptyRichLocation;
import org.biojavax.bio.seq.MultiSourceCompoundRichLocation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.PositionResolver;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.ontology.ComparableTerm;

public interface RichLocation
extends Location,
RichAnnotatable,
Comparable {
    public static final ChangeType NOTE = new ChangeType("This location's notes have changed", "org.biojavax.bio.seq.RichLocation", "NOTE");
    public static final ChangeType TERM = new ChangeType("This location's term has changed", "org.biojavax.bio.seq.RichLocation", "TERM");
    public static final ChangeType RANK = new ChangeType("This location's rank has changed", "org.biojavax.bio.seq.RichLocation", "RANK");
    public static final ChangeType CIRCULAR = new ChangeType("This location's circularity has changed", "org.biojavax.bio.seq.RichLocation", "CIRCULAR");
    public static final ChangeType FEATURE = new ChangeType("This location's parent feature has changed", "org.biojavax.bio.seq.RichLocation", "FEATURE");
    public static final RichLocation EMPTY_LOCATION = new EmptyRichLocation();

    public void sort();

    public RichFeature getFeature();

    public void setFeature(RichFeature var1) throws ChangeVetoException;

    public CrossRef getCrossRef();

    public ComparableTerm getTerm();

    public void setTerm(ComparableTerm var1) throws ChangeVetoException;

    public Strand getStrand();

    public int getRank();

    public void setRank(int var1) throws ChangeVetoException;

    public Position getMinPosition();

    public Position getMaxPosition();

    public void setPositionResolver(PositionResolver var1);

    public int getCircularLength();

    public void setCircularLength(int var1) throws ChangeVetoException;

    public void setCrossRefResolver(CrossReferenceResolver var1);

    public static class Tools {
        private Tools() {
        }

        public static RichLocation construct(Collection members) {
            if (members.size() == 0) {
                return EMPTY_LOCATION;
            }
            if (members.size() == 1) {
                return members.toArray(new SimpleRichLocation[0])[0];
            }
            if (Tools.isMultiSource(members)) {
                return new MultiSourceCompoundRichLocation(members);
            }
            return new CompoundRichLocation(members);
        }

        public static boolean isMultiSource(Collection members) {
            RichLocation previous = null;
            Iterator i = members.iterator();
            while (i.hasNext()) {
                RichLocation rl = Tools.enrich((Location)i.next());
                if (previous == null) {
                    previous = rl;
                    continue;
                }
                if (previous.getCircularLength() != rl.getCircularLength()) {
                    return true;
                }
                if (previous.getCrossRef() == null && rl.getCrossRef() != null || previous.getCrossRef() != null && rl.getCrossRef() == null || previous.getCrossRef() != rl.getCrossRef() && !previous.getCrossRef().equals(rl.getCrossRef())) {
                    return true;
                }
                if (!(previous.getStrand() == null && rl.getStrand() != null || previous.getStrand() != null && rl.getStrand() == null) && (previous.getStrand() == rl.getStrand() || previous.getStrand().equals(rl.getStrand()))) continue;
                return true;
            }
            return false;
        }

        public static Collection merge(Collection members) {
            ArrayList<RichLocation> membersList = new ArrayList<RichLocation>(Tools.flatten(members));
            if (membersList.size() > 1) {
                for (int p = 0; p < membersList.size() - 1; ++p) {
                    RichLocation parent = (RichLocation)membersList.get(p);
                    for (int c = p + 1; c < membersList.size(); ++c) {
                        RichLocation child = (RichLocation)membersList.get(c);
                        RichLocation union = (RichLocation)parent.union(child);
                        if (!union.isContiguous()) continue;
                        membersList.set(p, union);
                        membersList.remove(c);
                        c = p;
                    }
                }
            }
            return membersList;
        }

        public static Collection flatten(RichLocation location) {
            ArrayList members = new ArrayList();
            Iterator i = location.blockIterator();
            while (i.hasNext()) {
                members.add(i.next());
            }
            return Tools.flatten(members);
        }

        public static Collection flatten(Collection members) {
            ArrayList flattened = new ArrayList(members);
            for (int i = 0; i < flattened.size(); ++i) {
                RichLocation member = (RichLocation)flattened.get(i);
                if (member instanceof SimpleRichLocation) continue;
                flattened.remove(i);
                int insertPos = i;
                Iterator j = member.blockIterator();
                while (j.hasNext()) {
                    flattened.add(insertPos++, j.next());
                }
                --i;
            }
            return flattened;
        }

        public static int[] modulateCircularLocation(int start, int end, int seqLength) {
            if (seqLength == 0) {
                return new int[]{start, end};
            }
            while (end < start) {
                end += seqLength;
            }
            int locationLength = end - start;
            while (start >= seqLength) {
                start -= seqLength;
            }
            end = start + locationLength;
            return new int[]{start, end};
        }

        public static int[] modulateCircularLocationPair(Location a, Location b, int seqLength) {
            if (seqLength == 0) {
                return new int[]{a.getMin(), a.getMax(), b.getMin(), b.getMax()};
            }
            int[] aParts = Tools.modulateCircularLocation(a.getMin(), a.getMax(), seqLength);
            int aStart = aParts[0];
            int aEnd = aParts[1];
            int[] bParts = Tools.modulateCircularLocation(b.getMin(), b.getMax(), seqLength);
            int bStart = bParts[0];
            int bEnd = bParts[1];
            if (aEnd > seqLength && bStart < aStart) {
                bStart += seqLength;
                bEnd += seqLength;
            }
            return new int[]{aStart, aEnd, bStart, bEnd};
        }

        public static int modulateCircularIndex(int index, int seqLength) {
            if (seqLength == 0) {
                return index;
            }
            while (index > seqLength) {
                index -= seqLength;
            }
            return index;
        }

        public static RichLocation enrich(Location l) {
            if (l instanceof RichLocation) {
                return (RichLocation)l;
            }
            if (l instanceof MergeLocation || !l.isContiguous()) {
                ArrayList<RichLocation> members = new ArrayList<RichLocation>();
                Iterator i = l.blockIterator();
                while (i.hasNext()) {
                    Location member = (Location)i.next();
                    members.add(Tools.enrich(member));
                }
                return Tools.construct(Tools.merge(members));
            }
            if (l instanceof FuzzyPointLocation) {
                FuzzyPointLocation f = (FuzzyPointLocation)l;
                SimplePosition pos = new SimplePosition(f.hasBoundedMin(), f.hasBoundedMax(), f.getMin(), f.getMax(), ".");
                return new SimpleRichLocation(pos, 0);
            }
            if (l instanceof FuzzyLocation) {
                FuzzyLocation f = (FuzzyLocation)l;
                SimplePosition start = new SimplePosition(f.hasBoundedMin(), false, f.getMin());
                SimplePosition end = new SimplePosition(false, f.hasBoundedMax(), f.getMax());
                return new SimpleRichLocation((Position)start, end, 0);
            }
            if (l instanceof RangeLocation) {
                RangeLocation r = (RangeLocation)l;
                SimplePosition start = new SimplePosition(false, false, r.getMin());
                SimplePosition end = new SimplePosition(false, false, r.getMax());
                return new SimpleRichLocation((Position)start, end, 0);
            }
            if (l instanceof PointLocation) {
                PointLocation p = (PointLocation)l;
                SimplePosition pos = new SimplePosition(false, false, p.getMin());
                return new SimpleRichLocation(pos, 0);
            }
            if (l.toString().equals("{}")) {
                return EMPTY_LOCATION;
            }
            throw new IllegalArgumentException("Unable to enrich locations of type " + l.getClass());
        }
    }

    public static class Strand
    implements Comparable {
        private String name;
        private int value;
        public static final Strand POSITIVE_STRAND = new Strand("+", 1);
        public static final Strand NEGATIVE_STRAND = new Strand("-", -1);
        public static final Strand UNKNOWN_STRAND = new Strand("?", 0);

        public static Strand forValue(int value) {
            switch (value) {
                case 1: {
                    return POSITIVE_STRAND;
                }
                case 0: {
                    return UNKNOWN_STRAND;
                }
                case -1: {
                    return NEGATIVE_STRAND;
                }
            }
            throw new IllegalArgumentException("Unknown strand type: " + value);
        }

        public static Strand forName(String name) {
            if (name.equals("+")) {
                return POSITIVE_STRAND;
            }
            if (name.equals("?")) {
                return UNKNOWN_STRAND;
            }
            if (name.equals(".")) {
                return UNKNOWN_STRAND;
            }
            if (name.equals("-")) {
                return NEGATIVE_STRAND;
            }
            throw new IllegalArgumentException("Unknown strand type: " + name);
        }

        private Strand(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int code = 17;
            code = 31 * code + this.name.hashCode();
            code = 31 * code + this.value;
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Strand)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Strand them = (Strand)o;
            if (!them.toString().equals(this.name)) {
                return false;
            }
            return them.intValue() == this.value;
        }

        public int compareTo(Object o) {
            Strand fo = (Strand)o;
            if (!this.name.equals(fo.toString())) {
                return this.name.compareTo(fo.toString());
            }
            return this.value - fo.intValue();
        }
    }
}

