/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.NucleotideTools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequenceIterator;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.bio.seq.SimpleRichSequence;
import org.biojavax.bio.seq.io.EMBLFormat;
import org.biojavax.bio.seq.io.EMBLxmlFormat;
import org.biojavax.bio.seq.io.FastaFormat;
import org.biojavax.bio.seq.io.GenbankFormat;
import org.biojavax.bio.seq.io.INSDseqFormat;
import org.biojavax.bio.seq.io.RichSequenceBuilderFactory;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.seq.io.RichStreamReader;
import org.biojavax.bio.seq.io.RichStreamWriter;
import org.biojavax.bio.seq.io.UniProtFormat;
import org.biojavax.bio.seq.io.UniProtXMLFormat;
import org.biojavax.ontology.ComparableTerm;

public interface RichSequence
extends BioEntry,
Sequence {
    public static final ChangeType SYMLISTVERSION = new ChangeType("This sequences's symbollist version has changed", "org.biojavax.bio.seq.RichSequence", "SYMLISTVERSION");
    public static final ChangeType CIRCULAR = new ChangeType("This sequences's circularity has changed", "org.biojavax.bio.seq.RichSequence", "CIRCULAR");

    public Double getSeqVersion();

    public void setSeqVersion(Double var1) throws ChangeVetoException;

    public Set getFeatureSet();

    public void setFeatureSet(Set var1) throws ChangeVetoException;

    public void setCircular(boolean var1) throws ChangeVetoException;

    public boolean getCircular();

    public SymbolList getInternalSymbolList();

    static class 1 {
        static /* synthetic */ Class class$org$biojavax$SimpleNamespace;
    }

    public static final class IOTools {
        private static RichSequenceBuilderFactory factory = RichSequenceBuilderFactory.THRESHOLD;
        private static List formatClasses = new ArrayList();

        private IOTools() {
        }

        public static void registerFormat(Class formatClass) {
            Object o;
            try {
                o = formatClass.newInstance();
            }
            catch (Exception e) {
                throw new BioError(e);
            }
            if (!(o instanceof RichSequenceFormat)) {
                throw new BioError("Class " + formatClass + " is not an implementation of RichSequenceFormat!");
            }
            formatClasses.add(formatClass);
        }

        public static RichSequenceIterator readStream(BufferedInputStream stream, RichSequenceBuilderFactory seqFactory, Namespace ns) throws IOException {
            Iterator i = formatClasses.iterator();
            while (i.hasNext()) {
                RichSequenceFormat format;
                Class formatClass = (Class)i.next();
                try {
                    format = (RichSequenceFormat)formatClass.newInstance();
                }
                catch (Exception e) {
                    throw new BioError(e);
                }
                if (!format.canRead(stream)) continue;
                SymbolTokenization sTok = format.guessSymbolTokenization(stream);
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                return new RichStreamReader(br, format, sTok, seqFactory, ns);
            }
            throw new IOException("Could not recognise format of stream.");
        }

        public static RichSequenceIterator readStream(BufferedInputStream stream, Namespace ns) throws IOException {
            return IOTools.readStream(stream, factory, ns);
        }

        public static RichSequenceIterator readFile(File file, RichSequenceBuilderFactory seqFactory, Namespace ns) throws IOException {
            Iterator i = formatClasses.iterator();
            while (i.hasNext()) {
                RichSequenceFormat format;
                Class formatClass = (Class)i.next();
                try {
                    format = (RichSequenceFormat)formatClass.newInstance();
                }
                catch (Exception e) {
                    throw new BioError(e);
                }
                if (!format.canRead(file)) continue;
                SymbolTokenization sTok = format.guessSymbolTokenization(file);
                BufferedReader br = new BufferedReader(new FileReader(file));
                return new RichStreamReader(br, format, sTok, seqFactory, ns);
            }
            throw new IOException("Could not recognise format of file: " + file.getName());
        }

        public static RichSequenceIterator readFile(File file, Namespace ns) throws IOException {
            return IOTools.readFile(file, factory, ns);
        }

        public static RichSequenceIterator readFasta(BufferedReader br, SymbolTokenization sTok, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), sTok, factory, ns);
        }

        public static RichSequenceIterator readFasta(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readFastaDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readFastaRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readFastaProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readGenbank(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readGenbankDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readGenbankRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readGenbankProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readINSDseq(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readINSDseqDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readINSDseqRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readINSDseqProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLxml(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readEMBLxmlDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLxmlRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLxmlProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBL(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readEMBLDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readUniProt(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readUniProt(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readUniProtXML(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtXMLFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readUniProtXML(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtXMLFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static void writeFasta(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new FastaFormat());
            sw.writeStream(in, ns);
        }

        public static void writeFasta(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeFasta(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeGenbank(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new GenbankFormat());
            sw.writeStream(in, ns);
        }

        public static void writeGenbank(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeGenbank(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeINSDseq(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new INSDseqFormat());
            sw.writeStream(in, ns);
        }

        public static void writeINSDseq(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeINSDseq(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeEMBLxml(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new EMBLxmlFormat());
            sw.writeStream(in, ns);
        }

        public static void writeEMBLxml(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeEMBLxml(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeEMBL(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new EMBLFormat());
            sw.writeStream(in, ns);
        }

        public static void writeEMBL(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeEMBL(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeUniProt(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new UniProtFormat());
            sw.writeStream(in, ns);
        }

        public static void writeUniProt(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeUniProt(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeUniProtXML(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new UniProtXMLFormat());
            sw.writeStream(in, ns);
        }

        public static void writeUniProtXML(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeUniProtXML(os, new SingleRichSeqIterator(seq), ns);
        }

        public static SymbolTokenization getDNAParser() {
            try {
                return DNATools.getDNA().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get DNA token parser", ex);
            }
        }

        public static SymbolTokenization getRNAParser() {
            try {
                return RNATools.getRNA().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get RNA token parser", ex);
            }
        }

        public static SymbolTokenization getNucleotideParser() {
            try {
                return NucleotideTools.getNucleotide().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get nucleotide token parser", ex);
            }
        }

        public static SymbolTokenization getProteinParser() {
            try {
                return ProteinTools.getTAlphabet().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get PROTEIN token parser", ex);
            }
        }

        public static final class SingleRichSeqIterator
        implements RichSequenceIterator {
            private RichSequence seq;

            public SingleRichSeqIterator(Sequence seq) {
                try {
                    this.seq = seq instanceof RichSequence ? (RichSequence)seq : Tools.enrich(seq);
                }
                catch (ChangeVetoException e) {
                    throw new RuntimeException("Unable to enrich sequence", e);
                }
            }

            public boolean hasNext() {
                return this.seq != null;
            }

            public Sequence nextSequence() {
                return this.nextRichSequence();
            }

            public BioEntry nextBioEntry() {
                return this.nextRichSequence();
            }

            public RichSequence nextRichSequence() {
                RichSequence seq = this.seq;
                this.seq = null;
                return seq;
            }
        }
    }

    public static class Tools {
        private Tools() {
        }

        public static RichSequence createRichSequence(String name, String seqString, Alphabet alpha) throws BioException {
            SimpleSymbolList syms = new SimpleSymbolList(alpha.getTokenization("token"), seqString);
            return Tools.createRichSequence(name, syms);
        }

        public static RichSequence createRichSequence(String namespace, String name, String seqString, Alphabet alpha) throws BioException {
            SimpleSymbolList syms = new SimpleSymbolList(alpha.getTokenization("token"), seqString);
            Namespace ns = (Namespace)RichObjectFactory.getObject(1.class$org$biojavax$SimpleNamespace == null ? (1.class$org$biojavax$SimpleNamespace = 1.class$("org.biojavax.SimpleNamespace")) : 1.class$org$biojavax$SimpleNamespace, new Object[]{namespace});
            return Tools.createRichSequence(ns, name, syms);
        }

        public static RichSequence createRichSequence(Namespace ns, String name, String seqString, Alphabet alpha) throws BioException {
            SimpleSymbolList syms = new SimpleSymbolList(alpha.getTokenization("token"), seqString);
            return Tools.createRichSequence(ns, name, syms);
        }

        public static RichSequence createRichSequence(String name, SymbolList syms) {
            Namespace ns = RichObjectFactory.getDefaultNamespace();
            return Tools.createRichSequence(ns, name, syms);
        }

        public static RichSequence createRichSequence(Namespace ns, String name, SymbolList syms) {
            return new SimpleRichSequence(ns, name, name, 1, syms, new Double(1.0));
        }

        public static RichSequence enrich(Sequence s) throws ChangeVetoException {
            if (s instanceof RichSequence) {
                return (RichSequence)s;
            }
            String name = s.getName();
            SimpleRichSequence rs = new SimpleRichSequence(RichObjectFactory.getDefaultNamespace(), name == null ? "UnknownName" : name, name == null ? "UnknownAccession" : name, 0, s, new Double(0.0));
            Iterator i = s.features();
            while (i.hasNext()) {
                Feature f = (Feature)i.next();
                try {
                    rs.createFeature(f.makeTemplate());
                }
                catch (BioException e) {
                    throw new ChangeVetoException("They hates us!", e);
                }
            }
            i = s.getAnnotation().keys().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = s.getAnnotation().getProperty(key);
                rs.getAnnotation().setProperty(key, value);
            }
            return rs;
        }

        public static RichSequence subSequence(RichSequence s, int from, int to, Namespace newNamespace, String newName, String newAccession, String newIdentifier, int newVersion, Double seqVersion) throws IndexOutOfBoundsException {
            SymbolList symList = s.subList(from, to);
            SimpleRichSequence seq = new SimpleRichSequence(newNamespace, newName, newAccession, newVersion, symList, seqVersion);
            SimpleRichLocation subLoc = new SimpleRichLocation((Position)new SimplePosition(from), new SimplePosition(to), 0);
            try {
                Iterator i = s.features();
                while (i.hasNext()) {
                    RichFeature f = (RichFeature)i.next();
                    if (!subLoc.contains(f.getLocation())) continue;
                    RichFeature.Template templ = (RichFeature.Template)f.makeTemplate();
                    SimplePosition min = new SimplePosition(templ.location.getMin() - from + 1);
                    SimplePosition max = new SimplePosition(templ.location.getMax() - from + 1);
                    templ.location = new SimpleRichLocation((Position)min, max, 0);
                    seq.createFeature(templ);
                }
                if (s.getNoteSet() != null) {
                    seq.setNoteSet(s.getNoteSet());
                }
                if (s.getTaxon() != null) {
                    seq.setTaxon(s.getTaxon());
                }
                if (s.getDescription() != null) {
                    seq.setDescription("subsequence (" + from + ":" + to + ") of " + s.getDescription());
                }
                if (s.getDivision() != null) {
                    seq.setDivision(s.getDivision());
                }
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex);
            }
            catch (BioException ex) {
                throw new BioError(ex);
            }
            return seq;
        }
    }

    public static class Terms {
        private static ComparableTerm SEC_ACCESSION_TERM = null;
        private static ComparableTerm KEYWORDS_TERM = null;
        private static ComparableTerm DATE_CREATED_TERM = null;
        private static ComparableTerm DATE_UPDATED_TERM = null;
        private static ComparableTerm DATE_ANNOTATED_TERM = null;
        private static ComparableTerm REL_CREATED_TERM = null;
        private static ComparableTerm REL_UPDATED_TERM = null;
        private static ComparableTerm REL_ANNOTATED_TERM = null;
        private static ComparableTerm MOLTYPE_TERM = null;
        private static ComparableTerm STRANDED_TERM = null;
        private static ComparableTerm ORGANELLE_TERM = null;
        private static ComparableTerm GENENAME_TERM = null;
        private static ComparableTerm GENESYNONYM_TERM = null;
        private static ComparableTerm ORDLOCNAME_TERM = null;
        private static ComparableTerm ORFNAME_TERM = null;
        private static ComparableTerm SPECIES_TERM = null;
        private static ComparableTerm STRAIN_TERM = null;
        private static ComparableTerm TISSUE_TERM = null;
        private static ComparableTerm TRANSPOSON_TERM = null;
        private static ComparableTerm PLASMID_TERM = null;
        private static ComparableTerm DATACLASS_TERM = null;
        private static ComparableTerm FTID_TERM = null;
        private static ComparableTerm FEATUREDESC_TERM = null;
        private static ComparableTerm COPYRIGHT_TERM = null;
        public static String SPECIES_KEY = "SPECIES";
        public static String STRAIN_KEY = "STRAIN";
        public static String TISSUE_KEY = "TISSUE";
        public static String TRANSPOSON_KEY = "TRANSPOSON";
        public static String PLASMID_KEY = "PLASMID";
        public static final String PUBMED_KEY = "PUBMED";
        public static final String MEDLINE_KEY = "MEDLINE";
        public static final String DOI_KEY = "DOI";

        public static ComparableTerm getAdditionalAccessionTerm() {
            if (SEC_ACCESSION_TERM == null) {
                SEC_ACCESSION_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("acc");
            }
            return SEC_ACCESSION_TERM;
        }

        public static ComparableTerm getKeywordTerm() {
            if (KEYWORDS_TERM == null) {
                KEYWORDS_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("kw");
            }
            return KEYWORDS_TERM;
        }

        public static ComparableTerm getDateCreatedTerm() {
            if (DATE_CREATED_TERM == null) {
                DATE_CREATED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("cdat");
            }
            return DATE_CREATED_TERM;
        }

        public static ComparableTerm getDateUpdatedTerm() {
            if (DATE_UPDATED_TERM == null) {
                DATE_UPDATED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("udat");
            }
            return DATE_UPDATED_TERM;
        }

        public static ComparableTerm getDateAnnotatedTerm() {
            if (DATE_ANNOTATED_TERM == null) {
                DATE_ANNOTATED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("adat");
            }
            return DATE_ANNOTATED_TERM;
        }

        public static ComparableTerm getRelCreatedTerm() {
            if (REL_CREATED_TERM == null) {
                REL_CREATED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("crel");
            }
            return REL_CREATED_TERM;
        }

        public static ComparableTerm getRelUpdatedTerm() {
            if (REL_UPDATED_TERM == null) {
                REL_UPDATED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("urel");
            }
            return REL_UPDATED_TERM;
        }

        public static ComparableTerm getRelAnnotatedTerm() {
            if (REL_ANNOTATED_TERM == null) {
                REL_ANNOTATED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("arel");
            }
            return REL_ANNOTATED_TERM;
        }

        public static ComparableTerm getMolTypeTerm() {
            if (MOLTYPE_TERM == null) {
                MOLTYPE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("moltype");
            }
            return MOLTYPE_TERM;
        }

        public static ComparableTerm getStrandedTerm() {
            if (STRANDED_TERM == null) {
                STRANDED_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("stranded");
            }
            return STRANDED_TERM;
        }

        public static ComparableTerm getOrganelleTerm() {
            if (ORGANELLE_TERM == null) {
                ORGANELLE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("organelle");
            }
            return ORGANELLE_TERM;
        }

        public static ComparableTerm getGeneNameTerm() {
            if (GENENAME_TERM == null) {
                GENENAME_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_name");
            }
            return GENENAME_TERM;
        }

        public static ComparableTerm getGeneSynonymTerm() {
            if (GENESYNONYM_TERM == null) {
                GENESYNONYM_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_synonym");
            }
            return GENESYNONYM_TERM;
        }

        public static ComparableTerm getOrderedLocusNameTerm() {
            if (ORDLOCNAME_TERM == null) {
                ORDLOCNAME_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_ordloc");
            }
            return ORDLOCNAME_TERM;
        }

        public static ComparableTerm getORFNameTerm() {
            if (ORFNAME_TERM == null) {
                ORFNAME_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_orf");
            }
            return ORFNAME_TERM;
        }

        public static ComparableTerm getStrainTerm() {
            if (STRAIN_TERM == null) {
                STRAIN_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("strain");
            }
            return STRAIN_TERM;
        }

        public static ComparableTerm getSpeciesTerm() {
            if (SPECIES_TERM == null) {
                SPECIES_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("species");
            }
            return SPECIES_TERM;
        }

        public static ComparableTerm getTissueTerm() {
            if (TISSUE_TERM == null) {
                TISSUE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("tissue");
            }
            return TISSUE_TERM;
        }

        public static ComparableTerm getTransposonTerm() {
            if (TRANSPOSON_TERM == null) {
                TRANSPOSON_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("transposon");
            }
            return TRANSPOSON_TERM;
        }

        public static ComparableTerm getPlasmidTerm() {
            if (PLASMID_TERM == null) {
                PLASMID_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("plasmid");
            }
            return PLASMID_TERM;
        }

        public static ComparableTerm getDataClassTerm() {
            if (DATACLASS_TERM == null) {
                DATACLASS_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("dataclass");
            }
            return DATACLASS_TERM;
        }

        public static ComparableTerm getFTIdTerm() {
            if (FTID_TERM == null) {
                FTID_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_id");
            }
            return FTID_TERM;
        }

        public static ComparableTerm getFeatureDescTerm() {
            if (FEATUREDESC_TERM == null) {
                FEATUREDESC_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_desc");
            }
            return FEATUREDESC_TERM;
        }

        public static ComparableTerm getCopyrightTerm() {
            if (COPYRIGHT_TERM == null) {
                COPYRIGHT_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("copyright");
            }
            return COPYRIGHT_TERM;
        }
    }
}

