/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import org.biojavax.bio.seq.Position;

public class SimplePosition
implements Position {
    private boolean fs;
    private boolean fe;
    private int s;
    private int e;
    private String t;
    private Integer id;

    public SimplePosition(int p) {
        this(false, false, p);
    }

    public SimplePosition(int s, int e) {
        this(false, false, s, e, null);
    }

    public SimplePosition(boolean fs, boolean fe, int p) {
        this(fs, fe, p, p, null);
    }

    public SimplePosition(boolean fs, boolean fe, int s, int e, String t) {
        this.fs = fs;
        this.fe = fe;
        this.s = s;
        this.e = e;
        this.t = t;
    }

    protected SimplePosition() {
    }

    public boolean getFuzzyStart() {
        return this.fs;
    }

    public boolean getFuzzyEnd() {
        return this.fe;
    }

    public int getStart() {
        return this.s;
    }

    public int getEnd() {
        return this.e;
    }

    public String getType() {
        return this.t;
    }

    private void setFuzzyStart(boolean fs) {
        this.fs = fs;
    }

    private void setFuzzyEnd(boolean fe) {
        this.fe = fe;
    }

    private void setStart(int s) {
        this.s = s;
    }

    private void setEnd(int e) {
        this.e = e;
    }

    private void setType(String t) {
        this.t = t;
    }

    public Position translate(int distance) {
        return new SimplePosition(this.fs, this.fe, this.s + distance, this.e + distance, this.t);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Position)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Position them = (Position)o;
        if (this.getFuzzyStart() != them.getFuzzyStart()) {
            return false;
        }
        if (this.getFuzzyEnd() != them.getFuzzyEnd()) {
            return false;
        }
        if (this.getStart() != them.getStart()) {
            return false;
        }
        if (this.getEnd() != them.getEnd()) {
            return false;
        }
        if (this.getType() != null || them.getType() != null) {
            if (this.getType() != null && them.getType() != null) {
                if (!this.getType().equals(them.getType())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getFuzzyStart()) {
            sb.append("<");
        }
        sb.append(this.s);
        if (this.s != this.e) {
            sb.append(this.t);
            sb.append(this.e);
        }
        if (this.getFuzzyEnd()) {
            sb.append(">");
        }
        return sb.toString();
    }

    private Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }
}

