/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import org.biojava.bio.BioException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.Namespace;
import org.biojavax.bio.seq.ThinRichSequence;

public class SimpleRichSequence
extends ThinRichSequence {
    private SymbolList symList;
    private String seqstring;

    public SimpleRichSequence(Namespace ns, String name, String accession, int version, SymbolList symList, Double seqversion) {
        super(ns, name, accession, version, symList.getAlphabet(), seqversion);
        this.symList = symList == null ? SymbolList.EMPTY_LIST : symList;
    }

    protected SimpleRichSequence() {
    }

    protected void setAlphabetName(String alphaname) throws IllegalSymbolException, BioException {
        super.setAlphabetName(alphaname);
        this.checkMakeSequence();
    }

    protected void setStringSequence(String seq) throws IllegalSymbolException, BioException {
        this.seqstring = seq;
        this.checkMakeSequence();
    }

    protected String getStringSequence() {
        return this.symList == SymbolList.EMPTY_LIST ? null : this.seqString();
    }

    private void checkMakeSequence() throws IllegalSymbolException, BioException {
        if (this.getAlphabet() != null && this.seqstring != null) {
            this.symList = new SimpleSymbolList(this.getAlphabet().getTokenization("token"), this.seqstring);
        }
    }

    public int length() {
        return this.symList.length();
    }

    protected void setSequenceLength(int length) {
    }

    protected int getSequenceLength() {
        return this.length();
    }

    public SymbolList getInternalSymbolList() {
        return this.symList;
    }
}

