/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleComment;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.GenbankLocationParser;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.utils.StringTools;

public class EMBLFormat
extends RichSequenceFormat.HeaderlessFormat {
    public static final String EMBL_PRE87_FORMAT = "EMBL_PRE87";
    public static final String EMBL_FORMAT = "EMBL";
    protected static final String LOCUS_TAG = "ID";
    protected static final String ACCESSION_TAG = "AC";
    protected static final String VERSION_TAG = "SV";
    protected static final String DEFINITION_TAG = "DE";
    protected static final String DATE_TAG = "DT";
    protected static final String DATABASE_XREF_TAG = "DR";
    protected static final String SOURCE_TAG = "OS";
    protected static final String ORGANISM_TAG = "OC";
    protected static final String ORGANELLE_TAG = "OG";
    protected static final String REFERENCE_TAG = "RN";
    protected static final String REFERENCE_POSITION_TAG = "RP";
    protected static final String REFERENCE_XREF_TAG = "RX";
    protected static final String AUTHORS_TAG = "RA";
    protected static final String CONSORTIUM_TAG = "RG";
    protected static final String TITLE_TAG = "RT";
    protected static final String LOCATOR_TAG = "RL";
    protected static final String REMARK_TAG = "RC";
    protected static final String KEYWORDS_TAG = "KW";
    protected static final String COMMENT_TAG = "CC";
    protected static final String FEATURE_HEADER_TAG = "FH";
    protected static final String FEATURE_TAG = "FT";
    protected static final String CONTIG_TAG = "CO";
    protected static final String TPA_TAG = "AH";
    protected static final String START_SEQUENCE_TAG = "SQ";
    protected static final String DELIMITER_TAG = "XX";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final Pattern dp;
    protected static final Pattern lp;
    protected static final Pattern lpPre87;
    protected static final Pattern vp;
    protected static final Pattern rpp;
    protected static final Pattern dbxp;
    protected static final Pattern readableFileNames;
    protected static final Pattern headerLine;
    static /* synthetic */ Class class$org$biojavax$SimpleCrossRef;
    static /* synthetic */ Class class$org$biojavax$SimpleDocRef;
    static /* synthetic */ Class class$org$biojavax$bio$taxa$SimpleNCBITaxon;

    public boolean canRead(File file) throws IOException {
        if (readableFileNames.matcher(file.getName()).matches()) {
            return true;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        String firstLine = br.readLine();
        boolean readable = headerLine.matcher(firstLine).matches() && (lp.matcher(firstLine.substring(3).trim()).matches() || lpPre87.matcher(firstLine.substring(3).trim()).matches());
        br.close();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String firstLine = br.readLine();
        boolean readable = headerLine.matcher(firstLine).matches() && (lp.matcher(firstLine.substring(3).trim()).matches() || lpPre87.matcher(firstLine.substring(3).trim()).matches());
        stream.reset();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        boolean hasAnotherSequence;
        block81: {
            int c;
            hasAnotherSequence = true;
            rlistener.startSequence();
            if (ns == null) {
                ns = RichObjectFactory.getDefaultNamespace();
            }
            rlistener.setNamespace(ns);
            String sectionKey = null;
            NCBITaxon tax = null;
            String organism = null;
            String accession = null;
            int xrefCount = 0;
            block12: do {
                List section;
                if ((sectionKey = ((String[])(section = this.readSection(reader)).get(0))[0]) == null) {
                    throw new ParseException("Section key was null. Accession:" + accession == null ? "Not set" : accession);
                }
                if (sectionKey.equals(LOCUS_TAG)) {
                    String loc = ((String[])section.get(0))[1];
                    Matcher m = lp.matcher(loc);
                    Matcher mPre87 = lpPre87.matcher(loc);
                    if (m.matches()) {
                        rlistener.setName(m.group(1));
                        rlistener.setAccession(m.group(1));
                        rlistener.setVersion(Integer.parseInt(m.group(2)));
                        rlistener.setCircular(m.group(3).equals("circular"));
                        rlistener.addSequenceProperty(Terms.getMolTypeTerm(), m.group(4));
                        rlistener.addSequenceProperty(Terms.getDataClassTerm(), m.group(5));
                        rlistener.setDivision(m.group(6));
                        continue;
                    }
                    if (mPre87.matches()) {
                        rlistener.setName(mPre87.group(1));
                        if (mPre87.group(3) != null) {
                            rlistener.addSequenceProperty(Terms.getGenomicTerm(), null);
                        }
                        rlistener.addSequenceProperty(Terms.getMolTypeTerm(), mPre87.group(4));
                        rlistener.setDivision(mPre87.group(5));
                        String circular = mPre87.group(2);
                        if (circular == null) continue;
                        rlistener.setCircular(true);
                        continue;
                    }
                    throw new ParseException("Bad ID line found: " + loc);
                }
                if (sectionKey.equals(DEFINITION_TAG)) {
                    rlistener.setDescription(((String[])section.get(0))[1]);
                    continue;
                }
                if (sectionKey.equals(SOURCE_TAG)) {
                    for (int i = 1; i < section.size(); ++i) {
                        sectionKey = ((String[])section.get(i))[0];
                        if (!sectionKey.equals(ORGANELLE_TAG)) continue;
                        rlistener.addSequenceProperty(Terms.getOrganelleTerm(), ((String[])section.get(i))[1].trim());
                        continue block12;
                    }
                } else {
                    if (sectionKey.equals(DATE_TAG)) {
                        String chunk = ((String[])section.get(0))[1].trim();
                        Matcher dm = dp.matcher(chunk);
                        if (dm.matches()) {
                            String date = dm.group(1);
                            String rel = dm.group(3);
                            String type = dm.group(4);
                            if (type.equals("Created")) {
                                rlistener.addSequenceProperty(Terms.getDateCreatedTerm(), date);
                                rlistener.addSequenceProperty(Terms.getRelCreatedTerm(), rel);
                                continue;
                            }
                            if (type.equals("Last updated, Version ")) {
                                rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), date);
                                rlistener.addSequenceProperty(Terms.getRelUpdatedTerm(), rel);
                                continue;
                            }
                            throw new ParseException("Bad date type found: " + type);
                        }
                        throw new ParseException("Bad date line found: " + chunk);
                    }
                    if (sectionKey.equals(ACCESSION_TAG)) {
                        String[] accs = ((String[])section.get(0))[1].split(";");
                        accession = accs[0].trim();
                        rlistener.setAccession(accession);
                        for (int i = 1; i < accs.length; ++i) {
                            rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), accs[i].trim());
                        }
                    } else {
                        if (sectionKey.equals(VERSION_TAG)) {
                            String ver = ((String[])section.get(0))[1];
                            Matcher m = vp.matcher(ver);
                            if (m.matches()) {
                                String verAcc = m.group(1);
                                if (!accession.equals(verAcc)) {
                                    rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), accession);
                                    accession = verAcc;
                                    rlistener.setAccession(accession);
                                }
                                rlistener.setVersion(Integer.parseInt(m.group(2)));
                                continue;
                            }
                            rlistener.addSequenceProperty(Terms.getVersionLineTerm(), ver);
                            continue;
                        }
                        if (sectionKey.equals(KEYWORDS_TAG)) {
                            String val = ((String[])section.get(0))[1];
                            val = val.substring(0, val.length() - 1);
                            String[] kws = val.split(";");
                            for (int i = 1; i < kws.length; ++i) {
                                rlistener.addSequenceProperty(Terms.getKeywordTerm(), kws[i].trim());
                            }
                        } else {
                            if (sectionKey.equals(DATABASE_XREF_TAG)) {
                                String val = ((String[])section.get(0))[1];
                                val = val.substring(0, val.length() - 1);
                                String[] parts = val.split(";");
                                CrossRef crossRef = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? EMBLFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{parts[0].trim(), parts[1].trim(), new Integer(0)});
                                for (int j = 2; j < parts.length; ++j) {
                                    SimpleNote note = new SimpleNote(Terms.getAdditionalAccessionTerm(), parts[j].trim(), j);
                                    try {
                                        ((RichAnnotation)crossRef.getAnnotation()).addNote(note);
                                        continue;
                                    }
                                    catch (ChangeVetoException ce) {
                                        ParseException pe = new ParseException("Could not annotate identifier terms");
                                        pe.initCause(ce);
                                        throw pe;
                                    }
                                }
                                SimpleRankedCrossRef rcrossRef = new SimpleRankedCrossRef(crossRef, ++xrefCount);
                                rlistener.setRankedCrossRef(rcrossRef);
                                continue;
                            }
                            if (sectionKey.equals(REFERENCE_TAG) && !this.getElideReferences()) {
                                String refrank = ((String[])section.get(0))[1];
                                int ref_rank = Integer.parseInt(refrank.substring(1, refrank.length() - 1));
                                int ref_start = -999;
                                int ref_end = -999;
                                String consortium = null;
                                String authors = null;
                                String title = null;
                                String locator = null;
                                String pubmed = null;
                                String medline = null;
                                String doi = null;
                                String remark = null;
                                for (int i = 1; i < section.size(); ++i) {
                                    String key = ((String[])section.get(i))[0];
                                    String val = ((String[])section.get(i))[1];
                                    if (key.equals(AUTHORS_TAG)) {
                                        if (val.endsWith(";")) {
                                            val = val.substring(0, val.length() - 1);
                                        }
                                        authors = val;
                                    }
                                    if (key.equals(CONSORTIUM_TAG)) {
                                        if (val.endsWith(";")) {
                                            val = val.substring(0, val.length() - 1);
                                        }
                                        consortium = val;
                                    }
                                    if (key.equals(TITLE_TAG)) {
                                        if (val.length() > 1) {
                                            if (val.endsWith(";")) {
                                                val = val.substring(0, val.length() - 1);
                                            }
                                            if (val.endsWith("\"")) {
                                                val = val.substring(1, val.length() - 2);
                                            }
                                            title = val;
                                        } else {
                                            title = null;
                                        }
                                    }
                                    if (key.equals(LOCATOR_TAG)) {
                                        if (val.endsWith(".")) {
                                            val = val.substring(0, val.length() - 1);
                                        }
                                        locator = val;
                                    }
                                    if (key.equals(REFERENCE_XREF_TAG)) {
                                        String[] refs = val.split("\\.(\\s+|$)");
                                        for (int j = 0; j < refs.length; ++j) {
                                            if (refs[j].trim().length() == 0) continue;
                                            String[] parts = refs[j].split(";");
                                            String db = parts[0];
                                            String ref = parts[1];
                                            if (db.equalsIgnoreCase("PUBMED")) {
                                                pubmed = ref;
                                                continue;
                                            }
                                            if (db.equalsIgnoreCase("MEDLINE")) {
                                                medline = ref;
                                                continue;
                                            }
                                            if (!db.equalsIgnoreCase("DOI")) continue;
                                            doi = ref;
                                        }
                                    }
                                    if (key.equals(REMARK_TAG)) {
                                        remark = val;
                                    }
                                    if (!key.equals(REFERENCE_POSITION_TAG)) continue;
                                    Matcher m = rpp.matcher(val);
                                    if (m.matches()) {
                                        ref_start = Integer.parseInt(m.group(1));
                                        if (m.group(2) == null) continue;
                                        ref_end = Integer.parseInt(m.group(3));
                                        continue;
                                    }
                                    throw new ParseException("Bad reference line found: " + val);
                                }
                                CrossRef pcr = null;
                                if (pubmed != null) {
                                    pcr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? EMBLFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{"PUBMED", pubmed, new Integer(0)});
                                    SimpleRankedCrossRef rpcr = new SimpleRankedCrossRef(pcr, 0);
                                    rlistener.setRankedCrossRef(rpcr);
                                }
                                CrossRef mcr = null;
                                if (medline != null) {
                                    mcr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? EMBLFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{"MEDLINE", medline, new Integer(0)});
                                    SimpleRankedCrossRef rmcr = new SimpleRankedCrossRef(mcr, 0);
                                    rlistener.setRankedCrossRef(rmcr);
                                }
                                CrossRef dcr = null;
                                if (doi != null) {
                                    dcr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? EMBLFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{"DOI", doi, new Integer(0)});
                                    SimpleRankedCrossRef rdcr = new SimpleRankedCrossRef(dcr, 0);
                                    rlistener.setRankedCrossRef(rdcr);
                                }
                                try {
                                    List authSet = DocRefAuthor.Tools.parseAuthorString(authors);
                                    if (consortium != null) {
                                        authSet.add(new SimpleDocRefAuthor(consortium, true, false));
                                    }
                                    DocRef dr = (DocRef)RichObjectFactory.getObject(class$org$biojavax$SimpleDocRef == null ? EMBLFormat.class$("org.biojavax.SimpleDocRef") : class$org$biojavax$SimpleDocRef, new Object[]{authSet, locator, title});
                                    if (mcr != null) {
                                        dr.setCrossref(mcr);
                                    } else if (pcr != null) {
                                        dr.setCrossref(pcr);
                                    } else if (dcr != null) {
                                        dr.setCrossref(dcr);
                                    }
                                    if (!this.getElideComments()) {
                                        dr.setRemark(remark);
                                    }
                                    SimpleRankedDocRef rdr = new SimpleRankedDocRef(dr, ref_start != -999 ? new Integer(ref_start) : null, ref_end != -999 ? new Integer(ref_end) : null, ref_rank);
                                    rlistener.setRankedDocRef(rdr);
                                }
                                catch (ChangeVetoException e) {
                                    throw new ParseException(e);
                                }
                            } else {
                                if (sectionKey.equals(COMMENT_TAG) && !this.getElideComments()) {
                                    rlistener.setComment(((String[])section.get(0))[1]);
                                    continue;
                                }
                                if (sectionKey.equals(FEATURE_TAG) && !this.getElideFeatures()) {
                                    boolean seenAFeature = false;
                                    for (int i = 1; i < section.size(); ++i) {
                                        String key = ((String[])section.get(i))[0];
                                        String val = ((String[])section.get(i))[1];
                                        if (key.startsWith("/")) {
                                            key = key.substring(1);
                                            if ((val = val.replaceAll("\\s*[\\n\\r]+\\s*", " ").trim()).startsWith("\"")) {
                                                val = val.substring(1, val.length() - 1);
                                            }
                                            if (key.equalsIgnoreCase("db_xref")) {
                                                Matcher m = dbxp.matcher(val);
                                                if (m.matches()) {
                                                    String dbname = m.group(1);
                                                    String raccession = m.group(2);
                                                    if (dbname.equalsIgnoreCase("taxon")) {
                                                        tax = (NCBITaxon)RichObjectFactory.getObject(class$org$biojavax$bio$taxa$SimpleNCBITaxon == null ? EMBLFormat.class$("org.biojavax.bio.taxa.SimpleNCBITaxon") : class$org$biojavax$bio$taxa$SimpleNCBITaxon, new Object[]{Integer.valueOf(raccession)});
                                                        rlistener.setTaxon(tax);
                                                        try {
                                                            if (organism == null) continue;
                                                            tax.addName("scientific name", organism);
                                                            continue;
                                                        }
                                                        catch (ChangeVetoException e) {
                                                            throw new ParseException(e);
                                                        }
                                                    }
                                                    try {
                                                        CrossRef cr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? EMBLFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{dbname, raccession, new Integer(0)});
                                                        SimpleRankedCrossRef rcr = new SimpleRankedCrossRef(cr, 0);
                                                        rlistener.getCurrentFeature().addRankedCrossRef(rcr);
                                                        continue;
                                                    }
                                                    catch (ChangeVetoException e) {
                                                        throw new ParseException(e);
                                                    }
                                                }
                                                throw new ParseException("Bad dbxref found: " + val);
                                            }
                                            if (key.equalsIgnoreCase("organism")) {
                                                try {
                                                    organism = val;
                                                    if (tax == null) continue;
                                                    tax.addName("scientific name", organism);
                                                    continue;
                                                }
                                                catch (ChangeVetoException e) {
                                                    throw new ParseException(e);
                                                }
                                            }
                                            if (key.equalsIgnoreCase("translation")) {
                                                val = val.replaceAll("\\s+", "");
                                            }
                                            rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(key), val);
                                            continue;
                                        }
                                        if (seenAFeature) {
                                            rlistener.endFeature();
                                        }
                                        RichFeature.Template templ = new RichFeature.Template();
                                        templ.annotation = new SimpleRichAnnotation();
                                        templ.sourceTerm = Terms.getEMBLTerm();
                                        templ.typeTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm(key);
                                        templ.featureRelationshipSet = new TreeSet();
                                        templ.rankedCrossRefs = new TreeSet();
                                        String tidyLocStr = val.replaceAll("\\s+", "");
                                        templ.location = GenbankLocationParser.parseLocation(ns, accession, tidyLocStr);
                                        rlistener.startFeature(templ);
                                        seenAFeature = true;
                                    }
                                    if (!seenAFeature) continue;
                                    rlistener.endFeature();
                                    continue;
                                }
                                if (!sectionKey.equals(START_SEQUENCE_TAG) || this.getElideSymbols()) continue;
                                StringBuffer seq = new StringBuffer();
                                for (int i = 0; i < section.size(); ++i) {
                                    seq.append(((String[])section.get(i))[1]);
                                }
                                try {
                                    SimpleSymbolList sl = new SimpleSymbolList(symParser, seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                                    rlistener.addSymbols(symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                                }
                                catch (Exception e) {
                                    throw new ParseException(e);
                                }
                            }
                        }
                    }
                }
            } while (!sectionKey.equals(END_SEQUENCE_TAG));
            do {
                reader.mark(1);
                c = reader.read();
                if (c != -1) continue;
                hasAnotherSequence = false;
                break block81;
            } while (Character.isWhitespace((char)c));
            reader.reset();
        }
        rlistener.endSequence();
        return hasAnotherSequence;
    }

    /*
     * Unable to fully structure code
     */
    private List readSection(BufferedReader br) throws ParseException {
        section = new ArrayList<String[]>();
        done = false;
lbl3:
        // 3 sources

        try {
            while (!done) {
                block24: {
                    br.mark(160);
                    line = br.readLine();
                    if (line.length() < 2) {
                        throw new ParseException("Bad line found: " + line);
                    }
                    token = line.substring(0, 2);
                    if (token.equals("SQ")) {
                        sb = new StringBuffer();
                        while (!done) {
                            br.mark(160);
                            line = br.readLine();
                            if (line.startsWith("//")) {
                                br.reset();
                                done = true;
                                continue;
                            }
                            sb.append(line.replaceAll("\\d", ""));
                        }
                        section.add(new String[]{"SQ", sb.toString()});
                        continue;
                    }
                    if (!token.equals("FH")) break block24;
                    section.add(new String[]{"FT", null});
                    line = br.readLine();
                    currentTag = null;
                    currentVal = null;
                    while (!done) {
                        line = br.readLine();
                        if (line.startsWith("XX")) {
                            done = true;
                            if (currentTag == null) continue;
                            section.add(new String[]{currentTag, currentVal.toString()});
                            continue;
                        }
                        if (!(line = line.substring(5)).startsWith(" ")) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            parts = line.trim().split("\\s+");
                            currentTag = parts[0];
                            currentVal = new StringBuffer();
                            currentVal.append(parts[1]);
                            continue;
                        }
                        if ((line = line.trim()).startsWith("/")) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            currentVal = new StringBuffer();
                            equalIndex = line.indexOf(61);
                            if (equalIndex >= 0) {
                                currentTag = line.substring(0, equalIndex);
                                currentVal.append(line.substring(equalIndex + 1));
                                continue;
                            }
                            currentTag = line;
                            continue;
                        }
                        currentVal.append("\n");
                        currentVal.append(line);
                    }
                    ** GOTO lbl3
                }
                if (token.equals("//")) {
                    section.add(new String[]{"//", null});
                    done = true;
                    continue;
                }
                if (token.equals("XX")) {
                    section.add(new String[]{"XX", null});
                    done = true;
                    continue;
                }
                if (token.equals("AH")) {
                    throw new ParseException("Unable to handle TPAs just yet");
                }
                if (token.equals("CO")) {
                    throw new ParseException("Unable to handle contig assemblies just yet");
                }
                if (token.equals("DR")) {
                    section.add(new String[]{"DR", line.substring(5).trim()});
                    done = true;
                    continue;
                }
                if (token.equals("DT")) {
                    section.add(new String[]{"DT", line.substring(5).trim()});
                    done = true;
                    continue;
                }
                br.reset();
                currentTag = null;
                currentVal = null;
                while (!done) {
                    line = br.readLine();
                    if (line.startsWith("XX")) {
                        done = true;
                        if (currentTag == null) continue;
                        section.add(new String[]{currentTag, currentVal.toString()});
                        continue;
                    }
                    tag = line.substring(0, 2);
                    value = line.substring(5);
                    if (currentTag == null || !tag.equals(currentTag)) {
                        if (currentTag != null) {
                            section.add(new String[]{currentTag, currentVal.toString()});
                        }
                        currentTag = tag;
                        currentVal = new StringBuffer();
                        currentVal.append(value);
                        continue;
                    }
                    currentVal.append("\n");
                    currentVal.append(value);
                }
                ** GOTO lbl3
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        return section;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        this.writeSequence(seq, format, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        this.writeSequence(seq, this.getDefaultFormat(), ns);
    }

    public void writeSequence(Sequence seq, String format, Namespace ns) throws IOException {
        Comparable c;
        NCBITaxon tax;
        SymbolTokenization tok;
        RichSequence rs;
        if (!format.equals(EMBL_FORMAT) && !format.equals(EMBL_PRE87_FORMAT)) {
            throw new IllegalArgumentException("Format " + format + " not recognised.");
        }
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        try {
            tok = rs.getAlphabet().getTokenization("token");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get alphabet tokenizer", e);
        }
        Set notes = rs.getNoteSet();
        String accession = rs.getAccession();
        StringBuffer accessions = new StringBuffer();
        accessions.append(accession);
        accessions.append(";");
        String cdat = null;
        String udat = null;
        String crel = null;
        String urel = null;
        String organelle = null;
        String versionLine = null;
        String dataClass = null;
        boolean genomic = false;
        String moltype = rs.getAlphabet().getName();
        Iterator i = notes.iterator();
        while (i.hasNext()) {
            Note n = (Note)i.next();
            if (n.getTerm().equals(Terms.getDateCreatedTerm())) {
                cdat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelCreatedTerm())) {
                crel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelUpdatedTerm())) {
                urel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getMolTypeTerm())) {
                moltype = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getVersionLineTerm())) {
                versionLine = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getGenomicTerm())) {
                genomic = true;
                continue;
            }
            if (n.getTerm().equals(Terms.getDataClassTerm())) {
                dataClass = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.append(" ");
                accessions.append(n.getValue());
                accessions.append(";");
                continue;
            }
            if (!n.getTerm().equals(Terms.getOrganelleTerm())) continue;
            organelle = n.getValue();
        }
        StringBuffer locusLine = new StringBuffer();
        if (format.equals(EMBL_FORMAT)) {
            locusLine.append(rs.getAccession());
            locusLine.append("; ");
            locusLine.append(rs.getCircular() ? "circular; " : "linear; ");
            locusLine.append(moltype);
            locusLine.append("; ");
            locusLine.append(dataClass);
            locusLine.append("; ");
            locusLine.append(rs.getDivision());
            locusLine.append("; ");
            locusLine.append(rs.length());
            locusLine.append(" BP.");
        } else if (format.equals(EMBL_PRE87_FORMAT)) {
            locusLine.append(StringTools.rightPad(rs.getName(), 9));
            locusLine.append(" standard; ");
            locusLine.append(rs.getCircular() ? "circular " : "");
            if (genomic) {
                locusLine.append("genomic ");
            }
            locusLine.append(moltype);
            locusLine.append("; ");
            locusLine.append(rs.getDivision() == null ? "" : rs.getDivision());
            locusLine.append("; ");
            locusLine.append(rs.length());
            locusLine.append(" BP.");
        }
        StringTools.writeKeyValueLine(LOCUS_TAG, locusLine.toString(), 5, this.getLineWidth(), null, LOCUS_TAG, this.getPrintStream());
        this.getPrintStream().println("XX   ");
        StringTools.writeKeyValueLine(ACCESSION_TAG, accessions.toString(), 5, this.getLineWidth(), null, ACCESSION_TAG, this.getPrintStream());
        this.getPrintStream().println("XX   ");
        if (versionLine != null) {
            StringTools.writeKeyValueLine(VERSION_TAG, versionLine, 5, this.getLineWidth(), null, VERSION_TAG, this.getPrintStream());
        } else {
            StringTools.writeKeyValueLine(VERSION_TAG, accession + "." + rs.getVersion(), 5, this.getLineWidth(), null, VERSION_TAG, this.getPrintStream());
        }
        this.getPrintStream().println("XX   ");
        StringTools.writeKeyValueLine(DATE_TAG, (cdat == null ? udat : cdat) + " (Rel. " + (crel == null ? "0" : crel) + " Created)", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, udat + " (Rel. " + (urel == null ? "0" : urel) + ", Last updated, Version " + rs.getVersion() + ")", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        this.getPrintStream().println("XX   ");
        StringTools.writeKeyValueLine(DEFINITION_TAG, rs.getDescription(), 5, this.getLineWidth(), null, DEFINITION_TAG, this.getPrintStream());
        this.getPrintStream().println("XX   ");
        StringBuffer keywords = new StringBuffer();
        Iterator n = notes.iterator();
        while (n.hasNext()) {
            Note nt = (Note)n.next();
            if (!nt.getTerm().equals(Terms.getKeywordTerm())) continue;
            if (keywords.length() > 0) {
                keywords.append("; ");
            }
            keywords.append(nt.getValue());
        }
        if (keywords.length() > 0) {
            keywords.append(".");
            StringTools.writeKeyValueLine(KEYWORDS_TAG, keywords.toString(), 5, this.getLineWidth(), null, KEYWORDS_TAG, this.getPrintStream());
            this.getPrintStream().println("XX   ");
        }
        if ((tax = rs.getTaxon()) != null) {
            StringTools.writeKeyValueLine(SOURCE_TAG, tax.getDisplayName(), 5, this.getLineWidth(), null, SOURCE_TAG, this.getPrintStream());
            StringTools.writeKeyValueLine(ORGANISM_TAG, tax.getNameHierarchy(), 5, this.getLineWidth(), null, SOURCE_TAG, this.getPrintStream());
            if (organelle != null) {
                StringTools.writeKeyValueLine(ORGANELLE_TAG, organelle, 5, this.getLineWidth(), null, ORGANELLE_TAG, this.getPrintStream());
            }
            this.getPrintStream().println("XX   ");
        }
        Iterator r = rs.getRankedDocRefs().iterator();
        while (r.hasNext()) {
            Integer rend;
            RankedDocRef rdr = (RankedDocRef)r.next();
            DocRef d = rdr.getDocumentReference();
            StringTools.writeKeyValueLine(REFERENCE_TAG, "[" + rdr.getRank() + "]", 5, this.getLineWidth(), null, REFERENCE_TAG, this.getPrintStream());
            StringTools.writeKeyValueLine(REMARK_TAG, d.getRemark(), 5, this.getLineWidth(), null, REMARK_TAG, this.getPrintStream());
            Integer rstart = rdr.getStart();
            if (rstart == null) {
                rstart = new Integer(1);
            }
            if ((rend = rdr.getEnd()) == null) {
                rend = new Integer(rs.length());
            }
            StringTools.writeKeyValueLine(REFERENCE_POSITION_TAG, rstart + "-" + rend, 5, this.getLineWidth(), null, REFERENCE_POSITION_TAG, this.getPrintStream());
            CrossRef c2 = d.getCrossref();
            if (c2 != null) {
                StringTools.writeKeyValueLine(REFERENCE_XREF_TAG, c2.getDbname() + "; " + c2.getAccession() + ".", 5, this.getLineWidth(), null, REFERENCE_XREF_TAG, this.getPrintStream());
            }
            List auths = d.getAuthorList();
            Iterator j = auths.iterator();
            while (j.hasNext()) {
                DocRefAuthor a = (DocRefAuthor)j.next();
                if (!a.isConsortium()) continue;
                StringTools.writeKeyValueLine(CONSORTIUM_TAG, a + ";", 5, this.getLineWidth(), null, CONSORTIUM_TAG, this.getPrintStream());
                j.remove();
            }
            if (!auths.isEmpty()) {
                StringTools.writeKeyValueLine(AUTHORS_TAG, DocRefAuthor.Tools.generateAuthorString(auths) + ";", 5, this.getLineWidth(), null, AUTHORS_TAG, this.getPrintStream());
            }
            if (d.getTitle() != null && d.getTitle().length() != 0) {
                StringTools.writeKeyValueLine(TITLE_TAG, "\"" + d.getTitle() + "\";", 5, this.getLineWidth(), null, TITLE_TAG, this.getPrintStream());
            } else {
                StringTools.writeKeyValueLine(TITLE_TAG, ";", 5, this.getLineWidth(), null, TITLE_TAG, this.getPrintStream());
            }
            StringTools.writeKeyValueLine(LOCATOR_TAG, d.getLocation() + ".", 5, this.getLineWidth(), null, LOCATOR_TAG, this.getPrintStream());
            this.getPrintStream().println("XX   ");
        }
        r = rs.getRankedCrossRefs().iterator();
        while (r.hasNext()) {
            RankedCrossRef rcr = (RankedCrossRef)r.next();
            c = rcr.getCrossRef();
            Set noteset = c.getNoteSet();
            StringBuffer sb = new StringBuffer();
            sb.append(c.getDbname());
            sb.append("; ");
            sb.append(c.getAccession());
            boolean hasSecondary = false;
            Iterator i2 = noteset.iterator();
            while (i2.hasNext()) {
                Note n2 = (Note)i2.next();
                if (!n2.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                sb.append("; ");
                sb.append(n2.getValue());
                hasSecondary = true;
            }
            if (!hasSecondary) {
                sb.append("; -");
            }
            sb.append(".");
            StringTools.writeKeyValueLine(DATABASE_XREF_TAG, sb.toString(), 5, this.getLineWidth(), null, DATABASE_XREF_TAG, this.getPrintStream());
        }
        this.getPrintStream().println("XX   ");
        if (!rs.getComments().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator i3 = rs.getComments().iterator();
            while (i3.hasNext()) {
                c = (SimpleComment)i3.next();
                sb.append(c.getComment());
                if (!i3.hasNext()) continue;
                sb.append("\n");
            }
            StringTools.writeKeyValueLine(COMMENT_TAG, sb.toString(), 5, this.getLineWidth(), null, COMMENT_TAG, this.getPrintStream());
            this.getPrintStream().println("XX   ");
        }
        this.getPrintStream().println("FH   Key             Location/Qualifiers");
        this.getPrintStream().println("FH   ");
        Iterator i4 = rs.getFeatureSet().iterator();
        while (i4.hasNext()) {
            RichFeature f = (RichFeature)i4.next();
            StringTools.writeKeyValueLine("FT   " + f.getTypeTerm().getName(), GenbankLocationParser.writeLocation((RichLocation)f.getLocation()), 21, this.getLineWidth(), ",", FEATURE_TAG, this.getPrintStream());
            Iterator j = f.getNoteSet().iterator();
            while (j.hasNext()) {
                Note n3 = (Note)j.next();
                if (n3.getValue() == null || n3.getValue().length() == 0) {
                    StringTools.writeKeyValueLine(FEATURE_TAG, "/" + n3.getTerm().getName(), 21, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
                    continue;
                }
                StringTools.writeKeyValueLine(FEATURE_TAG, "/" + n3.getTerm().getName() + "=\"" + n3.getValue() + "\"", 21, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
            }
            if (f.getType().equals("source") && tax != null) {
                String displayName = tax.getDisplayName();
                if (displayName.indexOf(40) > -1) {
                    displayName = displayName.substring(0, displayName.indexOf(40)).trim();
                }
                StringTools.writeKeyValueLine(FEATURE_TAG, "/organism=\"" + displayName + "\"", 21, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
                StringTools.writeKeyValueLine(FEATURE_TAG, "/db_xref=\"taxon:" + tax.getNCBITaxID() + "\"", 21, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
            }
            j = f.getRankedCrossRefs().iterator();
            while (j.hasNext()) {
                RankedCrossRef rcr = (RankedCrossRef)j.next();
                CrossRef cr = rcr.getCrossRef();
                StringTools.writeKeyValueLine(FEATURE_TAG, "/db_xref=\"taxon:" + cr.getDbname() + ":" + cr.getAccession() + "\"", 21, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
            }
        }
        this.getPrintStream().println("XX   ");
        int aCount = 0;
        int cCount = 0;
        int gCount = 0;
        int tCount = 0;
        int oCount = 0;
        block24: for (int i5 = 1; i5 <= rs.length(); ++i5) {
            char c3;
            try {
                c3 = tok.tokenizeSymbol(rs.symbolAt(i5)).charAt(0);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get symbol at position " + i5, e);
            }
            switch (c3) {
                case 'A': 
                case 'a': {
                    ++aCount;
                    continue block24;
                }
                case 'C': 
                case 'c': {
                    ++cCount;
                    continue block24;
                }
                case 'G': 
                case 'g': {
                    ++gCount;
                    continue block24;
                }
                case 'T': 
                case 't': {
                    ++tCount;
                    continue block24;
                }
                default: {
                    ++oCount;
                }
            }
        }
        this.getPrintStream().print("SQ   " + rs.length() + " BP; ");
        this.getPrintStream().print(aCount + " A; ");
        this.getPrintStream().print(cCount + " C; ");
        this.getPrintStream().print(gCount + " G; ");
        this.getPrintStream().print(tCount + " T; ");
        this.getPrintStream().println(oCount + " other;");
        Symbol[] syms = rs.toList().toArray(new Symbol[0]);
        int lineLen = 0;
        int symCount = 0;
        this.getPrintStream().print("    ");
        for (int i6 = 0; i6 < syms.length; ++i6) {
            if (symCount % 60 == 0 && symCount > 0) {
                this.getPrintStream().print(StringTools.leftPad("" + symCount, 10));
                this.getPrintStream().print("\n    ");
                lineLen = 0;
            }
            if (symCount % 10 == 0) {
                this.getPrintStream().print(" ");
                ++lineLen;
            }
            try {
                this.getPrintStream().print(tok.tokenizeSymbol(syms[i6]));
            }
            catch (IllegalSymbolException e) {
                throw new RuntimeException("Found illegal symbol: " + syms[i6]);
            }
            ++symCount;
            ++lineLen;
        }
        this.getPrintStream().print(StringTools.leftPad("" + symCount, 66 - lineLen + 10));
        this.getPrintStream().print("\n");
        this.getPrintStream().println(END_SEQUENCE_TAG);
    }

    public String getDefaultFormat() {
        return EMBL_FORMAT;
    }

    static {
        RichSequence.IOTools.registerFormat(EMBLFormat.class);
        dp = Pattern.compile("([^\\s]+)\\s*(\\(Rel\\.\\s+(\\d+), ([^\\)\\d]+)\\d*\\))?$");
        lp = Pattern.compile("^(\\S+);\\s+SV\\s+(\\d+);\\s+(linear|circular);\\s+(\\S+);\\s+(\\S+);\\s+(\\S+);\\s+(\\d+)\\s+BP\\.$");
        lpPre87 = Pattern.compile("^(\\S+)\\s+standard;\\s+(circular)?\\s*(genomic)?\\s*(\\S+);\\s+(\\S+);\\s+\\d+\\s+BP\\.$");
        vp = Pattern.compile("^(\\S+?)\\.(\\d+)$");
        rpp = Pattern.compile("^(\\d+)(-(\\d+))?,?(\\s\\d+-\\d+,?)*$");
        dbxp = Pattern.compile("^([^:]+):(\\S+)$");
        readableFileNames = Pattern.compile(".*\\u002e(em|dat).*");
        headerLine = Pattern.compile("^ID.*");
    }

    public static class Terms
    extends RichSequence.Terms {
        private static ComparableTerm EMBL_TERM = null;
        private static ComparableTerm GENOMIC_TERM = null;
        private static ComparableTerm VERSION_LINE_TERM = null;
        private static ComparableTerm DATA_CLASS_TERM = null;

        public static ComparableTerm getEMBLTerm() {
            if (EMBL_TERM == null) {
                EMBL_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm(EMBLFormat.EMBL_FORMAT);
            }
            return EMBL_TERM;
        }

        public static ComparableTerm getGenomicTerm() {
            if (GENOMIC_TERM == null) {
                GENOMIC_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("genomic");
            }
            return GENOMIC_TERM;
        }

        public static ComparableTerm getVersionLineTerm() {
            if (VERSION_LINE_TERM == null) {
                VERSION_LINE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("versionLine");
            }
            return VERSION_LINE_TERM;
        }

        public static ComparableTerm getDataClassTerm() {
            if (DATA_CLASS_TERM == null) {
                DATA_CLASS_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("dataClass");
            }
            return DATA_CLASS_TERM;
        }
    }
}

