/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.biojava.utils.xml.XMLWriter;
import org.biojavax.Comment;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.GenbankLocationParser;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.utils.StringTools;
import org.biojavax.utils.XMLTools;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EMBLxmlFormat
extends RichSequenceFormat.BasicFormat {
    public static final String EMBLXML_FORMAT = "EMBLxml";
    protected static final String ENTRY_GROUP_TAG = "EMBL";
    protected static final String ENTRY_TAG = "entry";
    protected static final String ENTRY_ACCESSION_ATTR = "accession";
    protected static final String ENTRY_NAME_ATTR = "name";
    protected static final String ENTRY_DIVISION_ATTR = "division";
    protected static final String ENTRY_CREATED_ATTR = "created";
    protected static final String ENTRY_RELCREATED_ATTR = "releaseCreated";
    protected static final String ENTRY_UPDATED_ATTR = "lastUpdated";
    protected static final String ENTRY_RELUPDATED_ATTR = "releaseLastUpdated";
    protected static final String ENTRY_VER_ATTR = "version";
    protected static final String SEC_ACC_TAG = "secondaryAccession";
    protected static final String DESC_TAG = "description";
    protected static final String KEYWORD_TAG = "keyword";
    protected static final String REFERENCE_TAG = "reference";
    protected static final String CITATION_TAG = "citation";
    protected static final String CITATION_ID_ATTR = "id";
    protected static final String CITATION_TYPE_ATTR = "type";
    protected static final String CITATION_DATE_ATTR = "date";
    protected static final String CITATION_NAME_ATTR = "name";
    protected static final String CITATION_VOL_ATTR = "volume";
    protected static final String CITATION_ISSUE_ATTR = "issue";
    protected static final String CITATION_FIRST_ATTR = "first";
    protected static final String CITATION_LAST_ATTR = "last";
    protected static final String CITATION_PUB_ATTR = "publisher";
    protected static final String CITATION_PATENT_ATTR = "patentNumber";
    protected static final String CITATION_INSTITUTE_ATTR = "institute";
    protected static final String CITATION_YEAR_ATTR = "year";
    protected static final String DBREFERENCE_TAG = "dbreference";
    protected static final String DBREF_DB_ATTR = "db";
    protected static final String DBREF_PRIMARY_ATTR = "primary";
    protected static final String DBREF_SEC_ATTR = "secondary";
    protected static final String CONSORTIUM_TAG = "consortium";
    protected static final String TITLE_TAG = "title";
    protected static final String EDITOR_TAG = "editor";
    protected static final String AUTHOR_TAG = "author";
    protected static final String PATENT_TAG = "patentApplicant";
    protected static final String LOCATOR_TAG = "locator";
    protected static final String REFERENCE_POSITION_TAG = "refPosition";
    protected static final String REF_POS_BEGIN_ATTR = "begin";
    protected static final String REF_POS_END_ATTR = "end";
    protected static final String COMMENT_TAG = "comment";
    protected static final String FEATURE_TAG = "feature";
    protected static final String FEATURE_NAME_ATTR = "name";
    protected static final String ORGANISM_TAG = "organism";
    protected static final String NAMESET_TAG = "nameSet";
    protected static final String SCINAME_TAG = "scientificName";
    protected static final String COMNAME_TAG = "preferredCommonName";
    protected static final String TAXID_TAG = "taxId";
    protected static final String LINEAGE_TAG = "lineage";
    protected static final String TAXON_TAG = "taxon";
    protected static final String QUALIFIER_TAG = "qualifier";
    protected static final String QUALIFIER_NAME_ATTR = "name";
    protected static final String LOCATION_TAG = "location";
    protected static final String LOCATION_TYPE_ATTR = "type";
    protected static final String LOCATION_COMPL_ATTR = "complement";
    protected static final String LOCATION_ELEMENT_TAG = "locationElement";
    protected static final String LOC_ELEMENT_TYPE_ATTR = "type";
    protected static final String LOC_ELEMENT_ACC_ATTR = "accession";
    protected static final String LOC_ELEMENT_VER_ATTR = "version";
    protected static final String LOC_ELEMENT_COMPL_ATTR = "complement";
    protected static final String BASEPOSITION_TAG = "basePosition";
    protected static final String BASEPOSITION_TYPE_ATTR = "type";
    protected static final String BASEPOSITION_EXTENT_ATTR = "extent";
    protected static final String SEQUENCE_TAG = "sequence";
    protected static final String SEQUENCE_TYPE_ATTR = "type";
    protected static final String SEQUENCE_LENGTH_ATTR = "length";
    protected static final String SEQUENCE_TOPOLOGY_ATTR = "topology";
    protected static final String SEQUENCE_VER_ATTR = "version";
    protected static final Pattern xmlSchema;
    private PrintWriter pw;
    private XMLWriter xml;
    static /* synthetic */ Class class$org$biojavax$SimpleCrossRef;
    static /* synthetic */ Class class$org$biojavax$SimpleDocRef;
    static /* synthetic */ Class class$org$biojavax$bio$taxa$SimpleNCBITaxon;

    public boolean canRead(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        br.readLine();
        boolean readable = xmlSchema.matcher(br.readLine()).matches();
        br.close();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        br.readLine();
        boolean readable = xmlSchema.matcher(br.readLine()).matches();
        stream.reset();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        try {
            EMBLxmlHandler m_handler = new EMBLxmlHandler(this, symParser, rlistener, ns);
            return XMLTools.readXMLChunk(reader, m_handler, ENTRY_TAG);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    public void beginWriting() throws IOException {
        this.pw = new PrintWriter(this.getPrintStream());
        this.xml = new PrettyXMLWriter(this.pw);
        this.xml.printRaw("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.xml.openTag(ENTRY_GROUP_TAG);
        this.xml.attribute("xmlns", "ebi", "http://www.ebi.ac.uk/xml");
        this.xml.attribute("xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xml.attribute("xsi", "noNamespaceSchemaLocation", "http://www.ebi.ac.uk/schema/EMBL_schema.xsd");
    }

    public void finishWriting() throws IOException {
        this.xml.closeTag(ENTRY_GROUP_TAG);
        this.pw.flush();
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(this.getPrintStream());
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(this.getPrintStream());
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        Note n;
        Iterator j;
        Iterator j2;
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        Set notes = rs.getNoteSet();
        ArrayList<String> accessions = new ArrayList<String>();
        ArrayList<String> kws = new ArrayList<String>();
        String cdat = null;
        String udat = null;
        String crel = null;
        String urel = null;
        String moltype = rs.getAlphabet().getName();
        Iterator i = notes.iterator();
        while (i.hasNext()) {
            Note n2 = (Note)i.next();
            if (n2.getTerm().equals(Terms.getDateCreatedTerm())) {
                cdat = n2.getValue();
                continue;
            }
            if (n2.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n2.getValue();
                continue;
            }
            if (n2.getTerm().equals(Terms.getRelCreatedTerm())) {
                crel = n2.getValue();
                continue;
            }
            if (n2.getTerm().equals(Terms.getRelUpdatedTerm())) {
                urel = n2.getValue();
                continue;
            }
            if (n2.getTerm().equals(Terms.getMolTypeTerm())) {
                moltype = n2.getValue();
                continue;
            }
            if (n2.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.add(n2.getValue());
                continue;
            }
            if (!n2.getTerm().equals(Terms.getKeywordTerm())) continue;
            kws.add(n2.getValue());
        }
        this.xml.openTag(ENTRY_TAG);
        this.xml.attribute("accession", rs.getAccession());
        this.xml.attribute("name", rs.getName());
        this.xml.attribute(ENTRY_DIVISION_ATTR, rs.getDivision());
        this.xml.attribute(ENTRY_CREATED_ATTR, cdat == null ? udat : cdat);
        this.xml.attribute(ENTRY_RELCREATED_ATTR, crel == null ? "0" : crel);
        this.xml.attribute(ENTRY_UPDATED_ATTR, udat);
        this.xml.attribute(ENTRY_RELUPDATED_ATTR, urel == null ? "0" : urel);
        this.xml.attribute("version", "" + rs.getVersion());
        i = accessions.iterator();
        while (i.hasNext()) {
            this.xml.openTag(SEC_ACC_TAG);
            this.xml.print((String)i.next());
            this.xml.closeTag(SEC_ACC_TAG);
        }
        this.xml.openTag(DESC_TAG);
        this.xml.print(rs.getDescription());
        this.xml.closeTag(DESC_TAG);
        i = kws.iterator();
        while (i.hasNext()) {
            this.xml.openTag(KEYWORD_TAG);
            this.xml.print((String)i.next());
            this.xml.closeTag(KEYWORD_TAG);
        }
        i = rs.getRankedDocRefs().iterator();
        while (i.hasNext()) {
            DocRefAuthor a;
            RankedDocRef rdr = (RankedDocRef)i.next();
            DocRef dr = rdr.getDocumentReference();
            this.xml.openTag(REFERENCE_TAG);
            this.xml.openTag(CITATION_TAG);
            this.xml.attribute(CITATION_ID_ATTR, "" + rdr.getRank());
            this.xml.attribute("type", "journal article");
            CrossRef cr = dr.getCrossref();
            if (cr != null) {
                this.xml.openTag(DBREFERENCE_TAG);
                this.xml.attribute(DBREF_DB_ATTR, cr.getDbname());
                this.xml.attribute(DBREF_PRIMARY_ATTR, cr.getAccession());
                if (!cr.getNoteSet().isEmpty()) {
                    Iterator j3 = cr.getNoteSet().iterator();
                    while (j3.hasNext()) {
                        Note n3 = (Note)j3.next();
                        if (!n3.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                        this.xml.attribute(DBREF_SEC_ATTR, n3.getValue());
                        break;
                    }
                }
                this.xml.closeTag(DBREFERENCE_TAG);
            }
            List auths = dr.getAuthorList();
            j2 = auths.iterator();
            while (j2.hasNext()) {
                a = (DocRefAuthor)j2.next();
                if (!a.isConsortium()) continue;
                this.xml.openTag(CONSORTIUM_TAG);
                this.xml.print(a.getName());
                this.xml.closeTag(CONSORTIUM_TAG);
                j2.remove();
            }
            if (dr.getTitle() != null) {
                this.xml.openTag(TITLE_TAG);
                this.xml.print(dr.getTitle());
                this.xml.closeTag(TITLE_TAG);
            }
            j2 = auths.iterator();
            while (j2.hasNext()) {
                a = (DocRefAuthor)j2.next();
                if (a.isEditor()) {
                    this.xml.openTag(EDITOR_TAG);
                    this.xml.print(a.getName());
                    this.xml.closeTag(EDITOR_TAG);
                    continue;
                }
                this.xml.openTag(AUTHOR_TAG);
                this.xml.print(a.getName());
                this.xml.closeTag(AUTHOR_TAG);
            }
            this.xml.openTag(LOCATOR_TAG);
            this.xml.print(dr.getLocation());
            this.xml.closeTag(LOCATOR_TAG);
            this.xml.closeTag(CITATION_TAG);
            this.xml.openTag(REFERENCE_POSITION_TAG);
            this.xml.attribute(REF_POS_BEGIN_ATTR, "" + rdr.getStart());
            this.xml.attribute(REF_POS_END_ATTR, "" + rdr.getEnd());
            this.xml.closeTag(REFERENCE_POSITION_TAG);
            if (dr.getRemark() != null) {
                this.xml.openTag(COMMENT_TAG);
                this.xml.print(dr.getRemark());
                this.xml.closeTag(COMMENT_TAG);
            }
            this.xml.closeTag(REFERENCE_TAG);
        }
        i = rs.getRankedCrossRefs().iterator();
        while (i.hasNext()) {
            RankedCrossRef rcr = (RankedCrossRef)i.next();
            CrossRef cr = rcr.getCrossRef();
            this.xml.openTag(DBREFERENCE_TAG);
            this.xml.attribute(DBREF_DB_ATTR, cr.getDbname());
            this.xml.attribute(DBREF_PRIMARY_ATTR, cr.getAccession());
            if (!cr.getNoteSet().isEmpty()) {
                j = cr.getNoteSet().iterator();
                while (j.hasNext()) {
                    n = (Note)j.next();
                    if (!n.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                    this.xml.attribute(DBREF_SEC_ATTR, n.getValue());
                    break;
                }
            }
            this.xml.closeTag(DBREFERENCE_TAG);
        }
        i = rs.getComments().iterator();
        while (i.hasNext()) {
            this.xml.openTag(COMMENT_TAG);
            this.xml.println(((Comment)i.next()).getComment());
            this.xml.closeTag(COMMENT_TAG);
        }
        NCBITaxon tax = rs.getTaxon();
        Iterator i2 = rs.getFeatureSet().iterator();
        while (i2.hasNext()) {
            RichFeature f = (RichFeature)i2.next();
            this.xml.openTag(FEATURE_TAG);
            this.xml.attribute("name", f.getTypeTerm().getName());
            if (f.getTypeTerm().getName().equals("source") && tax != null) {
                this.xml.openTag(ORGANISM_TAG);
                String[] parts = tax.getDisplayName().split("(\\(|\\))");
                this.xml.openTag(NAMESET_TAG);
                this.xml.openTag(SCINAME_TAG);
                this.xml.print(parts[0].trim());
                this.xml.closeTag(SCINAME_TAG);
                if (parts.length > 1) {
                    this.xml.openTag(COMNAME_TAG);
                    this.xml.print(parts[1].trim());
                    this.xml.closeTag(COMNAME_TAG);
                }
                this.xml.closeTag(NAMESET_TAG);
                this.xml.openTag(TAXID_TAG);
                this.xml.print("" + tax.getNCBITaxID());
                this.xml.closeTag(TAXID_TAG);
                String hierarchy = tax.getNameHierarchy();
                hierarchy = hierarchy.substring(0, hierarchy.length() - 1);
                if (hierarchy.length() > 0) {
                    parts = hierarchy.split(";");
                    this.xml.openTag(LINEAGE_TAG);
                    for (int j4 = 0; j4 < parts.length; ++j4) {
                        this.xml.openTag(TAXON_TAG);
                        this.xml.print(parts[j4].trim());
                        this.xml.closeTag(TAXON_TAG);
                    }
                    this.xml.closeTag(LINEAGE_TAG);
                }
                this.xml.closeTag(ORGANISM_TAG);
            }
            j = f.getRankedCrossRefs().iterator();
            while (j.hasNext()) {
                RankedCrossRef rcr = (RankedCrossRef)j.next();
                CrossRef cr = rcr.getCrossRef();
                this.xml.openTag(DBREFERENCE_TAG);
                this.xml.attribute(DBREF_DB_ATTR, cr.getDbname());
                this.xml.attribute(DBREF_PRIMARY_ATTR, cr.getAccession());
                if (!cr.getNoteSet().isEmpty()) {
                    Iterator k = cr.getNoteSet().iterator();
                    while (k.hasNext()) {
                        Note n4 = (Note)k.next();
                        if (!n4.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                        this.xml.attribute(DBREF_SEC_ATTR, n4.getValue());
                        break;
                    }
                }
                this.xml.closeTag(DBREFERENCE_TAG);
            }
            j = f.getNoteSet().iterator();
            while (j.hasNext()) {
                n = (Note)j.next();
                this.xml.openTag(QUALIFIER_TAG);
                this.xml.attribute("name", n.getTerm().getName());
                if (n.getValue() != null && !n.getValue().equals("")) {
                    if (n.getTerm().getName().equalsIgnoreCase("translation")) {
                        String[] lines = StringTools.wordWrap(n.getValue(), "\\s+", this.getLineWidth());
                        for (int k = 0; k < lines.length; ++k) {
                            this.xml.println(lines[k]);
                        }
                    } else {
                        this.xml.print(n.getValue());
                    }
                }
                this.xml.closeTag(QUALIFIER_TAG);
            }
            RichLocation rle = (RichLocation)f.getLocation();
            Collection locElements = RichLocation.Tools.flatten(rle);
            this.xml.openTag(LOCATION_TAG);
            this.xml.attribute("type", locElements.size() > 1 ? rle.getTerm().getName() : "single");
            this.xml.attribute("complement", "false");
            j2 = locElements.iterator();
            while (j2.hasNext()) {
                Position end;
                Position start;
                RichLocation rl = (RichLocation)j2.next();
                this.xml.openTag(LOCATION_ELEMENT_TAG);
                if (rl.getStrand().equals(RichLocation.Strand.NEGATIVE_STRAND)) {
                    this.xml.attribute("complement", "true");
                } else {
                    this.xml.attribute("complement", "false");
                }
                if (rl.getCrossRef() != null) {
                    this.xml.attribute("accession", rl.getCrossRef().getAccession());
                    this.xml.attribute("version", "" + rl.getCrossRef().getVersion());
                }
                if ((start = rl.getMinPosition()).equals(end = rl.getMaxPosition())) {
                    this.xml.attribute("type", "site");
                    this.xml.openTag(BASEPOSITION_TAG);
                    if (start.getFuzzyStart()) {
                        this.xml.attribute("type", "<");
                    } else if (start.getFuzzyEnd()) {
                        this.xml.attribute("type", "<");
                    } else if (start.getType() != null) {
                        this.xml.attribute("type", "fuzzy");
                        this.xml.attribute(BASEPOSITION_EXTENT_ATTR, "+" + (start.getEnd() - start.getStart()));
                    } else {
                        this.xml.attribute("type", "simple");
                    }
                    this.xml.print("" + start.getStart());
                    this.xml.closeTag(BASEPOSITION_TAG);
                } else {
                    this.xml.attribute("type", "range");
                    this.xml.openTag(BASEPOSITION_TAG);
                    if (start.getFuzzyStart()) {
                        this.xml.attribute("type", "<");
                    } else if (start.getFuzzyEnd()) {
                        this.xml.attribute("type", "<");
                    } else if (start.getType() != null) {
                        this.xml.attribute("type", "fuzzy");
                        this.xml.attribute(BASEPOSITION_EXTENT_ATTR, "+" + (start.getEnd() - start.getStart()));
                    } else {
                        this.xml.attribute("type", "simple");
                    }
                    this.xml.print("" + start.getStart());
                    this.xml.closeTag(BASEPOSITION_TAG);
                    this.xml.openTag(BASEPOSITION_TAG);
                    if (end.getFuzzyStart()) {
                        this.xml.attribute("type", "<");
                    } else if (end.getFuzzyEnd()) {
                        this.xml.attribute("type", "<");
                    } else if (end.getType() != null) {
                        this.xml.attribute("type", "fuzzy");
                        this.xml.attribute(BASEPOSITION_EXTENT_ATTR, "+" + (end.getEnd() - end.getStart()));
                    } else {
                        this.xml.attribute("type", "simple");
                    }
                    this.xml.print("" + end.getStart());
                    this.xml.closeTag(BASEPOSITION_TAG);
                }
                this.xml.closeTag(LOCATION_ELEMENT_TAG);
            }
            this.xml.closeTag(LOCATION_TAG);
            this.xml.closeTag(FEATURE_TAG);
        }
        this.xml.openTag(SEQUENCE_TAG);
        this.xml.attribute("type", moltype);
        this.xml.attribute(SEQUENCE_LENGTH_ATTR, "" + rs.length());
        if (rs.getCircular()) {
            this.xml.attribute(SEQUENCE_TOPOLOGY_ATTR, "circular");
        }
        this.xml.attribute("version", "" + rs.getSeqVersion());
        String[] lines = StringTools.wordWrap(rs.seqString(), "\\s+", this.getLineWidth());
        for (int i3 = 0; i3 < lines.length; ++i3) {
            this.xml.println(lines[i3]);
        }
        this.xml.closeTag(SEQUENCE_TAG);
        this.xml.closeTag(ENTRY_TAG);
        this.pw.flush();
    }

    public String getDefaultFormat() {
        return EMBLXML_FORMAT;
    }

    static {
        RichSequence.IOTools.registerFormat(EMBLxmlFormat.class);
        xmlSchema = Pattern.compile(".*http://www\\.ebi\\.ac\\.uk/schema/EMBL_schema\\.xsd.*");
    }

    private class EMBLxmlHandler
    extends DefaultHandler {
        private RichSequenceFormat parent;
        private SymbolTokenization symParser;
        private RichSeqIOListener rlistener;
        private Namespace ns;
        private StringBuffer m_currentString;
        private NCBITaxon tax;
        private String accession;
        private RichFeature.Template templ;
        private String currFeatQual;
        private String currRefLocation;
        private List currRefAuthors;
        private String currRefTitle;
        private Map currNames = new TreeMap();
        private int currRefStart;
        private int currRefEnd;
        private int currRefRank;
        private int currLocBrackets;
        private int currLocElemBrackets;
        private StringBuffer currLocStr;
        private String currBaseType;
        private String currBaseExtent;
        private boolean firstBase;
        private boolean firstLocationElement;
        private List currDBXrefs = new ArrayList();
        private List currComments = new ArrayList();
        private Map currQuals = new LinkedHashMap();

        private EMBLxmlHandler(RichSequenceFormat parent, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) {
            this.parent = parent;
            this.symParser = symParser;
            this.rlistener = rlistener;
            this.ns = ns;
            this.m_currentString = new StringBuffer();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(EMBLxmlFormat.ENTRY_TAG)) {
                try {
                    this.rlistener.startSequence();
                    if (this.ns == null) {
                        this.ns = RichObjectFactory.getDefaultNamespace();
                    }
                    this.rlistener.setNamespace(this.ns);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getQName(i);
                        String val = attributes.getValue(i);
                        if (name.equals("accession")) {
                            this.accession = val;
                            this.rlistener.setAccession(this.accession);
                            continue;
                        }
                        if (name.equals("name")) {
                            this.rlistener.setName(val);
                            continue;
                        }
                        if (name.equals(EMBLxmlFormat.ENTRY_DIVISION_ATTR)) {
                            this.rlistener.setDivision(val);
                            continue;
                        }
                        if (name.equals(EMBLxmlFormat.ENTRY_CREATED_ATTR)) {
                            this.rlistener.addSequenceProperty(Terms.getDateCreatedTerm(), val);
                            continue;
                        }
                        if (name.equals(EMBLxmlFormat.ENTRY_UPDATED_ATTR)) {
                            this.rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), val);
                            continue;
                        }
                        if (name.equals(EMBLxmlFormat.ENTRY_RELCREATED_ATTR)) {
                            this.rlistener.addSequenceProperty(Terms.getRelCreatedTerm(), val);
                            continue;
                        }
                        if (name.equals(EMBLxmlFormat.ENTRY_RELUPDATED_ATTR)) {
                            this.rlistener.addSequenceProperty(Terms.getRelUpdatedTerm(), val);
                            continue;
                        }
                        if (!name.equals("version")) continue;
                        this.rlistener.setVersion(Integer.parseInt(val));
                    }
                    this.currNames.clear();
                    this.currComments.clear();
                    this.currDBXrefs.clear();
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
            if (qName.equals(EMBLxmlFormat.REFERENCE_TAG) && !this.parent.getElideReferences()) {
                this.currRefLocation = null;
                this.currRefAuthors = new ArrayList();
                this.currRefTitle = null;
                this.currRefStart = -999;
                this.currRefEnd = -999;
                this.currRefRank = 0;
                this.currDBXrefs.clear();
                this.currComments.clear();
            } else if (qName.equals(EMBLxmlFormat.REFERENCE_POSITION_TAG) && !this.parent.getElideReferences()) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (name.equals(EMBLxmlFormat.REF_POS_BEGIN_ATTR)) {
                        this.currRefStart = Integer.parseInt(val);
                        continue;
                    }
                    if (!name.equals(EMBLxmlFormat.REF_POS_END_ATTR)) continue;
                    this.currRefEnd = Integer.parseInt(val);
                }
            } else if (qName.equals(EMBLxmlFormat.CITATION_TAG) && !this.parent.getElideReferences()) {
                StringBuffer currRef = new StringBuffer();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (name.equals(EMBLxmlFormat.CITATION_ID_ATTR)) {
                        this.currRefRank = Integer.parseInt(val);
                        continue;
                    }
                    if (name.equals("type")) continue;
                    if (currRef.length() > 0) {
                        currRef.append(" ");
                    }
                    currRef.append(val);
                }
                this.currRefLocation = currRef.toString();
            } else if (qName.equals(EMBLxmlFormat.DBREFERENCE_TAG)) {
                String db = null;
                String primary = null;
                String secondary = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (name.equals(EMBLxmlFormat.DBREF_DB_ATTR)) {
                        db = val;
                        continue;
                    }
                    if (name.equals(EMBLxmlFormat.DBREF_PRIMARY_ATTR)) {
                        primary = val;
                        continue;
                    }
                    if (!name.equals(EMBLxmlFormat.DBREF_SEC_ATTR)) continue;
                    secondary = val;
                }
                CrossRef dbx = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? (class$org$biojavax$SimpleCrossRef = EMBLxmlFormat.class$("org.biojavax.SimpleCrossRef")) : class$org$biojavax$SimpleCrossRef, new Object[]{db, primary, new Integer(0)});
                if (secondary != null) {
                    SimpleNote note = new SimpleNote(Terms.getAdditionalAccessionTerm(), secondary, 0);
                    try {
                        ((RichAnnotation)dbx.getAnnotation()).addNote(note);
                    }
                    catch (ChangeVetoException ce) {
                        SAXException pe = new SAXException("Could not annotate identifier terms");
                        pe.initCause(ce);
                        throw pe;
                    }
                }
                this.currDBXrefs.add(dbx);
            } else if (qName.equals(EMBLxmlFormat.FEATURE_TAG) && !this.parent.getElideFeatures()) {
                this.templ = new RichFeature.Template();
                this.templ.annotation = new SimpleRichAnnotation();
                this.templ.sourceTerm = Terms.getEMBLxmlTerm();
                this.templ.featureRelationshipSet = new TreeSet();
                this.templ.rankedCrossRefs = new TreeSet();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (!name.equals("name")) continue;
                    this.templ.typeTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm(val);
                }
                this.currLocStr = new StringBuffer();
                this.currDBXrefs.clear();
                this.currQuals.clear();
            } else if (qName.equals(EMBLxmlFormat.QUALIFIER_TAG) && !this.parent.getElideFeatures()) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (!name.equals("name")) continue;
                    this.currFeatQual = val;
                }
            } else if (qName.equals(EMBLxmlFormat.LOCATION_TAG) && !this.parent.getElideFeatures()) {
                this.currLocBrackets = 0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (name.equals("type") && !val.equalsIgnoreCase("single")) {
                        this.currLocStr.append(val);
                        this.currLocStr.append("(");
                        ++this.currLocBrackets;
                        continue;
                    }
                    if (!name.equals("complement") || !val.equalsIgnoreCase("true")) continue;
                    this.currLocStr.append("complement");
                    this.currLocStr.append("(");
                    ++this.currLocBrackets;
                }
                this.firstLocationElement = true;
            } else if (qName.equals(EMBLxmlFormat.LOCATION_ELEMENT_TAG) && !this.parent.getElideFeatures()) {
                String currAcc = null;
                String currVer = null;
                if (!this.firstLocationElement) {
                    this.currLocStr.append(",");
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (name.equals("complement") && val.equalsIgnoreCase("true")) {
                        this.currLocStr.append("complement");
                        this.currLocStr.append("(");
                        ++this.currLocElemBrackets;
                        continue;
                    }
                    if (name.equals("accession")) {
                        currAcc = val;
                        continue;
                    }
                    if (!name.equals("version")) continue;
                    currVer = val;
                }
                if (currAcc != null) {
                    this.currLocStr.append(currAcc);
                    if (currVer != null) {
                        this.currLocStr.append(".");
                        this.currLocStr.append(currVer);
                    }
                    this.currLocStr.append(":");
                }
                this.firstBase = true;
            } else if (qName.equals(EMBLxmlFormat.BASEPOSITION_TAG) && !this.parent.getElideFeatures()) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String val = attributes.getValue(i);
                    if (name.equals("type")) {
                        this.currBaseType = val;
                        continue;
                    }
                    if (!name.equals(EMBLxmlFormat.BASEPOSITION_EXTENT_ATTR)) continue;
                    this.currBaseExtent = val;
                }
            } else if (qName.equals(EMBLxmlFormat.SEQUENCE_TAG)) {
                try {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getQName(i);
                        String val = attributes.getValue(i);
                        if (name.equals("type")) {
                            this.rlistener.addSequenceProperty(Terms.getMolTypeTerm(), val);
                            continue;
                        }
                        if (name.equals("version")) {
                            this.rlistener.setSeqVersion(val);
                            continue;
                        }
                        if (!name.equals(EMBLxmlFormat.SEQUENCE_TOPOLOGY_ATTR) || !val.equalsIgnoreCase("circular")) continue;
                        this.rlistener.setCircular(true);
                    }
                }
                catch (ParseException e) {
                    SAXException pe = new SAXException("Could not set sequence properties");
                    pe.initCause(e);
                    throw pe;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            block63: {
                String val = this.m_currentString.toString().trim();
                try {
                    if (qName.equals(EMBLxmlFormat.SEC_ACC_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), val);
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.DESC_TAG)) {
                        this.rlistener.setDescription(val);
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.KEYWORD_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getKeywordTerm(), val);
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.COMMENT_TAG)) {
                        this.currComments.add(val);
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.TITLE_TAG)) {
                        this.currRefTitle = val;
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.AUTHOR_TAG)) {
                        this.currRefAuthors.add(new SimpleDocRefAuthor(val, false, false));
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.EDITOR_TAG)) {
                        this.currRefAuthors.add(new SimpleDocRefAuthor(val, false, true));
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.CONSORTIUM_TAG)) {
                        this.currRefAuthors.add(new SimpleDocRefAuthor(val, true, false));
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.LOCATOR_TAG)) {
                        this.currRefLocation = val;
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.REFERENCE_TAG) && !this.parent.getElideReferences()) {
                        int rank = 0;
                        CrossRef useForDocRef = null;
                        Iterator j = this.currDBXrefs.iterator();
                        while (j.hasNext()) {
                            CrossRef dbx = (CrossRef)j.next();
                            SimpleRankedCrossRef rdbx = new SimpleRankedCrossRef(dbx, rank++);
                            this.rlistener.setRankedCrossRef(rdbx);
                            if (useForDocRef == null) {
                                useForDocRef = dbx;
                                continue;
                            }
                            if (!dbx.getDbname().equalsIgnoreCase("MEDLINE") && (!dbx.getDbname().equalsIgnoreCase("PUBMED") || useForDocRef.getDbname().equalsIgnoreCase("MEDLINE"))) continue;
                            useForDocRef = dbx;
                        }
                        String currRefRemark = null;
                        if (this.currComments.size() > 0) {
                            currRefRemark = (String)this.currComments.iterator().next();
                        }
                        try {
                            DocRef dr = (DocRef)RichObjectFactory.getObject(class$org$biojavax$SimpleDocRef == null ? (class$org$biojavax$SimpleDocRef = EMBLxmlFormat.class$("org.biojavax.SimpleDocRef")) : class$org$biojavax$SimpleDocRef, new Object[]{this.currRefAuthors, this.currRefLocation, this.currRefTitle});
                            if (useForDocRef != null) {
                                dr.setCrossref(useForDocRef);
                            }
                            dr.setRemark(currRefRemark);
                            SimpleRankedDocRef rdr = new SimpleRankedDocRef(dr, this.currRefStart != -999 ? new Integer(this.currRefStart) : null, this.currRefEnd != -999 ? new Integer(this.currRefEnd) : null, this.currRefRank);
                            this.rlistener.setRankedDocRef(rdr);
                        }
                        catch (ChangeVetoException e) {
                            throw new ParseException(e);
                        }
                        this.currDBXrefs.clear();
                        this.currComments.clear();
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.LOCATION_TAG) && !this.parent.getElideFeatures()) {
                        while (this.currLocBrackets-- > 0) {
                            this.currLocStr.append(")");
                        }
                        String tidyLocStr = this.currLocStr.toString().replaceAll("\\s+", "");
                        this.templ.location = GenbankLocationParser.parseLocation(this.ns, this.accession, tidyLocStr);
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.LOCATION_ELEMENT_TAG) && !this.parent.getElideFeatures()) {
                        while (this.currLocElemBrackets-- > 0) {
                            this.currLocStr.append(")");
                        }
                        this.firstLocationElement = false;
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.BASEPOSITION_TAG) && !this.parent.getElideFeatures()) {
                        if (!this.firstBase) {
                            this.currLocStr.append("..");
                        }
                        if (this.currBaseType.equals("<")) {
                            this.currLocStr.append("<");
                            this.currLocStr.append(val);
                        } else if (this.currBaseType.equals(">")) {
                            this.currLocStr.append(val);
                            this.currLocStr.append(">");
                        } else if (this.currBaseType.equalsIgnoreCase("simple")) {
                            this.currLocStr.append(val);
                        } else if (this.currBaseType.equalsIgnoreCase("fuzzy")) {
                            int extentVal;
                            int refVal = Integer.parseInt(val);
                            if (refVal + (extentVal = Integer.parseInt(this.currBaseExtent)) < refVal) {
                                this.currLocStr.append("(");
                                this.currLocStr.append("" + extentVal);
                                this.currLocStr.append(".");
                                this.currLocStr.append("" + refVal);
                                this.currLocStr.append(")");
                            } else {
                                this.currLocStr.append("(");
                                this.currLocStr.append("" + refVal);
                                this.currLocStr.append(".");
                                this.currLocStr.append("" + extentVal);
                                this.currLocStr.append(")");
                            }
                        }
                        this.firstBase = false;
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.QUALIFIER_TAG) && !this.parent.getElideFeatures()) {
                        this.currQuals.put(this.currFeatQual, val);
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.FEATURE_TAG) && !this.parent.getElideFeatures()) {
                        this.rlistener.startFeature(this.templ);
                        Iterator j = this.currQuals.keySet().iterator();
                        while (j.hasNext()) {
                            String qualName = (String)j.next();
                            String qualVal = (String)this.currQuals.get(qualName);
                            if (qualName.equalsIgnoreCase("translation")) {
                                qualVal = qualVal.replaceAll("\\s+", "");
                            }
                            this.rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(qualName), qualVal);
                        }
                        int k = 0;
                        Iterator j2 = this.currDBXrefs.iterator();
                        while (j2.hasNext()) {
                            CrossRef dbx = (CrossRef)j2.next();
                            SimpleRankedCrossRef rdbx = new SimpleRankedCrossRef(dbx, k++);
                            try {
                                this.rlistener.getCurrentFeature().addRankedCrossRef(rdbx);
                            }
                            catch (ChangeVetoException ce) {
                                throw new ParseException(ce);
                            }
                        }
                        this.rlistener.endFeature();
                        this.currDBXrefs.clear();
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.TAXID_TAG)) {
                        this.tax = (NCBITaxon)RichObjectFactory.getObject(class$org$biojavax$bio$taxa$SimpleNCBITaxon == null ? (class$org$biojavax$bio$taxa$SimpleNCBITaxon = EMBLxmlFormat.class$("org.biojavax.bio.taxa.SimpleNCBITaxon")) : class$org$biojavax$bio$taxa$SimpleNCBITaxon, new Object[]{Integer.valueOf(val)});
                        this.rlistener.setTaxon(this.tax);
                        Iterator j = this.currNames.keySet().iterator();
                        while (j.hasNext()) {
                            String nameClass = (String)j.next();
                            Set nameSet = (Set)this.currNames.get(nameClass);
                            try {
                                Iterator k = nameSet.iterator();
                                while (k.hasNext()) {
                                    String name = (String)k.next();
                                    this.tax.addName(nameClass, name);
                                }
                            }
                            catch (ChangeVetoException ce) {
                                throw new ParseException(ce);
                            }
                        }
                        this.currNames.clear();
                        break block63;
                    }
                    if (qName.equals(EMBLxmlFormat.SCINAME_TAG)) {
                        try {
                            if (this.tax == null) {
                                if (!this.currNames.containsKey("scientific name")) {
                                    this.currNames.put("scientific name", new TreeSet());
                                }
                                ((Set)this.currNames.get("scientific name")).add(val);
                            } else {
                                this.tax.addName("scientific name", val);
                            }
                            break block63;
                        }
                        catch (ChangeVetoException ce) {
                            throw new ParseException(ce);
                        }
                    }
                    if (qName.equals(EMBLxmlFormat.COMNAME_TAG)) {
                        try {
                            if (this.tax == null) {
                                if (!this.currNames.containsKey("common name")) {
                                    this.currNames.put("common name", new TreeSet());
                                }
                                ((Set)this.currNames.get("common name")).add(val);
                            } else {
                                this.tax.addName("common name", val);
                            }
                            break block63;
                        }
                        catch (ChangeVetoException ce) {
                            throw new ParseException(ce);
                        }
                    }
                    if (qName.equals(EMBLxmlFormat.SEQUENCE_TAG) && !this.parent.getElideSymbols()) {
                        try {
                            SimpleSymbolList sl = new SimpleSymbolList(this.symParser, val.replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                            this.rlistener.addSymbols(this.symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                            break block63;
                        }
                        catch (Exception e) {
                            throw new ParseException(e);
                        }
                    }
                    if (qName.equals(EMBLxmlFormat.ENTRY_TAG)) {
                        Iterator j = this.currComments.iterator();
                        while (j.hasNext()) {
                            this.rlistener.setComment((String)j.next());
                        }
                        int rank = 0;
                        Iterator j3 = this.currDBXrefs.iterator();
                        while (j3.hasNext()) {
                            CrossRef dbx = (CrossRef)j3.next();
                            SimpleRankedCrossRef rdbx = new SimpleRankedCrossRef(dbx, rank++);
                            this.rlistener.setRankedCrossRef(rdbx);
                        }
                        this.rlistener.endSequence();
                        this.currComments.clear();
                        this.currDBXrefs.clear();
                    }
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
            this.m_currentString.setLength(0);
        }

        public void characters(char[] ch, int start, int length) {
            this.m_currentString.append(ch, start, length);
        }
    }

    public static class Terms
    extends RichSequence.Terms {
        private static ComparableTerm EMBLXML_TERM = null;

        public static ComparableTerm getEMBLxmlTerm() {
            if (EMBLXML_TERM == null) {
                EMBLXML_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm(EMBLxmlFormat.EMBLXML_FORMAT);
            }
            return EMBLXML_TERM;
        }
    }
}

