/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleCrossRef;
import org.biojavax.bio.seq.CompoundRichLocation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.ontology.ComparableTerm;

public class GenbankLocationParser {
    private static Pattern gp = Pattern.compile("^([^\\(\\):]*?:)?(complement|join|order)?\\(*{0,1}(.*?)\\)*{0,1}$");
    private static Pattern rp = Pattern.compile("^\\(*(.*?)\\)*(\\.\\.\\(*(.*)\\)*)?$");
    private static Pattern xp = Pattern.compile("^(.*?)(\\.(\\d+))?:$");
    private static Pattern pp = Pattern.compile("^\\(*(<|>)?(\\d+)(([\\.\\^])(\\d+))?(<|>)?\\)*$");
    private static int rank;

    private GenbankLocationParser() {
    }

    public static RichLocation parseLocation(Namespace featureNS, String featureAccession, String locationString) throws ParseException {
        rank = 1;
        return GenbankLocationParser.parseLocString(featureNS, featureAccession, null, RichLocation.Strand.POSITIVE_STRAND, locationString);
    }

    private static RichLocation parseLocString(Namespace featureNS, String featureAccession, CrossRef parentXref, RichLocation.Strand parentStrand, String locStr) throws ParseException {
        Matcher gm = gp.matcher(locStr);
        if (!gm.matches()) {
            throw new ParseException("Bad location string found: " + locStr);
        }
        String xrefName = gm.group(1);
        String groupType = gm.group(2);
        String subLocStr = gm.group(3);
        CrossRef crossRef = parentXref;
        if (xrefName != null) {
            Matcher xm = xp.matcher(xrefName);
            if (!xm.matches()) {
                throw new ParseException("Bad location xref found: " + xrefName);
            }
            String xrefAccession = xm.group(1);
            String xrefVersion = xm.group(3);
            crossRef = xrefAccession.equals(featureAccession) ? null : (xrefVersion != null ? (SimpleCrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{featureNS.getName(), xrefAccession, Integer.valueOf(xrefVersion)}) : (SimpleCrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{featureNS.getName(), xrefAccession, new Integer(0)}));
        }
        RichLocation.Strand strand = parentStrand;
        if (groupType != null) {
            if (groupType.equalsIgnoreCase("complement")) {
                strand = parentStrand == RichLocation.Strand.NEGATIVE_STRAND ? RichLocation.Strand.POSITIVE_STRAND : RichLocation.Strand.NEGATIVE_STRAND;
                ArrayList resultBlocks = new ArrayList(RichLocation.Tools.flatten(GenbankLocationParser.parseLocString(featureNS, featureAccession, crossRef, strand, subLocStr)));
                int firstRank = ((RichLocation)resultBlocks.get(0)).getRank();
                Collections.reverse(resultBlocks);
                Iterator i = resultBlocks.iterator();
                while (i.hasNext()) {
                    RichLocation rl = (RichLocation)i.next();
                    try {
                        rl.setRank(firstRank++);
                    }
                    catch (ChangeVetoException e) {
                        throw new ParseException(e);
                    }
                }
                return RichLocation.Tools.construct(resultBlocks);
            }
            ComparableTerm groupTypeTerm = null;
            if (groupType.equalsIgnoreCase("order")) {
                groupTypeTerm = CompoundRichLocation.getOrderTerm();
            } else if (groupType.equalsIgnoreCase("join")) {
                groupTypeTerm = CompoundRichLocation.getJoinTerm();
            } else {
                throw new ParseException("Unknown group type " + groupType + " received");
            }
            ArrayList<RichLocation> members = new ArrayList<RichLocation>();
            StringBuffer sb = new StringBuffer();
            char[] chars = subLocStr.toCharArray();
            int bracketCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '(') {
                    ++bracketCount;
                } else if (c == ')') {
                    --bracketCount;
                }
                if (c == ',' && bracketCount == 0) {
                    String subStr = sb.toString();
                    members.add(GenbankLocationParser.parseLocString(featureNS, featureAccession, crossRef, parentStrand, subStr));
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
            if (sb.length() > 0) {
                members.add(GenbankLocationParser.parseLocString(featureNS, featureAccession, crossRef, parentStrand, sb.toString()));
            }
            RichLocation result = RichLocation.Tools.construct(RichLocation.Tools.merge(members));
            try {
                if (result instanceof CompoundRichLocation) {
                    result.setTerm(groupTypeTerm);
                }
            }
            catch (ChangeVetoException e) {
                ParseException e2 = new ParseException("Unable to set group term");
                e2.initCause(e);
                throw e2;
            }
            return result;
        }
        Matcher rm = rp.matcher(subLocStr);
        if (!rm.matches()) {
            throw new ParseException("Bad location description found: " + subLocStr);
        }
        String start = rm.group(1);
        String end = rm.group(3);
        Position startPos = GenbankLocationParser.parsePosition(start);
        if (end == null) {
            return new SimpleRichLocation(startPos, startPos, ++rank, strand, crossRef);
        }
        Position endPos = GenbankLocationParser.parsePosition(end);
        return new SimpleRichLocation(startPos, endPos, ++rank, strand, crossRef);
    }

    private static Position parsePosition(String position) throws ParseException {
        Matcher pm = pp.matcher(position);
        if (!pm.matches()) {
            throw new ParseException("Could not understand position: " + position);
        }
        String startfuzz = pm.group(1);
        String endfuzz = pm.group(6);
        boolean endStartsFuzzy = startfuzz != null && startfuzz.equals("<") || endfuzz != null && endfuzz.equals("<");
        boolean endEndsFuzzy = endfuzz != null && endfuzz.equals(">") || startfuzz != null && startfuzz.equals(">");
        String endStart = pm.group(2);
        String endRangeType = pm.group(4);
        String endEnd = pm.group(5);
        if (endRangeType != null) {
            return new SimplePosition(endStartsFuzzy, endEndsFuzzy, Integer.parseInt(endStart), Integer.parseInt(endEnd), endRangeType);
        }
        return new SimplePosition(endStartsFuzzy, endEndsFuzzy, Integer.parseInt(endStart));
    }

    public static String writeLocation(RichLocation l) {
        if (l instanceof CompoundRichLocation) {
            return GenbankLocationParser.writeCompoundLocation((CompoundRichLocation)l);
        }
        return GenbankLocationParser._writeSingleLocation(l);
    }

    private static String _writePosition(Position p) {
        StringBuffer sb = new StringBuffer();
        int s = p.getStart();
        int e = p.getEnd();
        String t = p.getType();
        boolean fs = p.getFuzzyStart();
        boolean fe = p.getFuzzyEnd();
        boolean useParenthesis = GenbankLocationParser.isUsingParenthesis(p);
        if (s != e) {
            if (useParenthesis) {
                sb.append("(");
            }
            if (fs) {
                sb.append("<");
            }
            sb.append(s);
            sb.append(t);
            if (fe) {
                sb.append(">");
            }
            sb.append(e);
            if (useParenthesis) {
                sb.append(")");
            }
        } else {
            if (fs) {
                sb.append("<");
            }
            if (fe) {
                sb.append(">");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static String _writeSingleLocation(RichLocation l) {
        StringBuffer loc = new StringBuffer();
        if (l.getCrossRef() != null) {
            loc.append(l.getCrossRef().getAccession());
            int version = l.getCrossRef().getVersion();
            if (version != 0) {
                loc.append(".");
                loc.append(version);
            }
            loc.append(":");
        }
        loc.append(GenbankLocationParser._writePosition(l.getMinPosition()));
        if (!l.getMinPosition().equals(l.getMaxPosition())) {
            loc.append("..");
            loc.append(GenbankLocationParser._writePosition(l.getMaxPosition()));
        }
        if (l.getStrand() == RichLocation.Strand.NEGATIVE_STRAND) {
            loc.insert(0, "complement(");
            loc.append(")");
        }
        return loc.toString();
    }

    private static String _writeGroupLocation(Iterator i, ComparableTerm parentTerm) {
        StringBuffer sb = new StringBuffer();
        sb.append(parentTerm.getName());
        sb.append("(");
        while (i.hasNext()) {
            RichLocation l = (RichLocation)i.next();
            if (l instanceof CompoundRichLocation) {
                sb.append(GenbankLocationParser._writeGroupLocation(l.blockIterator(), l.getTerm()));
            } else {
                sb.append(GenbankLocationParser._writeSingleLocation(l));
            }
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private static final String writeCompoundLocation(CompoundRichLocation theLocation) {
        if (GenbankLocationParser.isAnyLocationComplemented(theLocation)) {
            if (GenbankLocationParser.isAnyLocationOnDifferentStrand(theLocation)) {
                return GenbankLocationParser._writeGroupLocation(theLocation.blockIterator(), theLocation.getTerm());
            }
            return GenbankLocationParser.writeComplementLocation(theLocation.blockIterator());
        }
        return GenbankLocationParser._writeGroupLocation(theLocation.blockIterator(), theLocation.getTerm());
    }

    private static final String writeComplementLocation(Iterator i) {
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            RichLocation l = (RichLocation)i.next();
            if (l instanceof CompoundRichLocation) {
                sb.insert(0, GenbankLocationParser.writeCompoundLocation((CompoundRichLocation)l));
            } else {
                sb.insert(0, GenbankLocationParser.writeSingleLocation(l));
            }
            if (!i.hasNext()) continue;
            sb.insert(0, ",");
        }
        sb.insert(0, "complement(join(");
        sb.append("))");
        return sb.toString();
    }

    private static final String writeSingleLocation(RichLocation theRichLocation) {
        StringBuffer loc = new StringBuffer();
        if (theRichLocation.getCrossRef() != null) {
            loc.append(theRichLocation.getCrossRef().getAccession());
            int version = theRichLocation.getCrossRef().getVersion();
            if (version != 0) {
                loc.append(".");
                loc.append(version);
            }
            loc.append(":");
        }
        loc.append(GenbankLocationParser._writePosition(theRichLocation.getMinPosition()));
        if (!theRichLocation.getMinPosition().equals(theRichLocation.getMaxPosition())) {
            loc.append("..");
            loc.append(GenbankLocationParser._writePosition(theRichLocation.getMaxPosition()));
        }
        return loc.toString();
    }

    private static final boolean isAnyLocationComplemented(CompoundRichLocation theLocation) {
        Iterator c = theLocation.blockIterator();
        while (c.hasNext()) {
            RichLocation location = (RichLocation)c.next();
            if (location.getStrand() != RichLocation.Strand.NEGATIVE_STRAND) continue;
            return true;
        }
        return false;
    }

    private static final boolean isAnyLocationOnDifferentStrand(CompoundRichLocation theLocation) {
        Iterator c = theLocation.blockIterator();
        RichLocation.Strand firstStrand = ((RichLocation)c.next()).getStrand();
        while (c.hasNext()) {
            RichLocation location = (RichLocation)c.next();
            if (location.getStrand() == firstStrand) continue;
            return true;
        }
        return false;
    }

    private static final boolean isUsingParenthesis(Position thePosition) {
        return !GenbankLocationParser.isBetweenBases(thePosition);
    }

    private static final boolean isBetweenBases(Position thePosition) {
        return thePosition.getType() != null && thePosition.getType().equals("^");
    }
}

