/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import org.biojavax.bio.seq.io.RichSequenceBuilder;
import org.biojavax.bio.seq.io.RichSequenceBuilderFactory;
import org.biojavax.bio.seq.io.RichSequenceFormat;

public class RichStreamReader
implements RichSequenceIterator {
    private Namespace ns;
    private SymbolTokenization symParser;
    private RichSequenceFormat format;
    private RichSequenceBuilderFactory sf;
    private BufferedReader reader;
    private boolean moreSequenceAvailable = true;

    public Sequence nextSequence() throws NoSuchElementException, BioException {
        return this.nextRichSequence();
    }

    public BioEntry nextBioEntry() throws NoSuchElementException, BioException {
        return this.nextBioEntry();
    }

    public RichSequence nextRichSequence() throws NoSuchElementException, BioException {
        if (!this.moreSequenceAvailable) {
            throw new NoSuchElementException("Stream is empty");
        }
        try {
            RichSequenceBuilder builder = (RichSequenceBuilder)this.sf.makeSequenceBuilder();
            this.moreSequenceAvailable = this.format.readRichSequence(this.reader, this.symParser, builder, this.ns);
            return builder.makeRichSequence();
        }
        catch (Exception e) {
            throw new BioException("Could not read sequence", e);
        }
    }

    public boolean hasNext() {
        return this.moreSequenceAvailable;
    }

    public RichStreamReader(InputStream is, RichSequenceFormat format, SymbolTokenization symParser, RichSequenceBuilderFactory sf, Namespace ns) {
        this(new BufferedReader(new InputStreamReader(is)), format, symParser, sf, ns);
    }

    public RichStreamReader(BufferedReader reader, RichSequenceFormat format, SymbolTokenization symParser, RichSequenceBuilderFactory sf, Namespace ns) {
        this.reader = reader;
        this.format = format;
        this.symParser = symParser;
        this.sf = sf;
        this.ns = ns;
    }
}

