/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.proteomics.MassCalc;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleComment;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.seq.io.UniProtCommentParser;
import org.biojavax.bio.seq.io.UniProtLocationParser;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.utils.CRC64Checksum;
import org.biojavax.utils.StringTools;

public class UniProtFormat
extends RichSequenceFormat.HeaderlessFormat {
    public static final String UNIPROT_FORMAT = "UniProt";
    protected static final String LOCUS_TAG = "ID";
    protected static final String ACCESSION_TAG = "AC";
    protected static final String DEFINITION_TAG = "DE";
    protected static final String DATE_TAG = "DT";
    protected static final String SOURCE_TAG = "OS";
    protected static final String ORGANELLE_TAG = "OG";
    protected static final String ORGANISM_TAG = "OC";
    protected static final String TAXON_TAG = "OX";
    protected static final String GENE_TAG = "GN";
    protected static final String DATABASE_XREF_TAG = "DR";
    protected static final String REFERENCE_TAG = "RN";
    protected static final String RP_LINE_TAG = "RP";
    protected static final String REFERENCE_XREF_TAG = "RX";
    protected static final String AUTHORS_TAG = "RA";
    protected static final String CONSORTIUM_TAG = "RG";
    protected static final String TITLE_TAG = "RT";
    protected static final String LOCATION_TAG = "RL";
    protected static final String RC_LINE_TAG = "RC";
    protected static final String KEYWORDS_TAG = "KW";
    protected static final String COMMENT_TAG = "CC";
    protected static final String FEATURE_TAG = "FT";
    protected static final String START_SEQUENCE_TAG = "SQ";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final Pattern lp;
    protected static final Pattern rppat;
    protected static final Pattern dp;
    protected static final Pattern fp;
    protected static final Pattern headerLine;
    static /* synthetic */ Class class$org$biojavax$bio$taxa$SimpleNCBITaxon;
    static /* synthetic */ Class class$org$biojavax$SimpleCrossRef;
    static /* synthetic */ Class class$org$biojavax$SimpleDocRef;

    public boolean canRead(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String firstLine = br.readLine();
        boolean readable = headerLine.matcher(firstLine).matches() && lp.matcher(firstLine.substring(3).trim()).matches();
        br.close();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        return RichSequence.IOTools.getProteinParser();
    }

    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String firstLine = br.readLine();
        boolean readable = headerLine.matcher(firstLine).matches() && lp.matcher(firstLine.substring(3).trim()).matches();
        stream.reset();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        return RichSequence.IOTools.getProteinParser();
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        boolean hasAnotherSequence;
        block108: {
            int c;
            hasAnotherSequence = true;
            rlistener.startSequence();
            if (ns == null) {
                ns = RichObjectFactory.getDefaultNamespace();
            }
            rlistener.setNamespace(ns);
            String sectionKey = null;
            NCBITaxon tax = null;
            String accession = null;
            int xrefCount = 0;
            do {
                List section;
                if ((sectionKey = ((String[])(section = this.readSection(reader)).get(0))[0]) == null) {
                    throw new ParseException("Section key was null. Accession:" + accession == null ? "Not set" : accession);
                }
                if (sectionKey.equals(LOCUS_TAG)) {
                    String loc = ((String[])section.get(0))[1];
                    Matcher m = lp.matcher(loc);
                    if (m.matches()) {
                        rlistener.setName(m.group(2));
                        rlistener.setDivision(m.group(3));
                        rlistener.addSequenceProperty(Terms.getDataClassTerm(), m.group(4));
                        rlistener.addSequenceProperty(Terms.getMolTypeTerm(), m.group(5));
                        continue;
                    }
                    throw new ParseException("Bad ID line found: " + loc);
                }
                if (sectionKey.equals(DEFINITION_TAG)) {
                    String val = ((String[])section.get(0))[1];
                    if (val.endsWith(".")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    rlistener.setDescription(val);
                    continue;
                }
                if (sectionKey.equals(SOURCE_TAG)) {
                    String sciname = null;
                    String comname = null;
                    ArrayList<String> synonym = new ArrayList<String>();
                    int taxid = 0;
                    for (int i = 0; i < section.size(); ++i) {
                        int j;
                        String[] parts;
                        String tag = ((String[])section.get(i))[0];
                        String value = ((String[])section.get(i))[1].trim();
                        if (tag.equals(SOURCE_TAG)) {
                            if (value.endsWith(".")) {
                                value = value.substring(0, value.length() - 1);
                            }
                            parts = value.split("\\(");
                            sciname = parts[0].trim();
                            if (parts.length <= 1) continue;
                            comname = parts[1].trim();
                            if (comname.endsWith(")")) {
                                comname = comname.substring(0, comname.length() - 1);
                            }
                            if (parts.length <= 2) continue;
                            for (j = 2; j < parts.length; ++j) {
                                String syn = parts[j].trim();
                                if (syn.endsWith(")")) {
                                    syn = syn.substring(0, syn.length() - 1);
                                }
                                synonym.add(syn);
                            }
                            continue;
                        }
                        if (tag.equals(TAXON_TAG)) {
                            parts = value.split(";");
                            for (j = 0; j < parts.length; ++j) {
                                String[] bits = parts[j].split("=");
                                if (!bits[0].equals("NCBI_TaxID")) continue;
                                String[] morebits = bits[1].split(",");
                                taxid = Integer.parseInt(morebits[0].trim());
                            }
                            continue;
                        }
                        if (!tag.equals(ORGANELLE_TAG)) continue;
                        if (value.endsWith(".")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        parts = value.split(";");
                        for (j = 0; j < parts.length; ++j) {
                            parts[j] = parts[j].trim();
                            rlistener.addSequenceProperty(Terms.getOrganelleTerm(), parts[j]);
                        }
                    }
                    tax = (NCBITaxon)RichObjectFactory.getObject(class$org$biojavax$bio$taxa$SimpleNCBITaxon == null ? UniProtFormat.class$("org.biojavax.bio.taxa.SimpleNCBITaxon") : class$org$biojavax$bio$taxa$SimpleNCBITaxon, new Object[]{new Integer(taxid)});
                    rlistener.setTaxon(tax);
                    try {
                        if (sciname != null) {
                            tax.addName("scientific name", sciname);
                        }
                        if (comname != null) {
                            tax.addName("common name", comname);
                        }
                        Iterator j = synonym.iterator();
                        while (j.hasNext()) {
                            tax.addName("synonym", (String)j.next());
                        }
                    }
                    catch (ChangeVetoException e) {
                        throw new ParseException(e);
                    }
                }
                if (sectionKey.equals(DATE_TAG)) {
                    String chunk = ((String[])section.get(0))[1];
                    Matcher dm = dp.matcher(chunk);
                    if (dm.matches()) {
                        String date = dm.group(1).trim();
                        String type = dm.group(2).trim();
                        String rel = dm.group(3);
                        if (rel != null) {
                            rel = rel.trim();
                        }
                        if (type.startsWith("integrated into UniProtKB")) {
                            String dbname = type.split("/")[1];
                            rlistener.addSequenceProperty(Terms.getDateCreatedTerm(), date);
                            rlistener.addSequenceProperty(Terms.getUniProtDBNameTerm(), dbname);
                            continue;
                        }
                        if (type.equalsIgnoreCase("sequence version")) {
                            if (rel == null) {
                                throw new ParseException("Version missing for " + type);
                            }
                            rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), date);
                            rlistener.addSequenceProperty(Terms.getRelUpdatedTerm(), rel);
                            continue;
                        }
                        if (type.equalsIgnoreCase("entry version")) {
                            if (rel == null) {
                                throw new ParseException("Version missing for " + type);
                            }
                            rlistener.addSequenceProperty(Terms.getDateAnnotatedTerm(), date);
                            rlistener.addSequenceProperty(Terms.getRelAnnotatedTerm(), rel);
                            continue;
                        }
                        throw new ParseException("Bad date type found: " + type);
                    }
                    throw new ParseException("Bad date line found: " + chunk);
                }
                if (sectionKey.equals(ACCESSION_TAG)) {
                    String[] accs = ((String[])section.get(0))[1].split(";");
                    accession = accs[0].trim();
                    rlistener.setAccession(accession);
                    for (int i = 1; i < accs.length; ++i) {
                        rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), accs[i].trim());
                    }
                    continue;
                }
                if (sectionKey.equals(KEYWORDS_TAG)) {
                    String val = ((String[])section.get(0))[1];
                    if (val.endsWith(".")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    String[] kws = val.split(";");
                    for (int i = 0; i < kws.length; ++i) {
                        String kw = kws[i].trim();
                        if (kw.length() == 0) continue;
                        rlistener.addSequenceProperty(Terms.getKeywordTerm(), kw);
                    }
                    continue;
                }
                if (sectionKey.equals(GENE_TAG)) {
                    String[] genes = ((String[])section.get(0))[1].split("\\s+(or|and)\\s+");
                    for (int geneID = 0; geneID < genes.length; ++geneID) {
                        String[] parts = genes[geneID].split(";");
                        for (int j = 0; j < parts.length; ++j) {
                            int k;
                            String[] moreparts = parts[j].split("=");
                            String[] values = moreparts[1].split(",");
                            if (moreparts[0].trim().equals(Terms.GENENAME_KEY)) {
                                rlistener.addSequenceProperty(Terms.getGeneNameTerm(), geneID + ":" + values[0].trim());
                                continue;
                            }
                            if (moreparts[0].trim().equals(Terms.GENESYNONYM_KEY)) {
                                for (k = 0; k < values.length; ++k) {
                                    rlistener.addSequenceProperty(Terms.getGeneSynonymTerm(), geneID + ":" + values[k].trim());
                                }
                                continue;
                            }
                            if (moreparts[0].trim().equals(Terms.ORDLOCNAME_KEY)) {
                                for (k = 0; k < values.length; ++k) {
                                    rlistener.addSequenceProperty(Terms.getOrderedLocusNameTerm(), geneID + ":" + values[k].trim());
                                }
                                continue;
                            }
                            if (!moreparts[0].trim().equals(Terms.ORFNAME_KEY)) continue;
                            for (k = 0; k < values.length; ++k) {
                                rlistener.addSequenceProperty(Terms.getORFNameTerm(), geneID + ":" + values[k].trim());
                            }
                        }
                    }
                    continue;
                }
                if (sectionKey.equals(DATABASE_XREF_TAG)) {
                    String val = ((String[])section.get(0))[1];
                    if (val.endsWith(".")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    String[] parts = val.split(";");
                    String dbname = parts[0].trim();
                    String acc = parts[1].trim();
                    CrossRef crossRef = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? UniProtFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{dbname, acc, new Integer(0)});
                    for (int j = 2; j < parts.length; ++j) {
                        ComparableTerm t = Terms.getAdditionalAccessionTerm();
                        SimpleNote note = new SimpleNote(t, parts[j].trim(), j);
                        try {
                            ((RichAnnotation)crossRef.getAnnotation()).addNote(note);
                            continue;
                        }
                        catch (ChangeVetoException ce) {
                            ParseException pe = new ParseException("Could not annotate additional accession terms");
                            pe.initCause(ce);
                            throw pe;
                        }
                    }
                    SimpleRankedCrossRef rcrossRef = new SimpleRankedCrossRef(crossRef, ++xrefCount);
                    rlistener.setRankedCrossRef(rcrossRef);
                    continue;
                }
                if (sectionKey.equals(REFERENCE_TAG) && !this.getElideReferences()) {
                    String refrank = ((String[])section.get(0))[1];
                    int ref_rank = Integer.parseInt(refrank.substring(1, refrank.length() - 1));
                    String authors = null;
                    String consortium = null;
                    String title = null;
                    String locator = null;
                    String pubmed = null;
                    String medline = null;
                    String doi = null;
                    String remark = null;
                    Integer rstart = null;
                    Integer rend = null;
                    for (int i = 1; i < section.size(); ++i) {
                        int j;
                        String key = ((String[])section.get(i))[0];
                        String val = ((String[])section.get(i))[1];
                        if (key.equals(AUTHORS_TAG)) {
                            if (val.endsWith(";")) {
                                val = val.trim().substring(0, val.length() - 1);
                            }
                            authors = val;
                        }
                        if (key.equals(CONSORTIUM_TAG)) {
                            if (val.endsWith(";")) {
                                val = val.trim().substring(0, val.length() - 1);
                            }
                            consortium = val;
                        }
                        if (key.equals(TITLE_TAG)) {
                            if (val.endsWith(";")) {
                                val = val.trim().substring(0, val.length() - 1);
                            }
                            if (val.endsWith("\"")) {
                                val = val.trim().substring(1, val.length() - 2);
                            }
                            title = val;
                        }
                        if (key.equals(LOCATION_TAG)) {
                            if (val.endsWith(".")) {
                                val = val.trim().substring(0, val.length() - 1);
                            }
                            locator = val;
                        }
                        if (key.equals(REFERENCE_XREF_TAG)) {
                            String[] refs = val.split(";");
                            for (j = 0; j < refs.length; ++j) {
                                if (refs[j].trim().length() == 0) continue;
                                String[] parts = refs[j].split("=");
                                String db = parts[0];
                                String ref = parts[1];
                                if (db.equalsIgnoreCase("PUBMED")) {
                                    pubmed = ref;
                                    continue;
                                }
                                if (db.equalsIgnoreCase("MEDLINE")) {
                                    medline = ref;
                                    continue;
                                }
                                if (!db.equalsIgnoreCase("DOI")) continue;
                                doi = ref;
                            }
                        }
                        if (key.equals(RP_LINE_TAG)) {
                            Matcher m;
                            remark = val;
                            if (val.endsWith(".")) {
                                val = val.substring(0, val.length() - 1);
                            }
                            if ((m = rppat.matcher(val)).matches()) {
                                rstart = Integer.valueOf(m.group(1));
                                rend = Integer.valueOf(m.group(2));
                            }
                        }
                        if (!key.equals(RC_LINE_TAG)) continue;
                        String[] parts = val.split(";");
                        for (j = 0; j < parts.length; ++j) {
                            ComparableTerm t;
                            String[] subparts = parts[j].split("=");
                            String termName = subparts[0].trim();
                            if (termName.equalsIgnoreCase(Terms.SPECIES_KEY)) {
                                t = Terms.getSpeciesTerm();
                            } else if (termName.equalsIgnoreCase(Terms.STRAIN_KEY)) {
                                t = Terms.getStrainTerm();
                            } else if (termName.equalsIgnoreCase(Terms.TISSUE_KEY)) {
                                t = Terms.getTissueTerm();
                            } else if (termName.equalsIgnoreCase(Terms.TRANSPOSON_KEY)) {
                                t = Terms.getTransposonTerm();
                            } else if (termName.equalsIgnoreCase(Terms.PLASMID_KEY)) {
                                t = Terms.getPlasmidTerm();
                            } else {
                                throw new ParseException("Invalid RC term found: " + termName);
                            }
                            rlistener.addSequenceProperty(t, ref_rank + ":" + subparts[1].trim());
                        }
                    }
                    CrossRef pcr = null;
                    if (pubmed != null) {
                        pcr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? UniProtFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{"PUBMED", pubmed, new Integer(0)});
                        SimpleRankedCrossRef rpcr = new SimpleRankedCrossRef(pcr, 0);
                        rlistener.setRankedCrossRef(rpcr);
                    }
                    CrossRef mcr = null;
                    if (medline != null) {
                        mcr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? UniProtFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{"MEDLINE", medline, new Integer(0)});
                        SimpleRankedCrossRef rmcr = new SimpleRankedCrossRef(mcr, 0);
                        rlistener.setRankedCrossRef(rmcr);
                    }
                    CrossRef dcr = null;
                    if (doi != null) {
                        dcr = (CrossRef)RichObjectFactory.getObject(class$org$biojavax$SimpleCrossRef == null ? UniProtFormat.class$("org.biojavax.SimpleCrossRef") : class$org$biojavax$SimpleCrossRef, new Object[]{"DOI", doi, new Integer(0)});
                        SimpleRankedCrossRef rdcr = new SimpleRankedCrossRef(dcr, 0);
                        rlistener.setRankedCrossRef(rdcr);
                    }
                    try {
                        ArrayList<SimpleDocRefAuthor> auths = null;
                        if (authors != null) {
                            auths = DocRefAuthor.Tools.parseAuthorString(authors);
                        }
                        if (consortium != null) {
                            if (auths == null) {
                                auths = new ArrayList<SimpleDocRefAuthor>();
                            }
                            auths.add(new SimpleDocRefAuthor(consortium, true, false));
                        }
                        DocRef dr = (DocRef)RichObjectFactory.getObject(class$org$biojavax$SimpleDocRef == null ? UniProtFormat.class$("org.biojavax.SimpleDocRef") : class$org$biojavax$SimpleDocRef, new Object[]{auths, locator, title});
                        if (mcr != null) {
                            dr.setCrossref(mcr);
                        } else if (pcr != null) {
                            dr.setCrossref(pcr);
                        } else if (dcr != null) {
                            dr.setCrossref(dcr);
                        }
                        if (!this.getElideComments()) {
                            dr.setRemark(remark);
                        }
                        SimpleRankedDocRef rdr = new SimpleRankedDocRef(dr, rstart, rend, ref_rank);
                        rlistener.setRankedDocRef(rdr);
                    }
                    catch (ChangeVetoException e) {
                        throw new ParseException(e);
                    }
                } else {
                    if (sectionKey.equals(COMMENT_TAG) && !this.getElideComments()) {
                        String val = ((String[])section.get(0))[1];
                        if (UniProtCommentParser.isParseable(val)) {
                            rlistener.setComment(val);
                            continue;
                        }
                        rlistener.addSequenceProperty(Terms.getCopyrightTerm(), val);
                        continue;
                    }
                    if (sectionKey.equals(FEATURE_TAG) && !this.getElideFeatures()) {
                        boolean seenAFeature = false;
                        for (int i = 1; i < section.size(); ++i) {
                            String key = ((String[])section.get(i))[0];
                            String val = ((String[])section.get(i))[1];
                            if ((val = val.replaceAll("\\s*[\\n\\r]+\\s*", " ").trim()).endsWith(".")) {
                                val = val.substring(0, val.length() - 1);
                            }
                            if (key.startsWith("/")) {
                                if ((key = key.substring(1)).equals("FTId")) {
                                    rlistener.addFeatureProperty(Terms.getFTIdTerm(), val);
                                    continue;
                                }
                                rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(key), val);
                                continue;
                            }
                            if (seenAFeature) {
                                rlistener.endFeature();
                            }
                            RichFeature.Template templ = new RichFeature.Template();
                            templ.annotation = new SimpleRichAnnotation();
                            templ.sourceTerm = Terms.getUniProtTerm();
                            templ.typeTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm(key);
                            templ.featureRelationshipSet = new TreeSet();
                            templ.rankedCrossRefs = new TreeSet();
                            String desc = null;
                            Matcher m = fp.matcher(val);
                            if (!m.matches()) {
                                throw new ParseException("Bad feature value: " + val);
                            }
                            String loc = m.group(1);
                            desc = m.group(3);
                            templ.location = UniProtLocationParser.parseLocation(loc);
                            rlistener.startFeature(templ);
                            if (desc != null) {
                                rlistener.addFeatureProperty(Terms.getFeatureDescTerm(), desc);
                            }
                            seenAFeature = true;
                        }
                        if (!seenAFeature) continue;
                        rlistener.endFeature();
                        continue;
                    }
                    if (!sectionKey.equals(START_SEQUENCE_TAG) || this.getElideSymbols()) continue;
                    StringBuffer seq = new StringBuffer();
                    for (int i = 0; i < section.size(); ++i) {
                        seq.append(((String[])section.get(i))[1]);
                    }
                    try {
                        SimpleSymbolList sl = new SimpleSymbolList(symParser, seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                        rlistener.addSymbols(symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                    }
                    catch (Exception e) {
                        throw new ParseException(e);
                    }
                }
            } while (!sectionKey.equals(END_SEQUENCE_TAG));
            do {
                reader.mark(1);
                c = reader.read();
                if (c != -1) continue;
                hasAnotherSequence = false;
                break block108;
            } while (Character.isWhitespace((char)c));
            reader.reset();
        }
        rlistener.endSequence();
        return hasAnotherSequence;
    }

    /*
     * Unable to fully structure code
     */
    private List readSection(BufferedReader br) throws ParseException {
        section = new ArrayList<String[]>();
        done = false;
lbl3:
        // 4 sources

        try {
            while (!done) {
                block26: {
                    block25: {
                        br.mark(160);
                        line = br.readLine();
                        if (line.length() < 2) {
                            throw new ParseException("Bad line found: " + line);
                        }
                        token = line.substring(0, 2);
                        if (token.equals("SQ")) {
                            sb = new StringBuffer();
                            while (!done) {
                                br.mark(160);
                                line = br.readLine();
                                if (line.startsWith("//")) {
                                    br.reset();
                                    done = true;
                                    continue;
                                }
                                sb.append(line);
                            }
                            section.add(new String[]{"SQ", sb.toString()});
                            continue;
                        }
                        if (!token.equals("CC")) break block25;
                        currentVal = new StringBuffer();
                        wasMisc = false;
                        if (!line.startsWith("CC   -!-")) {
                            wasMisc = true;
                        }
                        currentVal.append(line.substring(5));
                        while (!done) {
                            br.mark(160);
                            line = br.readLine();
                            if (!wasMisc && line.charAt(5) != ' ' || !line.startsWith("C") || line.startsWith("CC   -!-")) {
                                br.reset();
                                done = true;
                                section.add(new String[]{"CC", currentVal.toString()});
                                continue;
                            }
                            currentVal.append("\n");
                            currentVal.append(line.substring(5));
                        }
                        ** GOTO lbl3
                    }
                    if (!token.equals("FT")) break block26;
                    br.reset();
                    currentTag = null;
                    currentVal = new StringBuffer();
                    section.add(new String[]{"FT", null});
                    while (!done) {
                        br.mark(160);
                        line = br.readLine();
                        if (!line.startsWith("FT")) {
                            br.reset();
                            done = true;
                            if (currentTag == null) continue;
                            section.add(new String[]{currentTag, currentVal.toString()});
                            continue;
                        }
                        if (!(line = line.substring(5)).startsWith(" ")) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            currentTag = line.substring(0, 8).trim();
                            currentVal = new StringBuffer();
                            currentVal.append(line.substring(8).trim());
                            continue;
                        }
                        if ((line = line.trim()).startsWith("/")) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            currentVal = new StringBuffer();
                            equalIndex = line.indexOf(61);
                            if (equalIndex >= 0) {
                                currentTag = line.substring(0, equalIndex);
                                currentVal.append(line.substring(equalIndex + 1));
                                continue;
                            }
                            currentTag = line;
                            continue;
                        }
                        currentVal.append("\n");
                        currentVal.append(line);
                    }
                    ** GOTO lbl3
                }
                if (token.equals("DR")) {
                    section.add(new String[]{"DR", line.substring(5).trim()});
                    done = true;
                    continue;
                }
                if (token.equals("DT")) {
                    section.add(new String[]{"DT", line.substring(5).trim()});
                    done = true;
                    continue;
                }
                if (token.equals("//")) {
                    section.add(new String[]{"//", null});
                    done = true;
                    continue;
                }
                br.reset();
                currentTag = null;
                currentTagStart = '\u0000';
                currentVal = null;
                while (!done) {
                    br.mark(160);
                    line = br.readLine();
                    if (currentTagStart == '\u0000') {
                        currentTagStart = line.charAt(0);
                    }
                    if (!line.startsWith("" + currentTagStart) || currentTagStart == 'D' && currentTag != null && !line.startsWith("" + currentTag) || currentTagStart == 'R' && currentTag != null && line.startsWith("RN")) {
                        br.reset();
                        done = true;
                        if (currentTag == null) continue;
                        section.add(new String[]{currentTag, currentVal.toString()});
                        continue;
                    }
                    tag = line.substring(0, 2);
                    value = line.substring(5);
                    if (currentTag == null || !tag.equals(currentTag)) {
                        if (currentTag != null) {
                            section.add(new String[]{currentTag, currentVal.toString()});
                        }
                        currentTag = tag;
                        currentVal = new StringBuffer();
                        currentVal.append(value);
                        continue;
                    }
                    currentVal.append("\n");
                    currentVal.append(value);
                }
                ** GOTO lbl3
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        return section;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        SymbolTokenization tok;
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        try {
            tok = rs.getAlphabet().getTokenization("token");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get alphabet tokenizer", e);
        }
        Set notes = rs.getNoteSet();
        String accession = rs.getAccession();
        StringBuffer accessions = new StringBuffer();
        accessions.append(accession);
        accessions.append(";");
        String cdat = null;
        String udat = null;
        String adat = null;
        String dbname = "?";
        String urel = null;
        String arel = null;
        String organelle = null;
        String dataclass = "STANDARD";
        TreeMap speciesRecs = new TreeMap();
        TreeMap strainRecs = new TreeMap();
        TreeMap tissueRecs = new TreeMap();
        TreeMap transpRecs = new TreeMap();
        TreeMap plasmidRecs = new TreeMap();
        TreeMap<Integer, String> genenames = new TreeMap<Integer, String>();
        TreeMap genesynonyms = new TreeMap();
        TreeMap orfnames = new TreeMap();
        TreeMap ordlocnames = new TreeMap();
        Iterator i = notes.iterator();
        while (i.hasNext()) {
            Integer refID;
            int colon;
            String ref;
            Note n = (Note)i.next();
            if (n.getTerm().equals(Terms.getDateCreatedTerm())) {
                cdat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateAnnotatedTerm())) {
                adat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getUniProtDBNameTerm())) {
                dbname = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelUpdatedTerm())) {
                urel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelAnnotatedTerm())) {
                arel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDataClassTerm())) {
                dataclass = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.append(" ");
                accessions.append(n.getValue());
                accessions.append(";");
                continue;
            }
            if (n.getTerm().equals(Terms.getOrganelleTerm())) {
                organelle = (organelle == null ? "" : organelle + "; ") + n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getGeneNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                genenames.put(refID, ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getGeneSynonymTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (genesynonyms.get(refID) == null) {
                    genesynonyms.put(refID, new ArrayList());
                }
                ((List)genesynonyms.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getOrderedLocusNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (ordlocnames.get(refID) == null) {
                    ordlocnames.put(refID, new ArrayList());
                }
                ((List)ordlocnames.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getORFNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (orfnames.get(refID) == null) {
                    orfnames.put(refID, new ArrayList());
                }
                ((List)orfnames.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getSpeciesTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (speciesRecs.get(refID) == null) {
                    speciesRecs.put(refID, new ArrayList());
                }
                ((List)speciesRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getStrainTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (strainRecs.get(refID) == null) {
                    strainRecs.put(refID, new ArrayList());
                }
                ((List)strainRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getTissueTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (tissueRecs.get(refID) == null) {
                    tissueRecs.put(refID, new ArrayList());
                }
                ((List)tissueRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getTransposonTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (transpRecs.get(refID) == null) {
                    transpRecs.put(refID, new ArrayList());
                }
                ((List)transpRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (!n.getTerm().equals(Terms.getPlasmidTerm())) continue;
            ref = n.getValue();
            colon = ref.indexOf(58);
            refID = new Integer(0);
            if (colon >= 1) {
                refID = new Integer(ref.substring(0, colon));
            }
            if (plasmidRecs.get(refID) == null) {
                plasmidRecs.put(refID, new ArrayList());
            }
            ((List)plasmidRecs.get(refID)).add(ref.substring(colon + 1));
        }
        StringBuffer locusLine = new StringBuffer();
        locusLine.append(StringTools.rightPad(rs.getName() + "_" + rs.getDivision(), 11));
        locusLine.append(" ");
        locusLine.append(StringTools.leftPad(dataclass, 12));
        locusLine.append(";      PRT; ");
        locusLine.append(StringTools.leftPad("" + rs.length(), 5));
        locusLine.append(" AA.");
        StringTools.writeKeyValueLine(LOCUS_TAG, locusLine.toString(), 5, this.getLineWidth(), null, LOCUS_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(ACCESSION_TAG, accessions.toString(), 5, this.getLineWidth(), null, ACCESSION_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, (cdat == null ? udat : cdat) + ", integrated into UniProtKB/" + dbname + ".", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, udat + ", sequence version " + (urel == null ? "0" : urel) + ".", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, (adat == null ? udat : adat) + ", entry version " + (arel == null ? "0" : arel) + ".", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DEFINITION_TAG, rs.getDescription() + ".", 5, this.getLineWidth(), null, DEFINITION_TAG, this.getPrintStream());
        Iterator i2 = genenames.keySet().iterator();
        while (i2.hasNext()) {
            Iterator j;
            Integer geneid = (Integer)i2.next();
            String genename = (String)genenames.get(geneid);
            List synonyms = (List)genesynonyms.get(geneid);
            List orfs = (List)orfnames.get(geneid);
            List ordlocs = (List)ordlocnames.get(geneid);
            StringBuffer gnline = new StringBuffer();
            gnline.append(Terms.GENENAME_KEY);
            gnline.append("=");
            gnline.append(genename);
            gnline.append("; ");
            if (synonyms != null) {
                gnline.append(Terms.GENESYNONYM_KEY);
                gnline.append("=");
                j = synonyms.iterator();
                while (j.hasNext()) {
                    gnline.append((String)j.next());
                    if (!j.hasNext()) continue;
                    gnline.append(", ");
                }
                gnline.append("; ");
            }
            if (ordlocs != null) {
                gnline.append(Terms.ORDLOCNAME_KEY);
                gnline.append("=");
                j = ordlocs.iterator();
                while (j.hasNext()) {
                    gnline.append((String)j.next());
                    if (!j.hasNext()) continue;
                    gnline.append(", ");
                }
                gnline.append("; ");
            }
            if (orfs != null) {
                gnline.append(Terms.ORFNAME_KEY);
                gnline.append("=");
                j = orfs.iterator();
                while (j.hasNext()) {
                    gnline.append((String)j.next());
                    if (!j.hasNext()) continue;
                    gnline.append(", ");
                }
                gnline.append("; ");
            }
            StringTools.writeKeyValueLine(GENE_TAG, gnline.toString(), 5, this.getLineWidth(), null, GENE_TAG, this.getPrintStream());
            if (!i2.hasNext()) continue;
            StringTools.writeKeyValueLine(GENE_TAG, "and", 5, this.getLineWidth(), null, GENE_TAG, this.getPrintStream());
        }
        NCBITaxon tax = rs.getTaxon();
        if (tax != null) {
            StringBuffer source = new StringBuffer();
            source.append(tax.getDisplayName());
            Iterator j = tax.getNames("synonym").iterator();
            while (j.hasNext()) {
                source.append(" (");
                source.append((String)j.next());
                source.append(")");
            }
            source.append(".");
            StringTools.writeKeyValueLine(SOURCE_TAG, source.toString(), 5, this.getLineWidth(), null, SOURCE_TAG, this.getPrintStream());
            if (organelle != null) {
                StringTools.writeKeyValueLine(ORGANELLE_TAG, organelle + ".", 5, this.getLineWidth(), null, ORGANELLE_TAG, this.getPrintStream());
            }
            StringTools.writeKeyValueLine(ORGANISM_TAG, tax.getNameHierarchy(), 5, this.getLineWidth(), null, SOURCE_TAG, this.getPrintStream());
            StringTools.writeKeyValueLine(TAXON_TAG, "NCBI_TaxID=" + tax.getNCBITaxID() + ";", 5, this.getLineWidth(), this.getPrintStream());
        }
        Iterator r = rs.getRankedDocRefs().iterator();
        while (r.hasNext()) {
            CrossRef c;
            Iterator i3;
            RankedDocRef rdr = (RankedDocRef)r.next();
            DocRef d = rdr.getDocumentReference();
            StringTools.writeKeyValueLine(REFERENCE_TAG, "[" + rdr.getRank() + "]", 5, this.getLineWidth(), null, REFERENCE_TAG, this.getPrintStream());
            StringTools.writeKeyValueLine(RP_LINE_TAG, d.getRemark() + ".", 5, this.getLineWidth(), null, RP_LINE_TAG, this.getPrintStream());
            if (rdr.getStart() != null && rdr.getEnd() != null && !rppat.matcher(d.getRemark()).matches()) {
                StringTools.writeKeyValueLine(RP_LINE_TAG, "SEQUENCE OF " + rdr.getStart() + "-" + rdr.getEnd() + ".", 5, this.getLineWidth(), null, RP_LINE_TAG, this.getPrintStream());
            }
            StringBuffer rcline = new StringBuffer();
            Integer rank = new Integer(rdr.getRank());
            if (speciesRecs.get(rank) != null) {
                rcline.append(Terms.SPECIES_KEY);
                rcline.append("=");
                i3 = ((List)speciesRecs.get(rank)).iterator();
                while (i3.hasNext()) {
                    rcline.append((String)i3.next());
                    if (!i3.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (strainRecs.get(rank) != null) {
                rcline.append(Terms.STRAIN_KEY);
                rcline.append("=");
                i3 = ((List)strainRecs.get(rank)).iterator();
                while (i3.hasNext()) {
                    rcline.append((String)i3.next());
                    if (!i3.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (tissueRecs.get(rank) != null) {
                rcline.append(Terms.TISSUE_KEY);
                rcline.append("=");
                i3 = ((List)tissueRecs.get(rank)).iterator();
                while (i3.hasNext()) {
                    rcline.append((String)i3.next());
                    if (!i3.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (transpRecs.get(rank) != null) {
                rcline.append(Terms.TRANSPOSON_KEY);
                rcline.append("=");
                i3 = ((List)transpRecs.get(rank)).iterator();
                while (i3.hasNext()) {
                    rcline.append((String)i3.next());
                    if (!i3.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (plasmidRecs.get(rank) != null) {
                rcline.append(Terms.PLASMID_KEY);
                rcline.append("=");
                i3 = ((List)plasmidRecs.get(rank)).iterator();
                while (i3.hasNext()) {
                    rcline.append((String)i3.next());
                    if (!i3.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (rcline.length() > 0) {
                StringTools.writeKeyValueLine(RC_LINE_TAG, rcline.toString(), 5, this.getLineWidth(), null, RC_LINE_TAG, this.getPrintStream());
            }
            if ((c = d.getCrossref()) != null) {
                StringTools.writeKeyValueLine(REFERENCE_XREF_TAG, c.getDbname() + "=" + c.getAccession() + ";", 5, this.getLineWidth(), null, REFERENCE_XREF_TAG, this.getPrintStream());
            }
            List auths = d.getAuthorList();
            Iterator j = auths.iterator();
            while (j.hasNext()) {
                DocRefAuthor a = (DocRefAuthor)j.next();
                if (!a.isConsortium()) continue;
                StringTools.writeKeyValueLine(CONSORTIUM_TAG, a.getName() + ";", 5, this.getLineWidth(), null, CONSORTIUM_TAG, this.getPrintStream());
                j.remove();
            }
            if (!auths.isEmpty()) {
                StringTools.writeKeyValueLine(AUTHORS_TAG, DocRefAuthor.Tools.generateAuthorString(auths) + ";", 5, this.getLineWidth(), null, AUTHORS_TAG, this.getPrintStream());
            }
            if (d.getTitle() != null && d.getTitle().length() != 0) {
                StringTools.writeKeyValueLine(TITLE_TAG, "\"" + d.getTitle() + "\";", 5, this.getLineWidth(), null, TITLE_TAG, this.getPrintStream());
            }
            StringTools.writeKeyValueLine(LOCATION_TAG, d.getLocation() + ".", 5, this.getLineWidth(), null, LOCATION_TAG, this.getPrintStream());
        }
        if (!rs.getComments().isEmpty()) {
            Iterator i4 = rs.getComments().iterator();
            while (i4.hasNext()) {
                SimpleComment c = (SimpleComment)i4.next();
                String text = c.getComment().trim();
                if (text.length() > 3 && text.substring(0, 3).equals("-!-")) {
                    StringTools.writeKeyValueLine("CC   -!- ", text.substring(4), 9, this.getLineWidth(), null, COMMENT_TAG, this.getPrintStream());
                    continue;
                }
                StringTools.writeKeyValueLine(COMMENT_TAG, text, 5, this.getLineWidth(), null, COMMENT_TAG, this.getPrintStream());
            }
        }
        r = rs.getRankedCrossRefs().iterator();
        while (r.hasNext()) {
            RankedCrossRef rcr = (RankedCrossRef)r.next();
            CrossRef c = rcr.getCrossRef();
            Set noteset = c.getNoteSet();
            StringBuffer sb = new StringBuffer();
            sb.append(c.getDbname());
            sb.append("; ");
            sb.append(c.getAccession());
            boolean hasSecondary = false;
            Iterator i5 = noteset.iterator();
            while (i5.hasNext()) {
                Note n = (Note)i5.next();
                if (!n.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                sb.append("; ");
                sb.append(n.getValue());
                hasSecondary = true;
            }
            if (!hasSecondary) {
                sb.append("; -");
            }
            sb.append(".");
            StringTools.writeKeyValueLine(DATABASE_XREF_TAG, sb.toString(), 5, this.getLineWidth(), null, DATABASE_XREF_TAG, this.getPrintStream());
        }
        String keywords = null;
        Iterator n = notes.iterator();
        while (n.hasNext()) {
            Note nt = (Note)n.next();
            if (!nt.getTerm().equals(Terms.getKeywordTerm())) continue;
            if (keywords == null) {
                keywords = nt.getValue();
                continue;
            }
            keywords = keywords + "; " + nt.getValue();
        }
        if (keywords != null) {
            StringTools.writeKeyValueLine(KEYWORDS_TAG, keywords + ".", 5, this.getLineWidth(), null, KEYWORDS_TAG, this.getPrintStream());
        }
        Iterator i6 = rs.getFeatureSet().iterator();
        while (i6.hasNext()) {
            RichFeature f = (RichFeature)i6.next();
            String desc = "";
            String ftid = null;
            Iterator j = f.getNoteSet().iterator();
            while (j.hasNext()) {
                Note n2 = (Note)j.next();
                if (n2.getTerm().equals(Terms.getFTIdTerm())) {
                    ftid = n2.getValue();
                    continue;
                }
                if (!n2.getTerm().equals(Terms.getFeatureDescTerm())) continue;
                desc = n2.getValue();
            }
            String kw = f.getTypeTerm().getName();
            String leader = StringTools.rightPad(kw, 8) + " " + UniProtLocationParser.writeLocation((RichLocation)f.getLocation());
            StringTools.writeKeyValueLine("FT   " + leader, desc + ".", 29, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
            if (ftid == null) continue;
            StringTools.writeKeyValueLine(FEATURE_TAG, "/FTId=" + ftid + ".", 29, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
        }
        int mw = 0;
        try {
            mw = (int)MassCalc.getMass(rs, "avgMass", false);
        }
        catch (IllegalSymbolException e) {
            throw new RuntimeException("Found illegal symbol", e);
        }
        CRC64Checksum crc = new CRC64Checksum();
        String seqstr = rs.seqString();
        crc.update(seqstr.getBytes(), 0, seqstr.length());
        this.getPrintStream().print("SQ   SEQUENCE " + StringTools.rightPad("" + rs.length(), 4) + " AA; ");
        this.getPrintStream().print(StringTools.rightPad("" + mw, 5) + " MW; ");
        this.getPrintStream().println(crc + " CRC64;");
        Symbol[] syms = rs.toList().toArray(new Symbol[0]);
        int symCount = 0;
        this.getPrintStream().print("    ");
        for (int i7 = 0; i7 < syms.length; ++i7) {
            if (symCount % 60 == 0 && symCount > 0) {
                this.getPrintStream().print("\n    ");
            }
            if (symCount % 10 == 0) {
                this.getPrintStream().print(" ");
            }
            try {
                this.getPrintStream().print(tok.tokenizeSymbol(syms[i7]));
            }
            catch (IllegalSymbolException e) {
                throw new RuntimeException("Found illegal symbol: " + syms[i7]);
            }
            ++symCount;
        }
        this.getPrintStream().print("\n");
        this.getPrintStream().println(END_SEQUENCE_TAG);
    }

    public String getDefaultFormat() {
        return UNIPROT_FORMAT;
    }

    static {
        RichSequence.IOTools.registerFormat(UniProtFormat.class);
        lp = Pattern.compile("^((\\S+)_(\\S+))\\s+(\\S+);\\s+(PRT);\\s+\\d+\\s+AA\\.$");
        rppat = Pattern.compile("SEQUENCE OF (\\d+)-(\\d+)");
        dp = Pattern.compile("([^,]+),([^\\d\\.]+)(\\d+)?\\.$");
        fp = Pattern.compile("^\\s*([\\d?<]+\\s+[\\d?>]+)(\\s+(.*))?$");
        headerLine = Pattern.compile("^ID.*");
    }

    public static class Terms
    extends RichSequence.Terms {
        private static ComparableTerm UNIPROT_TERM = null;
        private static ComparableTerm UNIPROT_DBNAME_TERM = null;
        private static String GENENAME_KEY = "Name";
        private static String GENESYNONYM_KEY = "Synonyms";
        private static String ORDLOCNAME_KEY = "OrderedLocusNames";
        private static String ORFNAME_KEY = "ORFNames";

        public static ComparableTerm getUniProtTerm() {
            if (UNIPROT_TERM == null) {
                UNIPROT_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm(UniProtFormat.UNIPROT_FORMAT);
            }
            return UNIPROT_TERM;
        }

        public static ComparableTerm getUniProtDBNameTerm() {
            if (UNIPROT_DBNAME_TERM == null) {
                UNIPROT_DBNAME_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("UniProt database name");
            }
            return UNIPROT_DBNAME_TERM;
        }
    }
}

