/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.functions.AbstractSelectionFunction;
import org.biojavax.ga.functions.FitnessFunction;

public interface SelectionFunction {
    public static final SelectionFunction DEFAULT = new SelectAll();
    public static final ChangeType FITNESS_FUNCTION = new ChangeType("Fitness function changed", 1.class$org$biojavax$ga$functions$SelectionFunction == null ? (1.class$org$biojavax$ga$functions$SelectionFunction = 1.class$("org.biojavax.ga.functions.SelectionFunction")) : 1.class$org$biojavax$ga$functions$SelectionFunction, "FITNESS_FUNCTION");

    public Population select(Population var1, GeneticAlgorithm var2) throws ChangeVetoException;

    public void setFitnessFunction(FitnessFunction var1) throws ChangeVetoException;

    public FitnessFunction getFitnessFunction();

    static class 1 {
        static /* synthetic */ Class class$org$biojavax$ga$functions$SelectionFunction;
    }

    public static final class SelectAll
    implements SelectionFunction {
        public Population select(Population pop, GeneticAlgorithm genAlg) {
            return pop;
        }

        public FitnessFunction getFitnessFunction() {
            throw new UnsupportedOperationException("No FitnessFunction defined for SelectAll SelectionFunction");
        }

        public void setFitnessFunction(FitnessFunction func) throws ChangeVetoException {
            throw new ChangeVetoException("Cannot set the FitnessFunction of SelectAll SelectionFunction");
        }
    }

    public static final class Threshold
    extends AbstractSelectionFunction {
        private double cutoff;

        public Threshold(double cutoff) {
            this.cutoff = cutoff;
        }

        public double getCutoff() {
            return this.cutoff;
        }

        public Population select(Population pop, GeneticAlgorithm genAlg) {
            Iterator i = pop.getOrganisms().iterator();
            while (i.hasNext()) {
                Organism o = (Organism)i.next();
                try {
                    if (!(this.getFitnessFunction().fitness(o, pop, genAlg) < this.cutoff)) continue;
                    pop.removeOrganism(o);
                }
                catch (ChangeVetoException ex) {
                    throw new BioError("population has been locked, cannot select individuals", ex);
                }
            }
            return pop;
        }
    }
}

