/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ontology;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RankedCrossRef;
import org.biojavax.RichAnnotation;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;

public class SimpleComparableTerm
extends AbstractChangeable
implements ComparableTerm {
    private String name;
    private String description;
    private ComparableOntology ontology;
    private String identifier;
    private Boolean obsolete;
    private Set synonyms = new TreeSet();
    private Set rankedcrossrefs = new TreeSet();
    private Integer id;

    SimpleComparableTerm(ComparableOntology ontology, String name, Object[] synonyms) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology must not be null");
        }
        this.name = name;
        this.description = null;
        this.ontology = ontology;
        this.identifier = null;
        this.obsolete = Boolean.FALSE;
        if (synonyms != null && synonyms.length != 0) {
            this.synonyms.addAll(Arrays.asList(synonyms));
        }
    }

    protected SimpleComparableTerm() {
    }

    public int hashCode() {
        int value = 17;
        if (this.ontology == null) {
            return value;
        }
        value = 37 * value + this.name.hashCode();
        value = 37 * value + this.ontology.hashCode();
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Term)) {
            return false;
        }
        if (this.ontology == null) {
            return false;
        }
        Term that = (Term)obj;
        return this.ontology.equals(that.getOntology()) && this.name.equals(that.getName());
    }

    public int compareTo(Object o) {
        if (this.ontology == null) {
            return -1;
        }
        Term them = (Term)o;
        if (!this.ontology.equals(them.getOntology())) {
            return this.ontology.compareTo(them.getOntology());
        }
        return this.name.compareTo(them.getName());
    }

    public void addSynonym(Object synonym) {
        this.synonyms.add(synonym);
    }

    public void removeSynonym(Object synonym) {
        this.synonyms.remove(synonym);
    }

    public Object[] getSynonyms() {
        return this.synonyms.toArray();
    }

    private Set getSynonymSet() {
        return this.synonyms;
    }

    private void setSynonymSet(Set synonyms) {
        this.synonyms = synonyms;
    }

    public Set getRankedCrossRefs() {
        return this.rankedcrossrefs;
    }

    public void setRankedCrossRefs(Set rankedcrossrefs) throws ChangeVetoException {
        this.rankedcrossrefs = rankedcrossrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRankedCrossRef(RankedCrossRef crossref) throws ChangeVetoException {
        if (crossref == null) {
            throw new IllegalArgumentException("Crossref cannot be null");
        }
        if (!this.hasListeners(ComparableTerm.RANKEDCROSSREF)) {
            this.rankedcrossrefs.add(crossref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTerm.RANKEDCROSSREF, crossref, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTerm.RANKEDCROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rankedcrossrefs.add(crossref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRankedCrossRef(RankedCrossRef crossref) throws ChangeVetoException {
        if (crossref == null) {
            throw new IllegalArgumentException("Crossref cannot be null");
        }
        if (!this.hasListeners(ComparableTerm.RANKEDCROSSREF)) {
            this.rankedcrossrefs.remove(crossref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTerm.RANKEDCROSSREF, null, crossref);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTerm.RANKEDCROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rankedcrossrefs.remove(crossref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) throws ChangeVetoException {
        if (!this.hasListeners(ComparableTerm.DESCRIPTION)) {
            this.description = description;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTerm.DESCRIPTION, description, this.description);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTerm.DESCRIPTION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.description = description;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    private void setOntology(ComparableOntology ontology) {
        this.ontology = ontology;
    }

    public String toString() {
        boolean isobs = this.obsolete != null && this.obsolete != false;
        return this.ontology + ":" + this.name + (isobs ? " [obsolete]" : "");
    }

    public Annotation getAnnotation() {
        return RichAnnotation.EMPTY_ANNOTATION;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentifier(String identifier) throws ChangeVetoException {
        if (!this.hasListeners(ComparableTerm.IDENTIFIER)) {
            this.identifier = identifier;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTerm.IDENTIFIER, identifier, this.identifier);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTerm.IDENTIFIER);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.identifier = identifier;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    private String getObsoleteChar() {
        return this.getObsolete() != null && this.getObsolete().equals(Boolean.TRUE) ? "X" : null;
    }

    private void setObsoleteChar(String obsolete) throws ChangeVetoException {
        this.setObsolete(obsolete != null && obsolete.equals("X"));
    }

    public Boolean getObsolete() {
        return this.obsolete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObsolete(Boolean obsolete) throws ChangeVetoException {
        if (!this.hasListeners(ComparableTerm.OBSOLETE)) {
            this.obsolete = obsolete;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTerm.OBSOLETE, obsolete, this.obsolete);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTerm.OBSOLETE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.obsolete = obsolete;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    private Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }
}

