/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ontology;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RichAnnotation;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.ontology.ComparableTriple;

public class SimpleComparableTriple
extends AbstractChangeable
implements ComparableTriple {
    private ComparableOntology ontology;
    private ComparableTerm object;
    private ComparableTerm subject;
    private ComparableTerm predicate;
    private Set descriptors = new TreeSet();
    private Integer id;

    SimpleComparableTriple(ComparableOntology ontology, ComparableTerm subject, ComparableTerm object, ComparableTerm predicate) {
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology must not be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Object must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        this.ontology = ontology;
        this.subject = subject;
        this.object = object;
        this.predicate = predicate;
    }

    protected SimpleComparableTriple() {
    }

    public int compareTo(Object o) {
        Triple them = (Triple)o;
        if (this.ontology == null) {
            return -1;
        }
        if (!this.ontology.equals(them.getOntology())) {
            return this.ontology.compareTo((ComparableOntology)them.getOntology());
        }
        if (!this.subject.equals(them.getSubject())) {
            return this.subject.compareTo((ComparableTerm)them.getSubject());
        }
        if (!this.object.equals(them.getObject())) {
            return this.object.compareTo((ComparableTerm)them.getObject());
        }
        return this.predicate.compareTo((ComparableTerm)them.getPredicate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Triple)) {
            return false;
        }
        if (this.ontology == null) {
            return false;
        }
        Triple them = (Triple)o;
        return this.ontology.equals(them.getOntology()) && this.subject.equals(them.getSubject()) && this.object.equals(them.getObject()) && this.predicate.equals(them.getPredicate());
    }

    public int hashCode() {
        int code = 17;
        if (this.ontology == null) {
            return code;
        }
        code = 37 * code + this.ontology.hashCode();
        code = 37 * code + this.subject.hashCode();
        code = 37 * code + this.object.hashCode();
        code = 37 * code + this.predicate.hashCode();
        return code;
    }

    public String getName() {
        return this.toString();
    }

    public Term getSubject() {
        return this.subject;
    }

    private void setSubject(ComparableTerm subject) {
        this.subject = subject;
    }

    public Term getObject() {
        return this.object;
    }

    private void setObject(ComparableTerm object) {
        this.object = object;
    }

    public Term getPredicate() {
        return this.predicate;
    }

    private void setPredicate(ComparableTerm predicate) {
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptor(ComparableTerm desc) throws IllegalArgumentException, ChangeVetoException {
        if (desc == null) {
            throw new IllegalArgumentException("Cannot have null descriptor");
        }
        if (!this.hasListeners(ComparableTriple.DESCRIPTOR)) {
            this.descriptors.add(desc);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTriple.DESCRIPTOR, desc, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTriple.DESCRIPTOR);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.descriptors.add(desc);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDescriptor(ComparableTerm desc) throws IllegalArgumentException, ChangeVetoException {
        boolean result;
        if (desc == null) {
            throw new IllegalArgumentException("Cannot have null descriptor");
        }
        if (!this.hasListeners(ComparableTriple.DESCRIPTOR)) {
            result = this.descriptors.remove(desc);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableTriple.DESCRIPTOR, null, desc);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableTriple.DESCRIPTOR);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                result = this.descriptors.remove(desc);
                cs.firePostChangeEvent(ce);
            }
        }
        return result;
    }

    public Set getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Set descriptors) throws ChangeVetoException {
        this.descriptors = descriptors;
    }

    public void removeSynonym(Object synonym) {
        throw new UnsupportedOperationException("BioJavaX does not know about triple synonyms.");
    }

    public void addSynonym(Object synonym) {
        throw new UnsupportedOperationException("BioJavaX does not know about triple synonyms.");
    }

    public Object[] getSynonyms() {
        return Collections.EMPTY_LIST.toArray();
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    private void setOntology(ComparableOntology ontology) {
        this.ontology = ontology;
    }

    public String getDescription() {
        return "";
    }

    public Annotation getAnnotation() {
        return RichAnnotation.EMPTY_ANNOTATION;
    }

    public String toString() {
        return this.ontology + ":" + this.predicate + "(" + this.subject + "," + this.object + ")";
    }

    private Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }
}

