/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.utils;

import java.util.zip.Checksum;
import org.biojavax.utils.StringTools;

public class CRC64Checksum
implements Checksum {
    private static final long[] CRC64Tableh = new long[256];
    private static final long[] CRC64Tablel = new long[256];
    private long crcl;
    private long crch;

    public CRC64Checksum() {
        this.reset();
    }

    public void reset() {
        this.crcl = 0L;
        this.crch = 0L;
    }

    public void update(int c) {
        long shr = (this.crch & 0xFFL) << 24;
        long templh = this.crch >> 8;
        long templl = this.crcl >> 8 | shr;
        int tableindex = (int)((this.crcl ^ (long)c) & 0xFFL);
        this.crch = templh ^ CRC64Tableh[tableindex];
        this.crcl = templl ^ CRC64Tablel[tableindex];
    }

    public void update(byte[] values, int offset, int len) {
        for (int i = offset; i < offset + len; ++i) {
            this.update(values[i]);
        }
    }

    public long getValue() {
        return this.crch << 32 | this.crcl;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(StringTools.leftPad(Long.toHexString(this.crch), '0', 8));
        sb.append(StringTools.leftPad(Long.toHexString(this.crcl), '0', 8));
        return sb.toString();
    }

    static {
        long POLY64REVh = -671088640L;
        for (int i = 0; i < 256; ++i) {
            long partl = i;
            long parth = 0L;
            for (int j = 0; j < 8; ++j) {
                boolean rflag = (partl & 1L) > 0L;
                partl >>= 1;
                if ((parth & 1L) > 0L) {
                    partl |= 0x80000000L;
                }
                parth >>= 1;
                if (!rflag) continue;
                parth ^= POLY64REVh;
            }
            CRC64Checksum.CRC64Tableh[i] = parth;
            CRC64Checksum.CRC64Tablel[i] = partl;
        }
    }
}

