/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SequencesAsGFF;
import org.biojava.bio.program.xff.XFFWriter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.agave.AgaveWriter;
import org.biojava.directory.SystemRegistry;
import org.biojava.utils.xml.PrettyXMLWriter;

public class RFetch {
    private static void printUsage() {
        System.err.println("usage: rfetch [-fasta | -gff | -embl | -genbank | -agave | -xff] namespace id1 id2 ...");
    }

    public static void main(String[] args) throws Exception {
        SequenceDBLite seqDB;
        int startArgs;
        String format = "fasta";
        boolean all = false;
        for (startArgs = 0; startArgs < args.length && args[startArgs].startsWith("-"); ++startArgs) {
            String sw = args[startArgs];
            if ("-fasta".equals(sw)) {
                format = "fasta";
                continue;
            }
            if ("-gff".equals(sw)) {
                format = "gff";
                continue;
            }
            if ("-embl".equals(sw)) {
                format = "embl";
                continue;
            }
            if ("-genbank".equals(sw)) {
                format = "genbank";
                continue;
            }
            if ("-agave".equals(sw)) {
                format = "agave";
                continue;
            }
            if ("-xff".equals(sw)) {
                format = "xff";
                continue;
            }
            if ("-list".equals(sw)) {
                format = "list";
                continue;
            }
            if ("-all".equals(sw)) {
                all = true;
                continue;
            }
            System.err.println("Unknown switch: " + sw);
            RFetch.printUsage();
            return;
        }
        if (args.length - startArgs < 1) {
            RFetch.printUsage();
            return;
        }
        String namespace = args[startArgs++];
        try {
            seqDB = SystemRegistry.instance().getDatabase(namespace);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Can't access namespace " + namespace);
            return;
        }
        if (all) {
            if (seqDB instanceof SequenceDB) {
                SequenceDB lseqDB = (SequenceDB)seqDB;
                SequenceIterator si = lseqDB.sequenceIterator();
                while (si.hasNext()) {
                    RFetch.writeSequence(si.nextSequence(), format);
                }
            } else {
                System.err.println("Can't list namespace " + namespace);
            }
        } else if ("list".equals(format)) {
            if (seqDB instanceof SequenceDB) {
                SequenceDB lseqDB = (SequenceDB)seqDB;
                Iterator i = lseqDB.ids().iterator();
                while (i.hasNext()) {
                    System.out.println(i.next());
                }
            } else {
                System.err.println("Can't list namespace " + namespace);
            }
        } else {
            while (startArgs < args.length) {
                String name = args[startArgs++];
                Sequence seq = null;
                try {
                    seq = seqDB.getSequence(name);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (seq == null) continue;
                RFetch.writeSequence(seq, format);
            }
        }
    }

    private static void writeSequence(Sequence seq, String format) throws Exception {
        if ("embl".equals(format)) {
            new EmblLikeFormat().writeSequence(seq, System.out);
        } else if ("genbank".equals(format)) {
            new GenbankFormat().writeSequence(seq, System.out);
        } else if ("fasta".equals(format)) {
            new FastaFormat().writeSequence(seq, System.out);
        } else if ("gff".equals(format)) {
            SequencesAsGFF seqgff = new SequencesAsGFF();
            seqgff.setRecurse(true);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
            GFFWriter gffw = new GFFWriter(pw);
            seqgff.processSequence(seq, gffw);
            pw.flush();
        } else if ("xff".equals(format)) {
            XFFWriter xffw = new XFFWriter();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
            PrettyXMLWriter xw = new PrettyXMLWriter(pw);
            xffw.writeFeatureSet(seq, xw);
            pw.flush();
        } else if ("agave".equals(format)) {
            new AgaveWriter().writeSequence(seq, System.out);
        }
    }
}

