/*
 * Decompiled with CFR 0.152.
 */
package blastxml;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.sax.blastxml.BlastXMLParserFacade;
import org.biojava.bio.program.ssbind.BlastLikeSearchBuilder;
import org.biojava.bio.program.ssbind.SeqSimilarityAdapter;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.DummySequenceDB;
import org.biojava.bio.seq.db.DummySequenceDBInstallation;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BlastParser {
    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream(args[0]);
            BlastXMLParserFacade parser = new BlastXMLParserFacade();
            SeqSimilarityAdapter adapter = new SeqSimilarityAdapter();
            parser.setContentHandler(adapter);
            ArrayList results = new ArrayList();
            BlastLikeSearchBuilder builder = new BlastLikeSearchBuilder(results, new DummySequenceDB("queries"), new DummySequenceDBInstallation());
            adapter.setSearchContentHandler(builder);
            parser.parse(new InputSource(is));
            Iterator i = results.iterator();
            while (i.hasNext()) {
                SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)i.next();
                Annotation anno = result.getAnnotation();
                Iterator j = anno.keys().iterator();
                while (j.hasNext()) {
                    Object key = j.next();
                    Object property = anno.getProperty(key);
                    System.out.println(key + " : " + property);
                }
                System.out.println("Hits: ");
                Iterator k = result.getHits().iterator();
                while (k.hasNext()) {
                    SeqSimilaritySearchHit hit = (SeqSimilaritySearchHit)k.next();
                    System.out.print("\tmatch: " + hit.getSubjectID());
                    System.out.println("\te score: " + hit.getEValue());
                }
                System.out.println("\n");
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (BioException be) {
            be.printStackTrace();
        }
    }
}

