/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.Tools;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeVetoException;

public class TestOrderNAlphabet {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: java dist/TestOrderNDistribution <test seq length> <order>");
                System.exit(1);
            }
            SymbolList res = Tools.createSymbolList(Integer.parseInt(args[0]));
            int order = Integer.parseInt(args[1]);
            SymbolList view = SymbolListViews.orderNSymbolList(res, order);
            List<FiniteAlphabet> alphas = Collections.nCopies(order, DNATools.getDNA());
            FiniteAlphabet orderNAlfa = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(alphas);
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            Distribution orderNDistribution = DistributionFactory.DEFAULT.createDistribution(orderNAlfa);
            dtc.registerDistribution(orderNDistribution);
            dtc.clearCounts();
            for (int i = 1; i <= view.length(); ++i) {
                dtc.addCount(orderNDistribution, view.symbolAt(i), 1.0);
            }
            try {
                dtc.train();
            }
            catch (ChangeVetoException cve) {
                throw new AssertionFailure("couldn't train distribution");
            }
            SymbolTokenization tokenizer = orderNAlfa.getTokenization("name");
            Iterator i = orderNAlfa.iterator();
            while (i.hasNext()) {
                Symbol s = (Symbol)i.next();
                System.out.println(tokenizer.tokenizeSymbol(s) + "\t" + orderNDistribution.getWeight(s));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

