/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.Tools;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.OrderNDistributionFactory;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeVetoException;

public class TestOrderNDistribution {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: java dist/TestOrderNDistribution <test seq length> <order>");
                System.exit(1);
            }
            SymbolList res = Tools.createSymbolList(Integer.parseInt(args[0]));
            int order = Integer.parseInt(args[1]);
            SymbolList view = SymbolListViews.orderNSymbolList(res, order);
            List<FiniteAlphabet> alfaList = Collections.nCopies(order - 1, DNATools.getDNA());
            FiniteAlphabet NlessOneAlfa = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(alfaList);
            alfaList = new Vector<FiniteAlphabet>();
            alfaList.add(NlessOneAlfa);
            alfaList.add(DNATools.getDNA());
            FiniteAlphabet NAlfa = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(alfaList);
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            OrderNDistribution orderNDistribution = (OrderNDistribution)OrderNDistributionFactory.DEFAULT.createDistribution(NAlfa);
            dtc.registerDistribution(orderNDistribution);
            dtc.clearCounts();
            for (int i = 1; i <= view.length(); ++i) {
                dtc.addCount(orderNDistribution, view.symbolAt(i), 1.0);
            }
            try {
                dtc.train();
            }
            catch (ChangeVetoException cve) {
                throw new AssertionFailure("couldn't train distribution");
            }
            SymbolTokenization orderNTokenizer = orderNDistribution.getConditioningAlphabet().getTokenization("name");
            SymbolTokenization tokenizer = orderNDistribution.getConditionedAlphabet().getTokenization("name");
            FiniteAlphabet conditioningAlfa = (FiniteAlphabet)orderNDistribution.getConditioningAlphabet();
            FiniteAlphabet conditionedAlfa = (FiniteAlphabet)orderNDistribution.getConditionedAlphabet();
            Iterator i = conditioningAlfa.iterator();
            while (i.hasNext()) {
                Symbol s = (Symbol)i.next();
                System.out.print(orderNTokenizer.tokenizeSymbol(s));
                Distribution conditionedDist = orderNDistribution.getDistribution(s);
                Iterator j = conditionedAlfa.iterator();
                while (j.hasNext()) {
                    Symbol s1 = (Symbol)j.next();
                    System.out.print("\t" + tokenizer.tokenizeSymbol(s1) + "\t" + conditionedDist.getWeight(s1));
                }
                System.out.println("");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

