/*
 * Decompiled with CFR 0.152.
 */
package dp;

import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;

public class Dice {
    public static void main(String[] args) {
        try {
            MarkovModel casino = Dice.createCasino();
            DP dp = DPFactory.DEFAULT.createDP(casino);
            StatePath obs_rolls = dp.generate(300);
            SymbolList roll_sequence = obs_rolls.symbolListForLabel(StatePath.SEQUENCE);
            SymbolList[] res_array = new SymbolList[]{roll_sequence};
            StatePath v = dp.viterbi(res_array, ScoreType.PROBABILITY);
            for (int i = 0; i < obs_rolls.length() / 60 + 1; ++i) {
                int j;
                for (j = i * 60; j < Math.min((i + 1) * 60, obs_rolls.length()); ++j) {
                    System.out.print(obs_rolls.symbolAt(StatePath.SEQUENCE, j + 1).getName());
                }
                System.out.print("\n");
                for (j = i * 60; j < Math.min((i + 1) * 60, obs_rolls.length()); ++j) {
                    System.out.print(obs_rolls.symbolAt(StatePath.STATES, j + 1).getName().charAt(0));
                }
                System.out.print("\n");
                for (j = i * 60; j < Math.min((i + 1) * 60, obs_rolls.length()); ++j) {
                    System.out.print(v.symbolAt(StatePath.STATES, j + 1).getName().charAt(0));
                }
                System.out.print("\n\n");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static MarkovModel createCasino() {
        Distribution loadedD;
        Distribution fairD;
        Symbol[] rolls = new Symbol[6];
        SimpleAlphabet diceAlphabet = new SimpleAlphabet();
        diceAlphabet.setName("DiceAlphabet");
        for (int i = 1; i < 7; ++i) {
            try {
                rolls[i - 1] = AlphabetManager.createSymbol(String.valueOf(i), Annotation.EMPTY_ANNOTATION);
                diceAlphabet.addSymbol(rolls[i - 1]);
                continue;
            }
            catch (Exception e) {
                throw new AssertionFailure("Can't create symbols to represent dice rolls", e);
            }
        }
        int[] advance = new int[]{1};
        try {
            fairD = DistributionFactory.DEFAULT.createDistribution(diceAlphabet);
            loadedD = DistributionFactory.DEFAULT.createDistribution(diceAlphabet);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't create distributions", e);
        }
        SimpleEmissionState fairS = new SimpleEmissionState("fair", Annotation.EMPTY_ANNOTATION, advance, fairD);
        SimpleEmissionState loadedS = new SimpleEmissionState("loaded", Annotation.EMPTY_ANNOTATION, advance, loadedD);
        SimpleMarkovModel casino = new SimpleMarkovModel(1, diceAlphabet, "Casino");
        try {
            casino.addState(fairS);
            casino.addState(loadedS);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't add states to model", e);
        }
        try {
            casino.createTransition(casino.magicalState(), fairS);
            casino.createTransition(casino.magicalState(), loadedS);
            casino.createTransition(fairS, casino.magicalState());
            casino.createTransition(loadedS, casino.magicalState());
            casino.createTransition(fairS, loadedS);
            casino.createTransition(loadedS, fairS);
            casino.createTransition(fairS, fairS);
            casino.createTransition(loadedS, loadedS);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't create transitions", e);
        }
        try {
            for (int i = 0; i < rolls.length; ++i) {
                fairD.setWeight(rolls[i], 0.16666666666666666);
                loadedD.setWeight(rolls[i], 0.1);
            }
            loadedD.setWeight(rolls[5], 0.5);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't set emission probabilities", e);
        }
        try {
            Distribution dist = casino.getWeights(casino.magicalState());
            dist.setWeight(fairS, 0.8);
            dist.setWeight(loadedS, 0.2);
            dist = casino.getWeights(fairS);
            dist.setWeight(loadedS, 0.04);
            dist.setWeight(fairS, 0.95);
            dist.setWeight(casino.magicalState(), 0.01);
            dist = casino.getWeights(loadedS);
            dist.setWeight(fairS, 0.09);
            dist.setWeight(loadedS, 0.9);
            dist.setWeight(casino.magicalState(), 0.01);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't set transition probabilities", e);
        }
        return casino;
    }
}

