/*
 * Decompiled with CFR 0.152.
 */
package dp;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.GapDistribution;
import org.biojava.bio.dist.PairDistribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleDotState;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.dp.twohead.DPCompiler;
import org.biojava.bio.dp.twohead.DPInterpreter;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SymbolList;

public class PairwiseAlignment {
    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                throw new Exception("Use: PairwiseAlignment i|c sourceSeqFile targetSeqFile\ni for interpreter (classic), c for run-time compiled (experimental)");
            }
            String ic = args[0];
            File sourceSeqFile = new File(args[1]);
            File targetSeqFile = new File(args[2]);
            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            CellCalculatorFactoryMaker cfFactM = ic.equals("i") ? new DPInterpreter.Maker() : new DPCompiler(true);
            DPFactory.DefaultFactory fact = new DPFactory.DefaultFactory(cfFactM);
            MarkovModel model = PairwiseAlignment.generateAligner(alpha, 0.5, 0.8, 0.2, 0.8);
            DP aligner = fact.createDP(model);
            SymbolTokenization rParser = alpha.getTokenization("token");
            FastaDescriptionLineParser.Factory sFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            FastaFormat sFormat = new FastaFormat();
            FileInputStream sourceIS = new FileInputStream(sourceSeqFile);
            StreamReader sourceI = new StreamReader(sourceIS, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sFact);
            while (sourceI.hasNext()) {
                Sequence sourceSeq = sourceI.nextSequence();
                FileInputStream targetIS = new FileInputStream(targetSeqFile);
                StreamReader targetI = new StreamReader(targetIS, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sFact);
                while (targetI.hasNext()) {
                    Sequence targetSeq = targetI.nextSequence();
                    SymbolList[] seqs = new Sequence[]{sourceSeq, targetSeq};
                    System.out.println("Aligning " + sourceSeq.getName() + ":" + targetSeq.getName());
                    System.out.println("Forwards-:");
                    double forwardMin = aligner.forward(seqs, ScoreType.PROBABILITY);
                    System.out.println("\t" + forwardMin);
                    forwardMin = aligner.forward(seqs, ScoreType.ODDS);
                    System.out.println("\t" + forwardMin);
                    forwardMin = aligner.forward(seqs, ScoreType.NULL_MODEL);
                    System.out.println("\t" + forwardMin);
                    System.out.println("Backwards:");
                    double backward = aligner.backward(seqs, ScoreType.PROBABILITY);
                    System.out.println("\t" + backward);
                    backward = aligner.backward(seqs, ScoreType.ODDS);
                    System.out.println("\t" + backward);
                    backward = aligner.backward(seqs, ScoreType.NULL_MODEL);
                    System.out.println("\t" + backward);
                    System.out.println("Viterbi:");
                    StatePath result = aligner.viterbi(seqs, ScoreType.PROBABILITY);
                    System.out.println("\t" + result.getScore());
                    result = aligner.viterbi(seqs, ScoreType.ODDS);
                    System.out.println("\t" + result.getScore());
                    result = aligner.viterbi(seqs, ScoreType.NULL_MODEL);
                    System.out.println("\t" + result.getScore());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static MarkovModel generateAligner(FiniteAlphabet alpha, double pMatch, double pExtendMatch, double pGap, double pExtendGap) throws Exception {
        double pEndMatch = 1.0 - pExtendMatch;
        double pEndGap = 1.0 - pExtendGap;
        double pEnd = 1.0 - pMatch - 2.0 * pGap;
        FiniteAlphabet dna = alpha;
        FiniteAlphabet dna2 = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(Collections.nCopies(2, dna));
        SimpleMarkovModel model = new SimpleMarkovModel(2, dna2, "pair-wise aligner");
        UniformDistribution nullModel = new UniformDistribution(dna);
        GapDistribution gap = new GapDistribution(dna);
        Distribution matchDist = PairwiseAlignment.generateMatchDist(dna2);
        PairDistribution nullModel2 = new PairDistribution(nullModel, nullModel);
        PairDistribution insert1Dist = new PairDistribution(nullModel, gap);
        PairDistribution insert2Dist = new PairDistribution(gap, nullModel);
        SimpleDotState hub = new SimpleDotState("hub");
        SimpleEmissionState match = new SimpleEmissionState("match", Annotation.EMPTY_ANNOTATION, new int[]{1, 1}, matchDist);
        SimpleEmissionState insert1 = new SimpleEmissionState("insert1", Annotation.EMPTY_ANNOTATION, new int[]{1, 0}, insert1Dist);
        SimpleEmissionState insert2 = new SimpleEmissionState("insert2", Annotation.EMPTY_ANNOTATION, new int[]{0, 1}, insert2Dist);
        model.addState(hub);
        model.addState(match);
        model.addState(insert1);
        model.addState(insert2);
        model.createTransition(model.magicalState(), hub);
        model.createTransition(hub, match);
        model.createTransition(hub, insert1);
        model.createTransition(hub, insert2);
        model.createTransition(hub, model.magicalState());
        model.createTransition(match, match);
        model.createTransition(match, hub);
        model.createTransition(insert1, insert1);
        model.createTransition(insert1, hub);
        model.createTransition(insert2, insert2);
        model.createTransition(insert2, hub);
        model.getWeights(model.magicalState()).setWeight(hub, 1.0);
        Distribution dist = model.getWeights(hub);
        dist.setWeight(match, pMatch);
        dist.setWeight(insert1, pGap);
        dist.setWeight(insert2, pGap);
        dist.setWeight(model.magicalState(), pEnd);
        dist = model.getWeights(match);
        dist.setWeight(match, pExtendMatch);
        dist.setWeight(hub, pEndMatch);
        dist = model.getWeights(insert1);
        dist.setWeight(insert1, pExtendGap);
        dist.setWeight(hub, pEndGap);
        dist = model.getWeights(insert2);
        dist.setWeight(insert2, pExtendGap);
        dist.setWeight(hub, pEndGap);
        return model;
    }

    private static Distribution generateMatchDist(FiniteAlphabet dna2) throws Exception {
        Distribution dist = DistributionFactory.DEFAULT.createDistribution(dna2);
        int size = dna2.size();
        int matches = (int)Math.sqrt(size);
        double pMatch = 0.15;
        double matchWeight = pMatch / (double)matches;
        double missWeigth = (1.0 - pMatch) / (double)(size - matches);
        Iterator i = dna2.iterator();
        while (i.hasNext()) {
            BasisSymbol cps = (BasisSymbol)i.next();
            List sl = cps.getSymbols();
            if (sl.get(0) == sl.get(1)) {
                dist.setWeight(cps, matchWeight);
                continue;
            }
            dist.setWeight(cps, missWeigth);
        }
        return dist;
    }
}

