/*
 * Decompiled with CFR 0.152.
 */
package dp;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.BaumWelchTrainer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ProfileHMM;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleModelTrainer;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.StoppingCriteria;
import org.biojava.bio.dp.TrainingAlgorithm;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SearchProfile {
    public static Distribution nullModel;

    public static void main(String[] args) {
        try {
            File seqFile = new File(args[0]);
            FiniteAlphabet PROTEIN = ProteinTools.getAlphabet();
            nullModel = new UniformDistribution(PROTEIN);
            System.out.println("Loading sequences");
            SequenceDB seqDB = SearchProfile.readSequenceDB(seqFile, PROTEIN);
            System.out.println("Creating profile HMM");
            ProfileHMM profile = SearchProfile.createProfile(seqDB, PROTEIN);
            System.out.println("make dp object");
            DP dp = DPFactory.DEFAULT.createDP(profile);
            SearchProfile.dumpDP(dp);
            SymbolList[] seq1 = new Sequence[]{seqDB.sequenceIterator().nextSequence()};
            System.out.println("Viterbi: " + dp.viterbi(seq1, ScoreType.PROBABILITY).getScore());
            System.out.println("Forward: " + dp.forward(seq1, ScoreType.PROBABILITY));
            System.out.println("Backward: " + dp.backward(seq1, ScoreType.PROBABILITY));
            System.out.println("Training whole profile");
            BaumWelchTrainer ta = new BaumWelchTrainer(dp);
            ta.train(seqDB, 5.0, new StoppingCriteria(){

                public boolean isTrainingComplete(TrainingAlgorithm ta) {
                    System.out.println("Cycle " + ta.getCycle() + " completed");
                    System.out.println("Score: " + ta.getCurrentScore());
                    return ta.getCycle() >= 5;
                }
            });
            System.out.println("Alignining sequences to the model");
            SequenceIterator si = seqDB.sequenceIterator();
            while (si.hasNext()) {
                Sequence seq = si.nextSequence();
                SymbolList[] rl = new SymbolList[]{seq};
                StatePath statePath = dp.viterbi(rl, ScoreType.PROBABILITY);
                double fScore = dp.forward(rl, ScoreType.PROBABILITY);
                double bScore = dp.backward(rl, ScoreType.PROBABILITY);
                System.out.println(seq.getName() + " viterbi: " + statePath.getScore() + ", forwards: " + fScore + ", backwards: " + bScore);
                SymbolTokenization token = ProteinTools.getAlphabet().getTokenization("token");
                for (int i = 0; i <= statePath.length() / 60; ++i) {
                    int j;
                    for (j = i * 60; j < Math.min((i + 1) * 60, statePath.length()); ++j) {
                        System.out.print(token.tokenizeSymbol(statePath.symbolAt(StatePath.SEQUENCE, j + 1)));
                    }
                    System.out.print("\n");
                    for (j = i * 60; j < Math.min((i + 1) * 60, statePath.length()); ++j) {
                        System.out.print(statePath.symbolAt(StatePath.STATES, j + 1).getName().charAt(0));
                    }
                    System.out.print("\n");
                    System.out.print("\n");
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static ProfileHMM createProfile(SequenceDB seqs, Alphabet alpha) throws Exception {
        double l = 0.0;
        SequenceIterator i = seqs.sequenceIterator();
        while (i.hasNext()) {
            l += Math.log(i.nextSequence().length());
        }
        int length = (int)Math.exp(l /= (double)seqs.ids().size());
        System.out.println("Estimating alignment as having length " + length);
        ProfileHMM profile = new ProfileHMM(alpha, length, DistributionFactory.DEFAULT, DistributionFactory.DEFAULT);
        SearchProfile.randomize(profile);
        return profile;
    }

    public static SequenceDB readSequenceDB(File seqFile, Alphabet alpha) throws Exception {
        HashSequenceDB seqDB = new HashSequenceDB(IDMaker.byName);
        FastaDescriptionLineParser.Factory sbFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        FastaFormat fFormat = new FastaFormat();
        Object stateI = null;
        StreamReader seqI = new StreamReader(new FileInputStream(seqFile), (SequenceFormat)fFormat, alpha.getTokenization("token"), (SequenceBuilderFactory)sbFact);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            seqDB.addSequence(seq);
        }
        return seqDB;
    }

    private static void randomize(MarkovModel model) throws Exception {
        SimpleModelTrainer mt = new SimpleModelTrainer();
        mt.registerModel(model);
        mt.setNullModelWeight(5.0);
        Iterator i = model.stateAlphabet().iterator();
        while (i.hasNext()) {
            State s = (State)i.next();
            if (s instanceof EmissionState && !(s instanceof MagicalState)) {
                EmissionState es = (EmissionState)s;
                Distribution dis = es.getDistribution();
                FiniteAlphabet fa = (FiniteAlphabet)dis.getAlphabet();
                Iterator j = fa.iterator();
                while (j.hasNext()) {
                    Symbol r = (Symbol)j.next();
                    mt.addCount(es.getDistribution(), r, Math.random());
                }
            }
            Distribution dist = model.getWeights(s);
            Iterator j = model.transitionsFrom(s).iterator();
            while (j.hasNext()) {
                State t = (State)j.next();
                mt.addCount(dist, t, Math.random());
            }
        }
        mt.train();
        mt.clearCounts();
    }

    private static void dumpDP(DP dp) {
        State[] states = dp.getStates();
        System.out.print("states: ");
        for (int i = 0; i < states.length; ++i) {
            System.out.print(" " + states[i].getName());
        }
        System.out.println("\n");
        int[][] forwardT = dp.getForwardTransitions();
        double[][] forwardTS = dp.getForwardTransitionScores(ScoreType.ODDS);
        for (int i = 0; i < states.length; ++i) {
            System.out.print("Transitions from " + i + ": ");
            for (int j = 0; j < forwardT[i].length; ++j) {
                System.out.print(" " + forwardT[i][j] + "(" + forwardTS[i][j] + ")");
            }
        }
    }

    static void Print(SymbolList v) {
        Iterator it = v.iterator();
        while (it.hasNext()) {
            Symbol sym = (Symbol)it.next();
            System.out.print(sym.getName() + " ");
        }
        System.out.println();
    }
}

