/*
 * Decompiled with CFR 0.152.
 */
package eventbasedparsing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Properties;
import org.biojava.bio.program.blast2html.AlignmentMarker;
import org.biojava.bio.program.blast2html.Blast2HTMLHandler;
import org.biojava.bio.program.blast2html.ColourCommand;
import org.biojava.bio.program.blast2html.DefaultURLGeneratorFactory;
import org.biojava.bio.program.blast2html.HTMLRenderer;
import org.biojava.bio.program.blast2html.SimpleAlignmentStyler;
import org.biojava.bio.program.sax.BlastLikeSAXParser;
import org.xml.sax.InputSource;

public class Blast2HTML {
    private static String oStyleDefinition = ".footer { font-family: Arial, Helvetica, sans-serif; font-size: 12px; font-style: italic; font-weight: normal ; color: #CC0000}\n.alignment {  font-family: \"Courier New\", Courier, mono; font-size: 14px;}\n.dbRetrieve {  font-family: Arial, Helvetica, sans-serif; font-size: 14px; font-style: normal; font-weight: bold; color: #000000; line-height: normal}\n.titleLevel1 { font-family: Arial, Helvetica, sans-serif; font-size: 30px; font-style: normal; font-weight: bold; color: #000000 ; background-color: #CCCCFF; line-height: normal}\n.titleLevel1Sub { font-family: Arial, Helvetica, sans-serif; font-size: 18px; font-style: normal; font-weight: bold; color: #000000 ; background-color: #CCCCFF; line-height: normal}\n.titleLevel2 { font-family: Arial, Helvetica, sans-serif; font-size: 18px; font-style: normal; font-weight: bold; color: #000000 ; background-color: #99FFCC; line-height: normal}\n.titleLevel3 { font-family: Arial, Helvetica, sans-serif; font-size: 16px; font-style: normal; font-weight: bold; color: #000000 ; background-color: #FFFFCC; line-height: normal; }\n.titleLevel3Sub { font-family: Arial, Helvetica, sans-serif; font-size: 12px; font-style: normal; font-weight: bold; color: #000000 ; background-color: #FFFFCC; line-height: normal}\n.summaryBodyLineOdd { font-family: Arial, Helvetica, sans-serif; font-size: 12px; font-style: normal; font-weight: normal; color: #000000 ; clip: rect( ); line-height: normal; text-indent: 0pt; padding-top: 0px; padding-right: 0px; padding-bottom: 0px; padding-left: 0px; margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px }\n.summaryBodyLineEven { font-family: Arial, Helvetica, sans-serif; font-size: 12px; font-style: normal; font-weight: normal; color: #000000 ; background-color: #EEEEEE; line-height: normal }\n.titleLevel4 { font-family: Arial, Helvetica, sans-serif; font-size: 14px; font-style: normal; font-weight: bold; color: #000000 ; background-color: #FFFFEE; line-height: normal }\nbody {  font-family: Arial, Helvetica, sans-serif; font-size: 10px}\ntd {  font-family: Arial, Helvetica, sans-serif; font-size: 16px}\na {  text-decoration: none}\n";

    public static HTMLRenderer configureRenderer(String poType, PrintWriter poOut) {
        if (poType.equals("nucleic")) {
            return Blast2HTML.configureBlastN(poOut);
        }
        return Blast2HTML.configureBlastP(poOut);
    }

    public static HTMLRenderer configureBlastN(PrintWriter poOut) {
        SimpleAlignmentStyler oStyler = new SimpleAlignmentStyler(SimpleAlignmentStyler.SHOW_ALL);
        String oRed = "FFA2A2";
        oStyler.addStyle("-", oRed);
        oStyler.addStyle("N", oRed);
        oStyler.addStyle("A", oRed);
        oStyler.addStyle("T", oRed);
        oStyler.addStyle("C", oRed);
        oStyler.addStyle("G", oRed);
        AlignmentMarker oAlignmentMarker = new AlignmentMarker(new ColourCommand(){

            public boolean isColoured(String poFirst, String poSecond) {
                return !poFirst.equals(poSecond);
            }
        }, oStyler);
        Properties oProps = new Properties();
        oProps.put("db", "nucl");
        HTMLRenderer oRenderer = new HTMLRenderer(poOut, oStyleDefinition, 50, new DefaultURLGeneratorFactory(), oAlignmentMarker, oProps);
        return oRenderer;
    }

    public static HTMLRenderer configureBlastP(PrintWriter poOut) {
        SimpleAlignmentStyler oStyler = new SimpleAlignmentStyler(SimpleAlignmentStyler.SHOW_SAME);
        oStyler.addStyle("A", "C8FFC8");
        oStyler.addStyle("C", "C8FFC8");
        oStyler.addStyle("L", "C8FFC8");
        oStyler.addStyle("I", "C8FFC8");
        oStyler.addStyle("V", "C8FFC8");
        oStyler.addStyle("M", "C8FFC8");
        oStyler.addStyle("G", "DCC0FF");
        oStyler.addStyle("P", "DCC0FF");
        oStyler.addStyle("S", "FFFCA0");
        oStyler.addStyle("T", "FFFCA0");
        oStyler.addStyle("N", "FFFCA0");
        oStyler.addStyle("Q", "FFFCA0");
        oStyler.addStyle("K", "FFA2A2");
        oStyler.addStyle("R", "FFA2A2");
        oStyler.addStyle("D", "A2E2FF");
        oStyler.addStyle("E", "A2E2FF");
        oStyler.addStyle("H", "50FF50");
        oStyler.addStyle("Y", "50FF50");
        oStyler.addStyle("W", "50FF50");
        oStyler.addStyle("F", "50FF50");
        AlignmentMarker oAlignmentMarker = new AlignmentMarker(new ColourCommand(){

            public boolean isColoured(String poFirst, String poSecond) {
                return !poFirst.equals(poSecond);
            }
        }, oStyler);
        Properties oProps = new Properties();
        oProps.put("db", "Protein");
        HTMLRenderer oRenderer = new HTMLRenderer(poOut, oStyleDefinition, 50, new DefaultURLGeneratorFactory(), oAlignmentMarker, oProps);
        return oRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String oInput = null;
        Object oMode = null;
        boolean tStrict = true;
        if (args.length < 2 || args[0].equals("-help") || args[0].equals("-h")) {
            System.err.println();
            System.err.println("Usage: java eventbasedparsing.Blast2HTML <nucleic/protein> <pathname> <Output filename>\n");
            System.err.println("For Example - ");
            System.err.println("java eventbasedparsing.Blast2HTML protein files/ncbiblast/blastp.out");
            System.err.println();
            System.exit(1);
        }
        PrintWriter oOut = null;
        if (args.length == 3) {
            File oFile = new File(args[2]);
            if (oFile.exists()) {
                System.err.println(args[2] + " file already exists");
                System.exit(1);
            }
            oOut = new PrintWriter(new FileWriter(oFile));
        } else {
            oOut = new PrintWriter(System.out);
        }
        HTMLRenderer oRenderer = null;
        if (args[0].equals("protein") || args[0].equals("nucleic")) {
            oRenderer = Blast2HTML.configureRenderer(args[0], oOut);
        } else {
            System.err.println("Only \"protein\" or \"nucleic\" allowed");
            System.exit(1);
        }
        oInput = args[1];
        BlastLikeSAXParser oParser = new BlastLikeSAXParser();
        oParser.setModeLazy();
        Blast2HTMLHandler oHandler = new Blast2HTMLHandler(oRenderer);
        oParser.setContentHandler(oHandler);
        try {
            FileInputStream oInputFileStream = new FileInputStream(oInput);
            oOut.println("<HTML>\n<HEAD>");
            oOut.println(oRenderer.getHeaderDefinitions());
            oOut.println("</HEAD>");
            oOut.println("<body bgcolor=\"#FFFFFF\" alink=\"#33FFFF\" vlink=\"#CCCC99\">");
            oParser.parse(new InputSource(oInputFileStream));
            oOut.println("</BODY>\n</HTML>");
        }
        catch (FileNotFoundException x) {
            System.out.println(x.getMessage());
            System.out.println("Couldn't open file");
            System.exit(0);
        }
        finally {
            oOut.flush();
            oOut.close();
        }
    }
}

