/*
 * Decompiled with CFR 0.152.
 */
package gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SequencesAsGFF;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;

public class EmblToGffFasta {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new Exception("Use: EmblToGffFasta emblFile fastaOut gffOut");
        }
        try {
            File emblFile = new File(args[0]);
            File fastaFile = new File(args[1]);
            File gffFile = new File(args[2]);
            EmblLikeFormat eFormat = new EmblLikeFormat();
            BufferedReader eReader = new BufferedReader(new InputStreamReader(new FileInputStream(emblFile)));
            EmblProcessor.Factory sFact = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            FiniteAlphabet alpha = DNATools.getDNA();
            SymbolTokenization rParser = alpha.getTokenization("token");
            FastaFormat fFormat = new FastaFormat();
            FileOutputStream fastaOut = new FileOutputStream(fastaFile);
            GFFWriter writer = new GFFWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(gffFile))));
            SequencesAsGFF seqsAsGFF = new SequencesAsGFF();
            StreamReader seqI = new StreamReader(eReader, (SequenceFormat)eFormat, rParser, (SequenceBuilderFactory)sFact);
            while (seqI.hasNext()) {
                String de;
                Sequence seq = seqI.nextSequence();
                Object desc = seq.getAnnotation().getProperty("DE");
                if (desc instanceof String) {
                    de = (String)desc;
                } else {
                    de = null;
                    Iterator i = ((Collection)desc).iterator();
                    while (i.hasNext()) {
                        if (de == null) {
                            de = i.next().toString();
                            continue;
                        }
                        de = de + " " + i.next().toString();
                    }
                }
                seq.getAnnotation().setProperty("description_line", de);
                fFormat.writeSequence(seq, new PrintStream(fastaOut));
                seqsAsGFF.processSequence(seq, writer);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

