/*
 * Decompiled with CFR 0.152.
 */
package gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFFilterer;
import org.biojava.bio.program.gff.GFFParser;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.seq.StrandParser;

public class GFFCompare {
    public static void main(String[] args) throws Exception {
        Map options = GFFCompare.parseArgs(args);
        if (args.length == 0 || options == null || options.containsKey("help")) {
            throw new Exception("Use: GFFToFeatures [options]\n    --infile in    read gff from file named in (stdin if absent or -)\n    --outfile out  write gff to file named out (stdout if absent or -)\n    --source [!]s  source==s or source!=s\n    --feature [!]f feature==f or feature!=f\n    --seq [!]s     sequence==s or sequence!=s\n    --frame [!]f   frame==f or frame!=f where f is one of 0, 1, 2\n    --strand [!]s  strand==s or strand!=s where s is one of ., +, -\n    --start [<>]x  start==x or start<x or start>x\n    --end [<>]y    end==y or end<y or end>y\n    --help         this help message\n");
        }
        PrintWriter out = null;
        String outFileName = (String)options.get("outfile");
        out = outFileName == null || outFileName.equals("-") ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new FileWriter(new File(outFileName)));
        GFFDocumentHandler handler = new GFFWriter(out);
        Iterator ki = options.keySet().iterator();
        while (ki.hasNext()) {
            Object key = ki.next();
            handler = GFFCompare.processOpt((String)key, (String)options.get(key), handler);
        }
        BufferedReader in = null;
        String inFileName = (String)options.get("infile");
        in = inFileName == null || inFileName.equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inFileName)));
        GFFParser parser = new GFFParser();
        parser.parse(in, handler);
    }

    private static Map parseArgs(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            String key = args[i];
            String val = args[i + 1];
            while (key.startsWith("-")) {
                key = key.substring(1);
            }
            options.put(key, val);
        }
        return options;
    }

    private static GFFDocumentHandler processOpt(String key, String val, GFFDocumentHandler handler) {
        boolean negate = false;
        GFFRecordFilter filter = null;
        if (val.startsWith("!")) {
            negate = true;
            val = val.substring(1);
        }
        if (key.equals("end")) {
            boolean before = false;
            boolean after = false;
            if (val.startsWith("<")) {
                before = true;
                val = val.substring(1);
            }
            if (val.startsWith(">")) {
                after = true;
                val = val.substring(1);
            }
            int pos = Integer.parseInt(val);
            filter = new EndFilter(pos, before, after);
        } else if (key.equals("start")) {
            boolean before = false;
            boolean after = false;
            if (val.startsWith("<")) {
                before = true;
                val = val.substring(1);
            }
            if (val.startsWith(">")) {
                after = true;
                val = val.substring(1);
            }
            int pos = Integer.parseInt(val);
            filter = new StartFilter(pos, before, after);
        } else if (key.equals("strand")) {
            filter = new GFFRecordFilter.StrandFilter(StrandParser.parseStrand(val));
        } else if (key.equals("frame")) {
            filter = new GFFRecordFilter.FrameFilter(Integer.parseInt(val));
        } else if (key.equals("source")) {
            filter = new GFFRecordFilter.SourceFilter(val);
        } else if (key.equals("feature")) {
            filter = new GFFRecordFilter.FeatureFilter(val);
        } else if (key.equals("seq")) {
            filter = new GFFRecordFilter.SequenceFilter(val);
        } else {
            return handler;
        }
        if (negate) {
            filter = new GFFRecordFilter.NotFilter(filter);
        }
        return new GFFFilterer(handler, filter);
    }

    private static class EndFilter
    extends SE {
        EndFilter(int pos, boolean before, boolean after) {
            super(pos, before, after);
        }

        protected int getCoordinate(GFFRecord record) {
            return record.getEnd();
        }
    }

    private static class StartFilter
    extends SE {
        StartFilter(int pos, boolean before, boolean after) {
            super(pos, before, after);
        }

        protected int getCoordinate(GFFRecord record) {
            return record.getStart();
        }
    }

    private static abstract class SE
    implements GFFRecordFilter {
        private int pos;
        private boolean before;
        private boolean after;

        protected SE(int pos, boolean before, boolean after) {
            this.pos = pos;
            this.before = before;
            this.after = after;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean isBefore() {
            return this.before;
        }

        public boolean isAfter() {
            return this.after;
        }

        public boolean accept(GFFRecord record) {
            int co = this.getCoordinate(record);
            return this.before && co < this.pos || this.after && co > this.pos || co == this.pos;
        }

        protected abstract int getCoordinate(GFFRecord var1);
    }
}

