/*
 * Decompiled with CFR 0.152.
 */
package gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFFilterer;
import org.biojava.bio.program.gff.GFFParser;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;

public class GFFMask {
    public static void main(String[] args) throws Exception {
        Map options = GFFMask.parseArgs(args);
        if (args.length == 0 || options == null || options.containsKey("help")) {
            throw new Exception("Use: GFFToFeatures [options]\n    --infile in            read gff from file named in (stdin if absent or -)\n    --outfile out          write gff to file named out (stdout if absent or -)\n    --maskfile mask        read the masking gff from file named mask (stdin if absent or -)\n    --mode contain|overlap features should either be totaly contained within or overlap the mask\n    --hits accept|reject   features hitting the mask will be accepted or rejected\n    --use_seq_names y|n    mask hits should count only if seq names match if y\n");
        }
        PrintWriter out = null;
        String outFileName = (String)options.get("outfile");
        out = outFileName == null || outFileName.equals("-") ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new FileWriter(new File(outFileName)));
        GFFDocumentHandler handler = new GFFWriter(out);
        BufferedReader in = null;
        String inFileName = (String)options.get("infile");
        in = inFileName == null || inFileName.equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inFileName)));
        BufferedReader maskIn = null;
        String maskInFileName = (String)options.get("maskfile");
        maskIn = maskInFileName == null || maskInFileName.equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(maskInFileName)));
        GFFParser parser = new GFFParser();
        Mask mask = GFFMask.makeMask(options, parser, maskIn);
        handler = GFFMask.makeHandler(options, mask, handler);
        parser.parse(in, handler);
    }

    private static Map parseArgs(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            String key = args[i];
            String val = args[i + 1];
            while (key.startsWith("-")) {
                key = key.substring(1);
            }
            options.put(key, val);
        }
        return options;
    }

    private static Mask makeMask(Map options, GFFParser parser, BufferedReader maskIn) throws Exception {
        MaskBuilder mb = null;
        String use_seq_names = (String)options.get("use_seq_names");
        mb = use_seq_names == null || use_seq_names.equals("y") ? new MaskBuilderY() : new MaskBuilderN();
        parser.parse(maskIn, mb);
        return mb.getMask();
    }

    private static GFFDocumentHandler makeHandler(Map options, final Mask mask, GFFDocumentHandler handler) {
        boolean negate;
        String hits = (String)options.get("hits");
        if (hits != null && hits.equals("reject")) {
            negate = true;
        } else if (hits == null || hits.equals("accept")) {
            negate = false;
        } else {
            throw new IllegalArgumentException("Unknown hits option: " + hits + " try (accept|reject)");
        }
        String mode = (String)options.get("mode");
        GFFRecordFilter filter = null;
        if (mode == null || mode.equals("contain")) {
            filter = new GFFRecordFilter(){

                public boolean accept(GFFRecord rec) {
                    Location loc = mask.getLocation(rec);
                    return loc != null && loc.contains(new RangeLocation(rec.getStart(), rec.getEnd()));
                }
            };
        } else if (mode != null && mode.equals("overlap")) {
            filter = new GFFRecordFilter(){

                public boolean accept(GFFRecord rec) {
                    Location loc = mask.getLocation(rec);
                    return loc != null && loc.overlaps(new RangeLocation(rec.getStart(), rec.getEnd()));
                }
            };
        } else {
            throw new IllegalArgumentException("Unknown mode option: " + mode + " try (contain|overlap)");
        }
        if (negate) {
            filter = new GFFRecordFilter.NotFilter(filter);
        }
        return new GFFFilterer(handler, filter);
    }

    private static interface Mask {
        public Location getLocation(GFFRecord var1);
    }

    private static class MaskBuilderN
    extends MaskBuilder {
        Location loc = null;

        private MaskBuilderN() {
        }

        public void recordLine(GFFRecord rec) {
            RangeLocation range = new RangeLocation(rec.getStart(), rec.getEnd());
            this.loc = this.loc == null ? range : LocationTools.union(this.loc, range);
        }

        protected Mask getMask() {
            return new Mask(){

                public Location getLocation(GFFRecord rec) {
                    return MaskBuilderN.this.loc;
                }
            };
        }
    }

    private static class MaskBuilderY
    extends MaskBuilder {
        private Map negSeq2Loc = new HashMap();
        private Map posSeq2Loc = new HashMap();

        private MaskBuilderY() {
        }

        public void recordLine(GFFRecord rec) {
            StrandedFeature.Strand strand = rec.getStrand();
            if (strand == StrandedFeature.POSITIVE || strand == StrandedFeature.UNKNOWN) {
                this.processRec(this.posSeq2Loc, rec);
            }
            if (strand == StrandedFeature.NEGATIVE || strand == StrandedFeature.UNKNOWN) {
                this.processRec(this.negSeq2Loc, rec);
            }
        }

        private void processRec(Map hits, GFFRecord rec) {
            Location loc = (Location)hits.get(rec.getSeqName());
            RangeLocation range = new RangeLocation(rec.getStart(), rec.getEnd());
            loc = loc == null ? range : LocationTools.union(loc, range);
            hits.put(rec.getSeqName(), loc);
        }

        protected Mask getMask() {
            return new Mask(){

                public Location getLocation(GFFRecord rec) {
                    StrandedFeature.Strand s = rec.getStrand();
                    Map m = s == StrandedFeature.POSITIVE || s == StrandedFeature.UNKNOWN ? MaskBuilderY.this.posSeq2Loc : MaskBuilderY.this.negSeq2Loc;
                    return (Location)m.get(rec.getSeqName());
                }
            };
        }
    }

    private static abstract class MaskBuilder
    implements GFFDocumentHandler {
        private MaskBuilder() {
        }

        public void commentLine(String comment) {
        }

        public void endDocument() {
        }

        public void startDocument(String locator) {
        }

        protected abstract Mask getMask();
    }
}

