/*
 * Decompiled with CFR 0.152.
 */
package gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SequencesAsGFF;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;

public class GenbankToGffFasta {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new Exception("Use: GenbankToGffFasta genbankFile fastaOut gffOut");
        }
        try {
            File genbankFile = new File(args[0]);
            File fastaFile = new File(args[1]);
            File gffFile = new File(args[2]);
            GenbankFormat gFormat = new GenbankFormat();
            BufferedReader gReader = new BufferedReader(new InputStreamReader(new FileInputStream(genbankFile)));
            GenbankProcessor.Factory sFact = new GenbankProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            FiniteAlphabet alpha = DNATools.getDNA();
            SymbolTokenization rParser = alpha.getTokenization("token");
            FastaFormat fFormat = new FastaFormat();
            FileOutputStream fastaOut = new FileOutputStream(fastaFile);
            GFFWriter writer = new GFFWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(gffFile))));
            SequencesAsGFF seqsAsGFF = new SequencesAsGFF();
            StreamReader seqI = new StreamReader(gReader, (SequenceFormat)gFormat, rParser, (SequenceBuilderFactory)sFact);
            while (seqI.hasNext()) {
                Sequence seq = seqI.nextSequence();
                fFormat.writeSequence(seq, new PrintStream(fastaOut));
                seqsAsGFF.processSequence(seq, writer);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

