/*
 * Decompiled with CFR 0.152.
 */
package gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SequencesAsGFF;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;

public class SwissprotToGffFasta {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new Exception("Use: SwissprotToGffFasta swissprotFile fastaOut gffOut");
        }
        try {
            File swissprotFile = new File(args[0]);
            File fastaFile = new File(args[1]);
            File gffFile = new File(args[2]);
            EmblLikeFormat sFormat = new EmblLikeFormat();
            BufferedReader sReader = new BufferedReader(new InputStreamReader(new FileInputStream(swissprotFile)));
            SwissprotProcessor.Factory sFact = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            SymbolTokenization rParser = alpha.getTokenization("token");
            FastaFormat fFormat = new FastaFormat();
            FileOutputStream fastaOut = new FileOutputStream(fastaFile);
            GFFWriter writer = new GFFWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(gffFile))));
            SequencesAsGFF seqsAsGFF = new SequencesAsGFF();
            StreamReader seqI = new StreamReader(sReader, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sFact);
            while (seqI.hasNext()) {
                Sequence seq = seqI.nextSequence();
                fFormat.writeSequence(seq, new PrintStream(fastaOut));
                seqsAsGFF.processSequence(seq, writer);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

