/*
 * Decompiled with CFR 0.152.
 */
package indexing;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.utils.io.CountedBufferedReader;
import org.biojava.utils.io.RAF;
import org.biojava.utils.lsid.LifeScienceIdentifier;

public class CreateFAIndex {
    private static final int ID_LENGTH = 40;

    public static void main(String[] args) throws Throwable {
        if (args.length < 3) {
            System.err.println("Use: indexdb.CreateFAIndex storeFile storeName [filesToINdex]");
            System.exit(1);
        }
        File storeFile = new File(args[0]);
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setPrimaryKey("ID");
        bsf.setStoreLocation(storeFile);
        bsf.addKey("ID", 40);
        bsf.setStoreName(args[1]);
        bsf.setSequenceFormat(LifeScienceIdentifier.valueOf("open-bio.org", "format", "fasta"));
        BioStore store = bsf.createBioStore();
        FastaFormat format = new FastaFormat();
        SymbolTokenization tok = ProteinTools.getAlphabet().getTokenization("token");
        for (int i = 2; i < args.length; ++i) {
            File faFile = new File(args[i]);
            RAF raf = new RAF(faFile, "r");
            Indexer indexer = new Indexer(raf, store);
            StreamReader sreader = new StreamReader(indexer.getReader(), (SequenceFormat)format, tok, (SequenceBuilderFactory)indexer);
            while (sreader.hasNext()) {
                sreader.nextSequence();
            }
        }
        store.commit();
    }

    private static class Indexer
    implements SequenceBuilderFactory {
        private final Map map = new HashMap();
        private final RAF raf;
        private final IndexStore store;
        private final CountedBufferedReader reader;

        public Indexer(RAF raf, IndexStore store) throws IOException {
            this.raf = raf;
            this.store = store;
            this.reader = new CountedBufferedReader(new FileReader(raf.getFile()));
        }

        public CountedBufferedReader getReader() {
            return this.reader;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SeqIOIndexer();
        }

        class SeqIOIndexer
        extends SeqIOAdapter
        implements SequenceBuilder {
            long offset = 0L;
            String id;

            SeqIOIndexer() {
            }

            public void startSequence() {
                this.id = null;
                this.offset = Indexer.this.reader.getFilePointer();
            }

            public void addSequenceProperty(Object key, Object value) {
                if (key.equals("description_line")) {
                    String line = (String)value;
                    int a = line.indexOf(" ");
                    this.id = a != -1 ? line.substring(0, a) : line;
                    if (this.id.length() > 40) {
                        System.err.println("ID too long: " + this.id.length() + " vs " + 40);
                        System.err.println("Got description: " + line);
                        System.err.println("ID: " + this.id);
                        System.err.println();
                    }
                }
            }

            public void endSequence() {
                long nof = Indexer.this.reader.getFilePointer();
                Indexer.this.store.writeRecord(Indexer.this.raf, this.offset, (int)(nof - this.offset), this.id, Indexer.this.map);
                this.offset = nof;
            }

            public Sequence makeSequence() {
                return null;
            }
        }
    }
}

