/*
 * Decompiled with CFR 0.152.
 */
package process;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.biojava.utils.ProcessTimeoutException;
import org.biojava.utils.ProcessTools;

public class ProcessToolsTest {
    public static void main(String[] args) throws Exception {
        ProcessToolsTest.testEcho();
        ProcessToolsTest.testWC();
        ProcessToolsTest.testTimebombDefused();
        ProcessToolsTest.testTimebombKilled();
    }

    private static void testEcho() throws Exception {
        StringWriter out = new StringWriter();
        ProcessTools.exec(new String[]{"/bin/echo", "Hello, world"}, null, (Writer)out, null);
        System.out.println("Output from echo test");
        System.out.print(((Object)out).toString());
        System.out.println();
    }

    private static void testWC() throws Exception {
        StringWriter out = new StringWriter();
        ProcessTools.exec(new String[]{"/usr/bin/wc", "-w"}, (Reader)new StringReader("The quick brown fox jumps over the lazy dog"), (Writer)out, null);
        int numWords = Integer.parseInt(((Object)out).toString().trim());
        System.out.println("Counted " + numWords + " words");
    }

    private static void testTimebombDefused() throws Exception {
        System.err.println("Test a process running normally under a timebomb");
        boolean killed = false;
        try {
            ProcessTools.exec(new String[]{"/bin/sleep", "5"}, (String[])null, (File)null, (Reader)null, (Writer)null, (Writer)null, 10000L);
        }
        catch (ProcessTimeoutException ex) {
            killed = true;
        }
        if (killed) {
            System.err.println("Got a timeout: BAD");
        } else {
            System.err.println("No timeout: GOOD");
        }
    }

    private static void testTimebombKilled() throws Exception {
        System.err.println("Test a process which should be killed by a timebomb");
        boolean killed = false;
        try {
            ProcessTools.exec(new String[]{"/bin/sleep", "15"}, null, null, null, null, null, 10000L);
        }
        catch (ProcessTimeoutException ex) {
            killed = true;
        }
        if (killed) {
            System.err.println("Got a timeout: GOOD");
        } else {
            System.err.println("No timeout: BAD");
        }
    }
}

