/*
 * Decompiled with CFR 0.152.
 */
package prot;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.Digest;
import org.biojava.bio.proteomics.MassCalc;
import org.biojava.bio.proteomics.Protease;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.utils.ChangeVetoException;

public class TestDigestIO {
    private MassCalc massCalc;
    NumberFormat nf = NumberFormat.getInstance();

    public TestDigestIO(String fileName, String mode) throws BioException, ChangeVetoException, IOException {
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        Digest bioJavaDigest = new Digest();
        bioJavaDigest.setMaxMissedCleavages(0);
        this.massCalc = new MassCalc("monoMass", true);
        try {
            this.massCalc.setSymbolModification('Z', 100000.0);
            double[] vMasses = new double[]{147.04049};
            this.massCalc.addVariableModification('M', vMasses);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        bioJavaDigest.setProtease(Protease.getProteaseByName("Trypsin"));
        SequenceIterator sourceI = this.getSeqIterator(fileName);
        long startTime = System.currentTimeMillis();
        while (sourceI.hasNext()) {
            Sequence sourceSeq = sourceI.nextSequence();
            bioJavaDigest.setSequence(sourceSeq);
            bioJavaDigest.addDigestFeatures();
            if (mode.equals("p")) {
                this.printFeatures(sourceSeq.features(), sourceSeq.getName() + " ");
                continue;
            }
            if (!mode.equals("m")) continue;
            this.calcMasses(sourceSeq.features(), sourceSeq.getName() + " ");
        }
        long endTime = System.currentTimeMillis();
        System.err.println("Total Time: " + (endTime - startTime));
        bioJavaDigest.setProtease(Protease.getProteaseByName("CNBr"));
        while (sourceI.hasNext()) {
            Sequence sourceSeq = sourceI.nextSequence();
            bioJavaDigest.setSequence(sourceSeq);
            bioJavaDigest.addDigestFeatures();
            if (mode.equals("p")) {
                this.printFeatures(sourceSeq.features(), sourceSeq.getName() + " ");
                continue;
            }
            if (!mode.equals("m")) continue;
            this.calcMasses(sourceSeq.features(), sourceSeq.getName() + " ");
        }
    }

    private void calcMasses(Iterator i, String prefix) {
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            try {
                double mass = this.massCalc.getMass(f.getSymbols());
                System.out.print(mass);
                System.out.println();
            }
            catch (Exception ise) {
                System.out.println(ise.getMessage());
            }
        }
    }

    private void printFeatures(Iterator it, String prefix) {
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            System.out.print(prefix);
            System.out.print(f.getType());
            System.out.print(f.getLocation().toString() + " ");
            try {
                double mass = this.massCalc.getMass(f.getSymbols());
                System.out.print(" PTM " + this.nf.format(mass) + " ");
                System.out.print(" " + f.getSymbols().seqString() + "    ");
                System.out.println();
                System.out.println("Now get Variable Masses ");
                double[] masses = this.massCalc.getVariableMasses(f.getSymbols());
                System.out.println("Got Variable masses " + masses.length);
                System.out.println(masses.length);
                for (int i = 0; i < masses.length; ++i) {
                    System.out.println("PTM" + i + ": " + masses[i]);
                }
            }
            catch (Exception ise) {
                System.out.println();
                System.out.println(ise);
                ise.printStackTrace();
            }
        }
    }

    private SequenceIterator getSeqIterator(String fileName) throws BioException {
        StreamReader it = null;
        try {
            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            SymbolTokenization protParser = alpha.getTokenization("token");
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            FastaDescriptionLineParser.Factory sFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            FastaFormat sFormat = new FastaFormat();
            it = new StreamReader(br, (SequenceFormat)sFormat, protParser, (SequenceBuilderFactory)sFact);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
        }
        return it;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            TestDigestIO.usage();
        }
        String fastaFile = args[0];
        String mode = "";
        if (!args[1].equals("-mode")) {
            TestDigestIO.usage();
        } else {
            mode = args[2];
        }
        try {
            new TestDigestIO(fastaFile, mode);
        }
        catch (BioException bioe) {
            bioe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ChangeVetoException cve) {
            cve.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: java prot.TestDigest <fastaFile> -mode [p|m|n]");
        System.out.println("mode p = print, m = get masses, n=just calculate features");
        System.exit(-1);
    }
}

