/*
 * Decompiled with CFR 0.152.
 */
package search;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IndexedSequenceDB;
import org.biojava.bio.seq.db.TabIndexStore;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;

public class IndexFastaDB {
    static final String USAGE = "\nUsage: java -Dtype=(aa|nt) [-Dname=<database name>] IndexFastaDB file(s)";
    static final String INDEX = ".index";
    static final String LIST = ".list";

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new Exception(USAGE);
        }
        Properties props = System.getProperties();
        String seqType = props.getProperty("type");
        if (seqType == null) {
            throw new Exception(USAGE);
        }
        if (!seqType.equalsIgnoreCase("aa") || !seqType.equalsIgnoreCase("nt")) {
            throw new Exception(USAGE);
        }
        FiniteAlphabet alpha = seqType.equalsIgnoreCase("aa") ? ProteinTools.getAlphabet() : DNATools.getDNA();
        String dbName = props.getProperty("name");
        FastaFormat seqFormat = new FastaFormat();
        IDMaker.ByName idMaker = new IDMaker.ByName();
        FastaDescriptionLineParser.Factory sbFactory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        try {
            SymbolTokenization parser = alpha.getTokenization("token");
            String fastaFileName = args[0];
            if (dbName == null) {
                dbName = fastaFileName;
            }
            File fastaFile = new File(fastaFileName);
            File indexFile = new File(dbName + INDEX);
            File indexList = new File(dbName + LIST);
            System.out.println("Creating database with name '" + dbName + "' from " + fastaFileName);
            TabIndexStore indexStore = new TabIndexStore(indexFile, indexList, dbName, seqFormat, sbFactory, parser);
            IndexedSequenceDB indexedDB = new IndexedSequenceDB(idMaker, indexStore);
            indexedDB.addFile(fastaFile);
            for (int i = 1; i < args.length; ++i) {
                fastaFileName = args[i];
                fastaFile = new File(fastaFileName);
                System.out.println("Indexing and adding file " + fastaFileName);
                indexedDB.addFile(fastaFile);
            }
        }
        catch (BioException be) {
            be.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

