/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.FileReader;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Symbol;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class GCContent {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Exception("usage: java seq.GCContent filename.fa");
        }
        String fileName = args[0];
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        RichSequenceIterator it = RichSequence.IOTools.readFastaDNA(br, RichObjectFactory.getDefaultNamespace());
        while (it.hasNext()) {
            RichSequence seq = it.nextRichSequence();
            System.out.println("Length: " + seq.length());
            int gc = 0;
            for (int pos = 1; pos <= seq.length(); ++pos) {
                Symbol sym = seq.symbolAt(pos);
                if (sym != DNATools.g() && sym != DNATools.c()) continue;
                ++gc;
            }
            System.out.println(seq.getName() + ": " + (double)gc * 100.0 / (double)seq.length() + " %");
        }
    }
}

