/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class TestEmbl2 {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Use: seq.TestEmbl2 emblFile");
            }
            Namespace ns = RichObjectFactory.getDefaultNamespace();
            File emblFile = new File(args[0]);
            BufferedReader eReader = new BufferedReader(new InputStreamReader(new FileInputStream(emblFile)));
            RichSequenceIterator seqI = RichSequence.IOTools.readEMBLDNA(eReader, ns);
            while (seqI.hasNext()) {
                RichSequence seq = seqI.nextRichSequence();
                System.out.println(seq.getName() + " has " + seq.countFeatures() + " features");
                TestEmbl2.printFeatures(seq, FeatureFilter.all, System.out, "");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void printFeatures(FeatureHolder fh, FeatureFilter ff, PrintStream pw, String prefix) throws Exception {
        Iterator i = fh.filter(ff, false).features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            pw.print(prefix);
            pw.print(f.getType());
            pw.print(" at ");
            pw.println(f.getLocation().toString());
            Iterator ai = f.getAnnotation().asMap().entrySet().iterator();
            while (ai.hasNext()) {
                Map.Entry me = ai.next();
                System.out.println(me.getKey() + " : " + me.getValue());
            }
            pw.println();
            TestEmbl2.printFeatures(f, ff, pw, prefix + "    ");
        }
    }
}

