/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class TestSubSequence {
    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                throw new Exception("Use: seq.TestSubSequence seqFile from to");
            }
            File file = new File(args[0]);
            int from = Integer.parseInt(args[1]);
            int to = Integer.parseInt(args[2]);
            Class.forName("org.biojavax.bio.seq.io.EMBLFormat");
            Class.forName("org.biojavax.bio.seq.io.GenbankFormat");
            Class.forName("org.biojavax.bio.seq.io.FastaFormat");
            RichSequenceIterator seqI = RichSequence.IOTools.readFile(file, RichObjectFactory.getDefaultNamespace());
            while (seqI.hasNext()) {
                RichSequence seq = seqI.nextRichSequence();
                RichSequence subSeq = RichSequence.Tools.subSequence(seq, from, to, seq.getNamespace(), seq.getName() + " from: " + from + " to: " + to, "", "", 1, new Double(1.0));
                System.out.println(subSeq.getName() + " has " + subSeq.countFeatures() + " features");
                TestSubSequence.printFeatures(subSeq, System.out, "");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void printFeatures(FeatureHolder fh, PrintStream pw, String prefix) throws Exception {
        Iterator i = fh.features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            pw.print(prefix);
            pw.print(f.getType());
            pw.print(" at ");
            pw.print(f.getLocation().toString());
            pw.println();
            TestSubSequence.printFeatures(f, pw, prefix + "    ");
        }
    }
}

