/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class UniProtDemo {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Use: seq.UniProtDemo UniprotFile");
            }
            File swissProtFile = new File(args[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(swissProtFile)));
            Namespace ns = (Namespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{"UniProt"});
            RichSequenceIterator seqI = RichSequence.IOTools.readUniProt(br, ns);
            while (seqI.hasNext()) {
                RichSequence seq = seqI.nextRichSequence();
                System.out.println(seq.getName() + " has " + seq.countFeatures() + " features");
                System.out.println("\nREGENERATING UNIPROT FILE\n");
                RichSequence.IOTools.writeUniProt((OutputStream)System.out, seq, null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

