/*
 * Decompiled with CFR 0.152.
 */
package seq.db;

import java.io.File;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.db.TabIndexStore;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;

public class CreateIndex {
    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                throw new Exception("Use: indexName format alphabet");
            }
            String indexName = args[0];
            File indexFile = new File(indexName);
            File indexList = new File(indexName + ".list");
            String formatName = args[1];
            String alphaName = args[2];
            Alphabet alpha = CreateIndex.resolveAlphabet(alphaName);
            SymbolTokenization sParser = alpha.getTokenization("token");
            SequenceFormat sFormat = null;
            SequenceBuilderFactory sFact = null;
            if (formatName.equals("fasta")) {
                sFormat = new FastaFormat();
                sFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            } else if (formatName.equals("embl")) {
                sFormat = new EmblLikeFormat();
                sFact = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            } else if (formatName.equals("swissprot")) {
                sFormat = new EmblLikeFormat();
                sFact = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            } else {
                throw new Exception("Format must be one of {embl, fasta, swissprot}");
            }
            TabIndexStore tis = new TabIndexStore(indexFile, indexList, indexName, sFormat, sFact, sParser);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static Alphabet resolveAlphabet(String alphaName) throws IllegalArgumentException {
        if ((alphaName = alphaName.toLowerCase()).equals("dna")) {
            return DNATools.getDNA();
        }
        if (alphaName.equals("protein")) {
            return ProteinTools.getAlphabet();
        }
        throw new IllegalArgumentException("Could not find alphabet for " + alphaName);
    }
}

