/*
 * Decompiled with CFR 0.152.
 */
package seqviewer;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biojava.bio.gui.sequence.EllipticalBeadRenderer;
import org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer;
import org.biojava.bio.gui.sequence.FilteringRenderer;
import org.biojava.bio.gui.sequence.MultiLineRenderer;
import org.biojava.bio.gui.sequence.RectangularBeadRenderer;
import org.biojava.bio.gui.sequence.RulerRenderer;
import org.biojava.bio.gui.sequence.SequencePanel;
import org.biojava.bio.gui.sequence.ZiggyFeatureRenderer;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.RangeLocation;

public class BeadDemo {
    private static final int INITIAL_SCALE = 30;
    private JFrame frame;
    private JButton horiz;
    private JButton vert;
    private JLabel scaleLabel;
    private JSlider scale;
    private JScrollPane seqScroll;
    private static SequencePanel seqPanel;

    public BeadDemo() {
        this.initComponents();
    }

    private void initComponents() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout());
        Box controlBox = Box.createHorizontalBox();
        this.horiz = new JButton("Horizontal");
        this.vert = new JButton("Vertical");
        this.scaleLabel = new JLabel("Scale");
        this.scale = new JSlider(0, 1, 100, 30);
        this.seqScroll = new JScrollPane(seqPanel);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(this.horiz);
        controlBox.add(Box.createHorizontalStrut(10));
        controlBox.add(this.vert);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(this.scaleLabel);
        controlBox.add(Box.createHorizontalStrut(5));
        controlBox.add(this.scale);
        controlBox.add(Box.createHorizontalGlue());
        this.frame.getContentPane().add((Component)controlBox, "North");
        this.frame.getContentPane().add((Component)this.seqScroll, "Center");
        this.horiz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BeadDemo.this.horizActionPerformed(ae);
            }
        });
        this.vert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BeadDemo.this.vertActionPerformed(ae);
            }
        });
        this.scale.addChangeListener(new SliderListener());
        this.frame.setSize(800, 200);
        this.frame.setVisible(true);
    }

    private void vertActionPerformed(ActionEvent ae) {
        seqPanel.setDirection(1);
    }

    private void horizActionPerformed(ActionEvent ae) {
        seqPanel.setDirection(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("Usage: BeadDemo <EMBL file>");
            System.exit(0);
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(argv[0]));
            SequenceIterator seqi = SeqIOTools.readEmbl(reader);
            seqPanel = new SequencePanel();
            if (seqi.hasNext()) {
                Sequence seq = seqi.nextSequence();
                Feature source = (Feature)seq.filter(new FeatureFilter.ByType("source"), false).features().next();
                seq.removeFeature(source);
                seqPanel.setSequence(seq);
                seqPanel.setRange(new RangeLocation(1, seq.length()));
                seqPanel.setScale(Math.exp(-4.285714285714286) * 20.0);
                seqPanel.setDirection(0);
                FeatureFilter.ByType cds = new FeatureFilter.ByType("CDS");
                FeatureFilter.ByType mrna = new FeatureFilter.ByType("mRNA");
                FeatureFilter.ByType rep = new FeatureFilter.ByType("repeat_region");
                FeatureFilter.ByType misc = new FeatureFilter.ByType("misc_feature");
                FeatureFilter.StrandFilter rev = new FeatureFilter.StrandFilter(StrandedFeature.NEGATIVE);
                EllipticalBeadRenderer erGreen = new EllipticalBeadRenderer(10.0, 21.0, Color.black, Color.green, new BasicStroke(), 2.0);
                EllipticalBeadRenderer erRed = new EllipticalBeadRenderer(10.0, 22.0, Color.black, Color.red, new BasicStroke(), 2.0);
                RectangularBeadRenderer rrWhite = new RectangularBeadRenderer(10.0, 0.0, Color.black, Color.white, new BasicStroke());
                RectangularBeadRenderer rrBlue = new RectangularBeadRenderer(10.0, 11.0, Color.black, Color.blue, new BasicStroke());
                RectangularBeadRenderer rrYellow = new RectangularBeadRenderer(10.0, 11.0, Color.black, Color.yellow, new BasicStroke());
                ZiggyFeatureRenderer ziggyCDS = new ZiggyFeatureRenderer();
                ZiggyFeatureRenderer ziggyRNA = new ZiggyFeatureRenderer();
                rrWhite.setDelegateRenderer(misc, erGreen);
                rrWhite.setDelegateRenderer(rep, rrBlue);
                erGreen.setDelegateRenderer(rev, erRed);
                rrBlue.setDelegateRenderer(rev, rrYellow);
                FeatureBlockSequenceRenderer fbrCDS = new FeatureBlockSequenceRenderer();
                FeatureBlockSequenceRenderer fbrRNA = new FeatureBlockSequenceRenderer();
                FeatureBlockSequenceRenderer other = new FeatureBlockSequenceRenderer();
                fbrCDS.setFeatureRenderer(ziggyCDS);
                fbrRNA.setFeatureRenderer(ziggyRNA);
                other.setFeatureRenderer(rrWhite);
                MultiLineRenderer multi = new MultiLineRenderer();
                multi.addRenderer(new FilteringRenderer(fbrCDS, cds, false));
                multi.addRenderer(new FilteringRenderer(fbrRNA, mrna, false));
                multi.addRenderer(other);
                multi.addRenderer(new RulerRenderer());
                seqPanel.setRenderer(multi);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        BeadDemo demo = new BeadDemo();
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        public void stateChanged(ChangeEvent ce) {
            JSlider source = (JSlider)ce.getSource();
            if (!source.getValueIsAdjusting()) {
                int val = source.getValue();
                double s = Math.exp((double)(-val) / 7.0) * 20.0;
                seqPanel.setScale(s);
            }
        }
    }
}

