/*
 * Decompiled with CFR 0.152.
 */
package seqviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.biojava.bio.gui.sequence.CircularFeatureFilteringRenderer;
import org.biojava.bio.gui.sequence.CircularFeatureRenderer;
import org.biojava.bio.gui.sequence.CircularFeaturesRenderer;
import org.biojava.bio.gui.sequence.CircularMLR;
import org.biojava.bio.gui.sequence.CircularPaddedRenderer;
import org.biojava.bio.gui.sequence.CircularRendererContext;
import org.biojava.bio.gui.sequence.CircularRendererPanel;
import org.biojava.bio.gui.sequence.GUITools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Location;

public class CircularEmblViewer {
    private static final double RADIUS = 200.0;

    public static void main(String[] args) throws Throwable {
        Sequence seq = SeqIOTools.readEmbl(new BufferedReader(new FileReader(new File(args[0])))).nextSequence();
        JFrame frame = new JFrame("Circular Viewer");
        frame.getContentPane().setLayout(new BorderLayout());
        CircularMLR mlr = new CircularMLR();
        TorusRenderer cfr = new TorusRenderer(Color.BLACK, Color.BLUE, 8.0);
        CircularFeaturesRenderer cfrs = new CircularFeaturesRenderer(cfr);
        mlr.addRenderer(new CircularPaddedRenderer(new CircularFeatureFilteringRenderer(cfrs, FilterUtils.byType("gene"), false), 2.0, 2.0));
        mlr.addRenderer(new CircularPaddedRenderer(new CircularFeatureFilteringRenderer(cfrs, FilterUtils.byType("CDS"), false), 2.0, 2.0));
        mlr.addRenderer(new CircularPaddedRenderer(new CircularFeatureFilteringRenderer(cfrs, FilterUtils.byType("repeat_region"), false), 2.0, 2.0));
        CircularRendererPanel crPanel = new CircularRendererPanel();
        crPanel.setRadius(200.0);
        crPanel.setSequence(seq);
        crPanel.setRenderer(mlr);
        frame.getContentPane().add((Component)new JScrollPane(crPanel), "Center");
        frame.setSize(600, 600);
        frame.setVisible(true);
    }

    private static final class TorusRenderer
    implements CircularFeatureRenderer {
        private double depth;
        private Paint fill;
        private Paint outline;

        public TorusRenderer(Paint outline, Paint fill, double depth) {
            this.outline = outline;
            this.fill = fill;
            this.depth = depth;
        }

        public double getDepth(CircularRendererContext crc) {
            return this.depth + 1.0;
        }

        public void renderFeature(Graphics2D g2, Feature f, CircularRendererContext context) {
            Rectangle2D outer = GUITools.createOuterBounds(context, this.getDepth(context));
            Rectangle2D inner = GUITools.createInnerBounds(context);
            Rectangle2D.Double mid = new Rectangle2D.Double((outer.getMinX() + inner.getMinX()) * 0.5, (outer.getMinY() + inner.getMinY()) * 0.5, (outer.getWidth() + inner.getWidth()) * 0.5, (outer.getHeight() + inner.getHeight()) * 0.5);
            Location loc = f.getLocation();
            double startA = Math.toDegrees(context.getAngle(loc.getMin()));
            double endA = Math.toDegrees(context.getAngle(loc.getMax()));
            Arc2D.Double midArc = new Arc2D.Double(mid, startA, endA - startA, 0);
            g2.setPaint(this.outline);
            g2.draw(midArc);
            Iterator i = loc.blockIterator();
            while (i.hasNext()) {
                Location l = (Location)i.next();
                startA = Math.toDegrees(context.getAngle(l.getMin()));
                endA = Math.toDegrees(context.getAngle(l.getMax()));
                Arc2D.Double outerArc = new Arc2D.Double(outer, startA, endA - startA, 0);
                Arc2D.Double innerArc = new Arc2D.Double(inner, endA, startA - endA, 0);
                GeneralPath path = new GeneralPath();
                path.append(outerArc, true);
                path.append(innerArc, true);
                path.closePath();
                g2.setPaint(this.fill);
                g2.fill(path);
                g2.setPaint(this.outline);
                g2.draw(path);
            }
        }
    }
}

