/*
 * Decompiled with CFR 0.152.
 */
package seqviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.BasicFeatureRenderer;
import org.biojava.bio.gui.sequence.BumpedRenderer;
import org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.FilteringRenderer;
import org.biojava.bio.gui.sequence.MultiLineRenderer;
import org.biojava.bio.gui.sequence.RulerRenderer;
import org.biojava.bio.gui.sequence.SequencePanel;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SymbolSequenceRenderer;
import org.biojava.bio.gui.sequence.ZiggyFeatureRenderer;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class EmblViewer2 {
    public static SequencePanel sp;
    static JFrame f;

    public static void main(String[] args) throws Exception {
        String seqFile = null;
        try {
            seqFile = args[0];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new Exception("usage: java seqviewer.EmblViewer acc.embl");
        }
        EmblLikeFormat ef = new EmblLikeFormat();
        EmblProcessor.Factory sf = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        FileInputStream is = new FileInputStream(seqFile);
        StreamReader sr = new StreamReader(is, (SequenceFormat)ef, DNATools.getDNA().getTokenization("token"), (SequenceBuilderFactory)sf);
        Sequence seq = sr.nextSequence();
        Feature source = (Feature)seq.filter(new FeatureFilter.ByType("source"), false).features().next();
        seq.removeFeature(source);
        FeatureFilter.ByType repeatFilter = new FeatureFilter.ByType("repeat_region");
        FeatureFilter.ByType miscFilter = new FeatureFilter.ByType("misc_feature");
        f = new JFrame("EMBL View");
        sp = new SequencePanel();
        sp.setSequence(seq);
        sp.setRange(new RangeLocation(1, seq.length()));
        sp.setScale(0.2);
        sp.setDirection(0);
        final BasicFeatureRenderer fr = new BasicFeatureRenderer();
        final ZiggyFeatureRenderer split = new ZiggyFeatureRenderer();
        FeatureRenderer frChooser = new FeatureRenderer(){

            public void renderFeature(Graphics2D g, Feature f, SequenceRenderContext context) {
                if (f.getLocation().isContiguous()) {
                    fr.renderFeature(g, f, context);
                } else {
                    split.renderFeature(g, f, context);
                }
            }

            public double getDepth(SequenceRenderContext context) {
                return Math.max(fr.getDepth(context), split.getDepth(context));
            }

            public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
                return hits;
            }
        };
        FeatureBlockSequenceRenderer features = new FeatureBlockSequenceRenderer();
        FeatureBlockSequenceRenderer repeats = new FeatureBlockSequenceRenderer();
        FeatureBlockSequenceRenderer misc = new FeatureBlockSequenceRenderer();
        features.setFeatureRenderer(frChooser);
        repeats.setFeatureRenderer(fr);
        misc.setFeatureRenderer(frChooser);
        FeatureFilter.And featuresFilter = new FeatureFilter.And(new FeatureFilter.Not(repeatFilter), new FeatureFilter.Not(miscFilter));
        BumpedRenderer lsr = new BumpedRenderer();
        lsr.setRenderer(features);
        MultiLineRenderer mlRend = new MultiLineRenderer();
        mlRend.addRenderer(new FilteringRenderer(repeats, repeatFilter, false));
        mlRend.addRenderer(new FilteringRenderer(misc, miscFilter, false));
        mlRend.addRenderer(new FilteringRenderer(lsr, featuresFilter, false));
        mlRend.addRenderer(new SymbolSequenceRenderer());
        mlRend.addRenderer(new RulerRenderer());
        sp.setRenderer(mlRend);
        sp.addSequenceViewerListener(new SequenceViewerListener(){

            public void mouseClicked(SequenceViewerEvent sve) {
                System.out.println(sve.getMouseEvent().getPoint() + "\t" + sve.getSource());
                Object t = sve.getTarget();
                Iterator ri = sve.getPath().iterator();
                while (ri.hasNext()) {
                    SequenceRenderer sr = (SequenceRenderer)ri.next();
                    System.out.println("\t" + sr);
                }
                if (t instanceof FeatureHolder) {
                    FeatureHolder fh = (FeatureHolder)t;
                    Iterator fi = fh.features();
                    while (fi.hasNext()) {
                        Feature f = (Feature)fi.next();
                        System.out.println("\t" + f.getType() + "\t: " + f.getLocation());
                    }
                }
            }

            public void mousePressed(SequenceViewerEvent sve) {
            }

            public void mouseReleased(SequenceViewerEvent sve) {
            }
        });
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)new JScrollPane(sp), "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        f.getContentPane().add((Component)panel, "North");
        JButton vert = new JButton("Vertical");
        vert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                sp.setDirection(1);
            }
        });
        JButton horiz = new JButton("Horizontal");
        horiz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                sp.setDirection(0);
            }
        });
        JButton blue = new JButton("Blue");
        blue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    fr.setFill(Color.blue);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError(cve, "oops");
                }
            }
        });
        JButton red = new JButton("Red");
        red.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    fr.setFill(Color.red);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError(cve, "oops");
                }
            }
        });
        JScrollBar scale = new JScrollBar(0);
        scale.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                int val = e.getValue();
                double s = Math.exp((double)(-val) / 7.0) * 20.0;
                System.out.println("Scale now at " + s);
                sp.setScale(s);
            }
        });
        panel.add(vert);
        panel.add(horiz);
        panel.add(blue);
        panel.add(red);
        panel.add(scale);
        f.setSize(500, 500);
        f.setVisible(true);
    }
}

