/*
 * Decompiled with CFR 0.152.
 */
package seqviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import org.biojava.bio.Annotation;
import org.biojava.bio.gui.sequence.BasicFeatureRenderer;
import org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer;
import org.biojava.bio.gui.sequence.GappedRenderer;
import org.biojava.bio.gui.sequence.MultiLineRenderer;
import org.biojava.bio.gui.sequence.RulerRenderer;
import org.biojava.bio.gui.sequence.SymbolSequenceRenderer;
import org.biojava.bio.gui.sequence.TranslatedSequencePanel;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceTools;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.symbol.RangeLocation;

public class GappedViewer {
    public static void main(String[] args) throws Throwable {
        Sequence ourSeq = SequenceTools.createSequence(DNATools.createDNA("atcgtacgtatgtatcagtcagattcgtagtcatcgtatctgctga"), "aseq", "A sequence", Annotation.EMPTY_ANNOTATION);
        Feature.Template ftempl = new Feature.Template();
        ftempl.source = "hand_made";
        ftempl.type = "AFeature";
        ftempl.annotation = Annotation.EMPTY_ANNOTATION;
        ftempl.location = new RangeLocation(3, 20);
        ourSeq.createFeature(ftempl);
        ftempl.location = new RangeLocation(35, 44);
        ourSeq.createFeature(ftempl);
        ftempl.location = new RangeLocation(23, 30);
        ourSeq.createFeature(ftempl);
        SimpleGappedSequence gSeq = new SimpleGappedSequence(ourSeq);
        gSeq.addGapsInSource(27, 10);
        SymbolSequenceRenderer symRend = new SymbolSequenceRenderer();
        RulerRenderer ruler = new RulerRenderer();
        FeatureBlockSequenceRenderer featRend = new FeatureBlockSequenceRenderer(new BasicFeatureRenderer());
        MultiLineRenderer mlr = new MultiLineRenderer();
        mlr.addRenderer(featRend);
        mlr.addRenderer(symRend);
        mlr.addRenderer(ruler);
        MultiLineRenderer mainRend = new MultiLineRenderer();
        mainRend.addRenderer(mlr);
        mainRend.addRenderer(new GappedRenderer(mlr));
        JFrame frame = new JFrame("Gapped Viewer Demo");
        frame.setSize(600, 400);
        TranslatedSequencePanel sp = new TranslatedSequencePanel();
        sp.setSequence(gSeq);
        sp.setRenderer(mainRend);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)sp, "Center");
        frame.setVisible(true);
    }
}

