/*
 * Decompiled with CFR 0.152.
 */
package ssaha;

import java.io.File;
import java.util.ArrayList;
import org.biojava.bio.program.ssaha.CompactedDataStoreFactory;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.SequenceStreamer;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.DNANoAmbPack;

public class CreateDNAFastaHashTableCompact {
    public static void printUsage() {
        System.err.println("Usage: java ssaha.CreateDNAFastaHashTable [<options>] hashfile.store seq1.fa [seq2.fa ...]");
        System.err.println("Options are: ");
        System.err.println("   -wordSize      [default 10]");
        System.err.println("   -stepSize      [default 1]");
        System.err.println("   -threshold     [default 20000]");
    }

    public static void main(String[] args) throws Exception {
        File dataStoreFile = null;
        int wordSize = 10;
        int stepSize = 1;
        int threshold = 20000;
        ArrayList<File> seqFiles = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if ("-threshold".equals(args[i])) {
                    threshold = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-wordSize".equals(args[i])) {
                    wordSize = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-stepSize".equals(args[i])) {
                    stepSize = Integer.parseInt(args[++i]);
                    continue;
                }
                System.err.println("Unknown option " + args[i]);
                CreateDNAFastaHashTableCompact.printUsage();
                return;
            }
            if (dataStoreFile == null) {
                dataStoreFile = new File(args[i]);
                continue;
            }
            seqFiles.add(new File(args[i]));
        }
        if (dataStoreFile == null || seqFiles.size() == 0) {
            CreateDNAFastaHashTableCompact.printUsage();
            return;
        }
        SequenceStreamer.FileStreamer streamer = new SequenceStreamer.FileStreamer(SeqIOTools.getSequenceFormat(SeqIOTools.guessFileType((File)seqFiles.get(0))), DNATools.getDNA().getTokenization("token"), seqFiles);
        DataStore ds = new CompactedDataStoreFactory().buildDataStore(dataStoreFile, streamer, new DNANoAmbPack(-1), wordSize, stepSize, threshold);
    }
}

