/*
 * Decompiled with CFR 0.152.
 */
package ssaha;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.biojava.bio.program.ssaha.CompactedDataStoreFactory;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.DataStoreFactory;
import org.biojava.bio.program.ssaha.HitMerger;
import org.biojava.bio.program.ssaha.MappedDataStoreFactory;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import ssaha.ResultPrinter;

public class SSAHA {
    public static void main(String[] args) throws Throwable {
        File dataStoreFile = new File(args[0]);
        File seqFile = new File(args[1]);
        String tableFormat = "classic";
        if (args.length > 2) {
            tableFormat = args[2];
        }
        DataStoreFactory dsf = "compact".equals(tableFormat) ? new CompactedDataStoreFactory() : new MappedDataStoreFactory();
        DataStore ds = dsf.getDataStore(dataStoreFile);
        HitMerger listener = new HitMerger(new ResultPrinter(ds), 20);
        SequenceIterator si = SeqIOTools.readFastaDNA(new BufferedReader(new FileReader(seqFile)));
        while (si.hasNext()) {
            Sequence seq = si.nextSequence();
            ds.search(seq.getName(), seq, listener);
        }
    }
}

