/*
 * Decompiled with CFR 0.152.
 */
package ssbind;

import org.biojava.bio.BioError;
import org.biojava.bio.search.SearchContentFilter;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SmallMap;

public class AlignmentBuilder
extends SearchContentFilter {
    public static final Object QUERY = AlignmentBuilder.class.toString() + ".QUERY";
    public static final Object SUBJECT = AlignmentBuilder.class.toString() + ".SUBJECT";
    public static final Object ALIGNMENT = AlignmentBuilder.class.toString() + ".ALIGNMENT";
    private SymbolList querySequence;
    private SymbolList subjectSequence;

    public void addSubHitProperty(Object key, Object val) {
        try {
            if ("querySequence".equals(key)) {
                this.querySequence = DNATools.createDNA((String)val);
            } else if ("subjectSequence".equals(key)) {
                this.subjectSequence = DNATools.createDNA((String)val);
            } else {
                super.addSubHitProperty(key, val);
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise);
        }
    }

    public void endSubHit() {
        SmallMap seqMap = new SmallMap();
        seqMap.put(QUERY, this.querySequence);
        seqMap.put(SUBJECT, this.subjectSequence);
        super.addSubHitProperty(ALIGNMENT, new SimpleAlignment(seqMap));
        super.endSubHit();
    }

    public AlignmentBuilder(SearchContentHandler delegate) {
        super(delegate);
    }
}

