/*
 * Decompiled with CFR 0.152.
 */
package symbol;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import symbol.MatrixValue;

public class PatternDemo {
    private SymbolList fileSeq;
    private SymbolList motif;
    private StringBuffer fileSeqSB;
    private StringBuffer motifSB;
    private String seqTitle;
    private int fileSeqLength;
    private int fileSeqStart;
    private int fileSeqEnd;
    private int motifLength;
    private int matchScore;
    private int subScore;
    private int insScore;
    private int delScore;
    private int hitCount;
    private int maxSub;
    private int maxIns;
    private int maxDel;
    private int sink;
    private int score;
    private int backStep;
    private boolean match;
    private ArrayList path;
    private MatrixValue[][] matrix;
    private MatrixValue[] lastColumn;
    public static final int ONEMILLION = 1000000000;
    public static final int X_AXIS = 10000;

    public PatternDemo(Sequence fileSeq, SymbolList motif, String sub, String ins, String del) throws Exception {
        this.fileSeq = fileSeq;
        this.motif = motif;
        this.maxSub = Integer.parseInt(sub);
        this.maxIns = Integer.parseInt(ins);
        this.maxDel = Integer.parseInt(del);
        this.seqTitle = fileSeq.getName();
        this.fileSeqSB = new StringBuffer();
        this.motifSB = new StringBuffer();
        this.fileSeqLength = fileSeq.length();
        this.fileSeqStart = 1;
        this.fileSeqEnd = this.fileSeqLength;
        this.motifLength = motif.length();
        this.backStep = this.motifLength + this.maxIns;
        this.matchScore = 0;
        this.subScore = 0;
        this.insScore = 0;
        this.delScore = 0;
        this.score = 0;
        this.match = false;
        this.sink = 0;
        this.hitCount = 0;
        this.path = new ArrayList();
    }

    public void fillMatrix() throws BioException {
        for (int i = 0; i <= this.motifLength; ++i) {
            this.matrix[0][i] = this.lastColumn[i];
        }
        for (int y = 1; y <= this.motifLength; ++y) {
            for (int x = 1; x <= this.fileSeqEnd - this.fileSeqStart + 1; ++x) {
                Symbol B;
                Symbol A = this.fileSeq.symbolAt(x + this.fileSeqStart - 1);
                if (PatternDemo.compare(A, B = this.motif.symbolAt(y))) {
                    this.score = this.matrix[x - 1][y - 1].getScore();
                    ++this.score;
                    this.match = true;
                } else {
                    this.score = this.matrix[x - 1][y - 1].getScore() - 1;
                    this.match = false;
                }
                if (this.matrix[x - 1][y].getScore() - 1 > this.score) {
                    this.score = this.matrix[x - 1][y].getScore() - 1;
                    this.match = false;
                }
                if (this.matrix[x][y - 1].getScore() - 1 > this.score) {
                    this.score = this.matrix[x][y - 1].getScore() - 1;
                    this.match = false;
                }
                if (0 > this.score) {
                    this.score = 0;
                    this.match = false;
                }
                this.matrix[x][y] = new MatrixValue(this.score, this.match);
            }
        }
    }

    private static boolean compare(Symbol symbolA, Symbol symbolB) throws BioException {
        FiniteAlphabet A = (FiniteAlphabet)symbolA.getMatches();
        FiniteAlphabet B = (FiniteAlphabet)symbolB.getMatches();
        Iterator ia = A.iterator();
        boolean hits = false;
        while (ia.hasNext()) {
            Symbol s = (Symbol)ia.next();
            if (!B.contains(s)) continue;
            return true;
        }
        return false;
    }

    public void printMatrix(int s) {
        int y;
        int start = s;
        System.out.print(" ");
        for (y = s; y < s + this.motifLength; ++y) {
            System.out.print(" " + this.fileSeq.subStr(y, y));
        }
        System.out.println();
        System.out.print(" ");
        for (y = s; y < s + this.motifLength; ++y) {
            System.out.print(" " + String.valueOf(this.matrix[y][0].getScore()));
        }
        System.out.println();
        for (y = 1; y <= this.motifLength; ++y) {
            System.out.print(this.motif.subStr(y, y));
            for (int x = s; x < s + this.motifLength; ++x) {
                System.out.print(" " + this.matrix[x][y].getScore());
            }
            System.out.println();
        }
    }

    public boolean backtrack(int x, int y) {
        if (this.sidFailure()) {
            return false;
        }
        if (this.initialVector(x, y)) {
            return true;
        }
        if (this.matrix[x][y].getMatch()) {
            ++this.matchScore;
            if (this.backtrack(x - 1, y - 1)) {
                this.path.add("MATCH:" + x + "," + y);
                return true;
            }
        } else {
            return this.probePaths(x, y);
        }
        return false;
    }

    public void resetPath(Collection c) {
        this.path.clear();
        this.path.addAll(c);
    }

    public boolean sidFailure() {
        if (this.subScore > this.maxSub) {
            --this.subScore;
            return true;
        }
        if (this.insScore > this.maxIns) {
            --this.insScore;
            return true;
        }
        if (this.delScore > this.maxDel) {
            --this.delScore;
            return true;
        }
        return false;
    }

    public boolean initialVector(int x, int y) {
        if (x == 0 && y == 0) {
            return true;
        }
        if (x == 0) {
            this.path.add("DEL:" + x + "," + y);
            ++this.delScore;
            return true;
        }
        return y == 0;
    }

    public boolean probePaths(int x, int y) {
        ArrayList originalPath = new ArrayList();
        ArrayList subPath = new ArrayList();
        ArrayList insPath = new ArrayList();
        ArrayList delPath = new ArrayList();
        int S = this.subScore++;
        int I = this.insScore;
        int D = this.delScore;
        int M = this.matchScore;
        int subPathScore = 1000000000;
        int insPathScore = 1000000000;
        int delPathScore = 1000000000;
        int subMatches = 0;
        int insMatches = 0;
        int delMatches = 0;
        originalPath.addAll(this.path);
        if (this.backtrack(x - 1, y - 1)) {
            subPathScore = this.subScore + 2 * this.insScore + 2 * this.delScore;
            subMatches = this.matchScore;
        }
        subPath.addAll(this.path);
        this.resetPath(originalPath);
        this.subScore = S;
        this.insScore = I;
        this.delScore = D;
        this.matchScore = M;
        ++this.insScore;
        if (this.backtrack(x - 1, y)) {
            insPathScore = this.subScore + 2 * this.insScore + 2 * this.delScore;
            insMatches = this.matchScore;
        }
        insPath.addAll(this.path);
        this.resetPath(originalPath);
        this.subScore = S;
        this.insScore = I;
        this.delScore = D;
        this.matchScore = M;
        ++this.delScore;
        if (this.backtrack(x, y - 1)) {
            delPathScore = this.subScore + 2 * this.insScore + 2 * this.delScore;
            delMatches = this.matchScore;
        }
        delPath.addAll(this.path);
        this.resetPath(originalPath);
        this.subScore = S;
        this.insScore = I;
        this.delScore = D;
        this.matchScore = M;
        if (subPathScore == 1000000000 && insPathScore == 1000000000 && delPathScore == 1000000000) {
            return false;
        }
        if (subMatches > insMatches && subMatches > delMatches) {
            this.path.addAll(subPath);
            this.path.add("SUB:" + x + "," + y);
            this.updateScores();
            return true;
        }
        if (insMatches > subMatches && insMatches > delMatches) {
            this.path.addAll(insPath);
            this.path.add("INS:" + x + "," + y);
            this.updateScores();
            return true;
        }
        if (delMatches > subMatches && delMatches > insMatches) {
            this.path.addAll(delPath);
            this.path.add("DEL:" + x + "," + y);
            this.updateScores();
            return true;
        }
        if (subPathScore != 1000000000 && subPathScore <= insPathScore && subPathScore <= delPathScore) {
            this.path.addAll(subPath);
            this.path.add("SUB:" + x + "," + y);
            this.updateScores();
            return true;
        }
        if (insPathScore != 1000000000 && insPathScore <= subPathScore && insPathScore <= delPathScore) {
            this.path.addAll(insPath);
            this.path.add("INS:" + x + "," + y);
            this.updateScores();
            return true;
        }
        if (delPathScore != 1000000000 && delPathScore <= subPathScore && delPathScore <= insPathScore) {
            this.path.addAll(delPath);
            this.path.add("DEL:" + x + "," + y);
            this.updateScores();
            return true;
        }
        return false;
    }

    public void resetScores() {
        this.matchScore = 0;
        this.subScore = 0;
        this.insScore = 0;
        this.delScore = 0;
    }

    public void printScores() {
        System.out.println("SCORES:");
        System.out.println("Matches: " + this.matchScore);
        System.out.println("Substitutions: " + this.subScore);
        System.out.println("Insertions: " + this.insScore);
        System.out.println("Deletions: " + this.delScore);
        System.out.println();
    }

    public int getTotalHits() {
        return this.hitCount;
    }

    public void startBacktrack() {
        int minScore = this.motifLength - ((this.maxSub + this.maxDel) * 2 + this.maxIns);
        for (int i = 1; i <= this.fileSeqEnd - this.fileSeqStart + 1; ++i) {
            this.sink = i;
            if (this.matrix[i][this.motifLength].getScore() < minScore) continue;
            this.path.clear();
            this.resetScores();
            if (!this.backtrack(this.sink, this.motif.length())) continue;
            this.printHit();
            this.arrangeSBs();
            this.printAlignment();
        }
    }

    public void startSearch() throws Exception {
        int y;
        this.matrix = new MatrixValue[10002][this.motifLength + 1];
        this.lastColumn = new MatrixValue[this.motifLength + 1];
        for (int x = 0; x <= 10001; ++x) {
            this.matrix[x][0] = new MatrixValue(0, false);
        }
        for (y = 0; y <= this.motifLength; ++y) {
            this.lastColumn[y] = new MatrixValue(0, false);
        }
        if (this.fileSeqLength > 10000) {
            this.fileSeqEnd = 10001;
        }
        while (this.fileSeqEnd <= this.fileSeqLength) {
            this.fillMatrix();
            this.startBacktrack();
            if (this.sink - this.backStep <= 0) continue;
            for (y = 1; y <= this.motifLength; ++y) {
                this.lastColumn[y] = this.matrix[this.sink - this.backStep][y];
            }
            this.setFileSeqIndices();
        }
    }

    public void setFileSeqIndices() {
        if (this.fileSeqEnd + 10000 < this.fileSeqLength) {
            this.fileSeqStart += this.sink - this.backStep;
            this.fileSeqEnd = this.fileSeqStart + 10000;
        } else if (this.fileSeqEnd == this.fileSeqLength) {
            this.fileSeqEnd = this.fileSeqLength + 100;
        } else {
            this.fileSeqStart += this.sink - this.backStep;
            this.fileSeqEnd = this.fileSeqLength;
        }
    }

    public void printAlignment() {
        System.out.println("ALIGNMENT:");
        System.out.println(this.fileSeqSB.toString());
        System.out.println(this.motifSB.toString());
        System.out.println();
    }

    public void arrangeSBs() {
        this.motifSB.delete(0, this.motifSB.length());
        this.fileSeqSB.delete(0, this.fileSeqSB.length());
        String start = (String)this.path.get(0);
        start = start.substring(start.indexOf(":") + 1, start.indexOf(","));
        int adjStart = Integer.parseInt(start);
        String motifString = this.motif.seqString();
        String fileSeqString = this.fileSeq.subStr(adjStart += this.fileSeqStart - 1, adjStart + this.path.size() - 1);
        int motifCount = 0;
        int fileSeqCount = 0;
        Iterator it = this.path.iterator();
        while (it.hasNext()) {
            String tmpString = (String)it.next();
            if (tmpString.startsWith("MATCH")) {
                this.motifSB.append(motifString.charAt(motifCount++));
                this.fileSeqSB.append(fileSeqString.charAt(fileSeqCount++));
                continue;
            }
            if (tmpString.startsWith("SUB")) {
                this.motifSB.append(motifString.charAt(motifCount++));
                this.fileSeqSB.append(fileSeqString.charAt(fileSeqCount++));
                continue;
            }
            if (tmpString.startsWith("INS")) {
                this.motifSB.append("-");
                this.fileSeqSB.append(fileSeqString.charAt(fileSeqCount++));
                if (motifCount != 0) continue;
                ++motifCount;
                continue;
            }
            if (!tmpString.startsWith("DEL")) continue;
            this.motifSB.append(motifString.charAt(motifCount++));
            this.fileSeqSB.append("-");
            if (fileSeqCount != 0) continue;
            ++fileSeqCount;
        }
    }

    public void printPath() {
        System.out.println("PATH:");
        Iterator it = this.path.iterator();
        while (it.hasNext()) {
            String tmpString = (String)it.next();
            System.out.println(tmpString);
        }
    }

    public void printHit() {
        ++this.hitCount;
        System.out.print(this.seqTitle);
        String firstPath = (String)this.path.get(0);
        String start = firstPath.substring(firstPath.indexOf(":") + 1, firstPath.indexOf(","));
        int adjStart = Integer.parseInt(start);
        adjStart += this.fileSeqStart - 1;
        if (firstPath.startsWith("DEL")) {
            ++adjStart;
        }
        start = String.valueOf(adjStart);
        String end = (String)this.path.get(this.path.size() - 1);
        end = end.substring(end.indexOf(":") + 1, end.indexOf(","));
        int adjEnd = Integer.parseInt(end);
        end = String.valueOf(adjEnd += this.fileSeqStart - 1);
        System.out.println(":[" + start + "," + end + "]:" + this.matchScore + "[" + this.subScore + "," + this.insScore + "," + this.delScore + "]");
    }

    public void updateScores() {
        Iterator it = this.path.iterator();
        while (it.hasNext()) {
            String tmpString = (String)it.next();
            if (tmpString.startsWith("MATCH")) {
                ++this.matchScore;
            }
            if (tmpString.startsWith("SUB")) {
                ++this.subScore;
            }
            if (tmpString.startsWith("INS")) {
                ++this.insScore;
            }
            if (!tmpString.startsWith("DEL")) continue;
            ++this.delScore;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Usage: >java pattern.PatternDemo <fasta file  fileName> <SymbolList motif> <int maxSub> <int maxIns> <int maxDel>\nExample >java pattern.PatternDemo input.fasta atctgat 1 1 1");
        }
        String fileName = args[0];
        FileReader stream = new FileReader(fileName);
        BufferedReader br = new BufferedReader(stream);
        SequenceIterator si = SeqIOTools.readFastaDNA(br);
        SymbolList motif = DNATools.createDNA(args[1]);
        int totalHits = 0;
        while (si.hasNext()) {
            Sequence sequence = si.nextSequence();
            PatternDemo aMatrix = new PatternDemo(sequence, motif, args[2], args[3], args[4]);
            aMatrix.startSearch();
            totalHits += aMatrix.getTotalHits();
            if (si.hasNext()) continue;
            System.out.println("totalHits = " + totalHits);
        }
    }
}

