/*
 * Decompiled with CFR 0.152.
 */
package symbol;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;

public class TestAlphabetIndexers {
    public static void main(String[] args) throws Exception {
        int size = 2;
        int extra = 2;
        System.out.println("Test the simple case of a fixed-size alphabet");
        SimpleAlphabet testAlpha = new SimpleAlphabet();
        System.out.println("Adding symbols");
        int c = 97;
        for (int i = 0; i < size; ++i) {
            System.out.println("Creating symbol " + (char)(c + i));
            testAlpha.addSymbol(AlphabetManager.createSymbol("Symbol " + i, Annotation.EMPTY_ANNOTATION));
        }
        System.out.println("Creating alphabet index");
        AlphabetIndex ai = AlphabetManager.getAlphabetIndex(testAlpha);
        ai.addChangeListener(ChangeListener.LOG_TO_OUT, AlphabetIndex.INDEX);
        for (int i = 0; i < size; ++i) {
            System.out.println(i + " -> " + ai.symbolForIndex(i).getName());
        }
        Iterator si = testAlpha.iterator();
        while (si.hasNext()) {
            Symbol s = (Symbol)si.next();
            System.out.println(ai.indexForSymbol(s) + " -> " + s.getName());
        }
        System.out.println("Test the complex case of a  variable-size alphabet");
        for (int ii = size; ii < size + extra; ++ii) {
            testAlpha.addSymbol(AlphabetManager.createSymbol("Symbol " + ii, Annotation.EMPTY_ANNOTATION));
            for (int i = 0; i < ii; ++i) {
                System.out.println(i + " -> " + ai.symbolForIndex(i).getName());
            }
            Iterator si2 = testAlpha.iterator();
            while (si2.hasNext()) {
                Symbol s = (Symbol)si2.next();
                System.out.println(ai.indexForSymbol(s) + " -> " + s.getName());
            }
        }
    }
}

