/*
 * Decompiled with CFR 0.152.
 */
package tagvalue;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.biojava.bio.program.formats.Format;
import org.biojava.bio.program.tagvalue.AnnotationBuilder;
import org.biojava.bio.program.tagvalue.Echo;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.tagvalue.TagValueListener;

public class Parse {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            Parse.useageAndExit();
        }
        boolean build = false;
        if (args[0].startsWith("-b")) {
            build = true;
        } else if (args[0].startsWith("-e")) {
            build = false;
        } else {
            Parse.useageAndExit();
        }
        String formatName = args[1];
        Format format = Parse.createFormat(formatName);
        System.err.println("Using format: " + format.getLSID());
        TagValueListener listener = build ? new AnnotationBuilder(format.getType()) : new Echo();
        ParserListener pl = format.getParserListener(listener);
        Parser parser = new Parser();
        for (int i = 2; i < args.length; ++i) {
            BufferedReader reader = new BufferedReader(new FileReader(new File(args[i])));
            while (parser.read(reader, pl.getParser(), pl.getListener())) {
                if (!build) continue;
                System.out.println(((AnnotationBuilder)listener).getLast());
            }
        }
    }

    private static void useageAndExit() {
        System.err.println("Use: tagvalue.Parse [-b | -e] format <file list>");
        System.err.println("\t-b\t: build and print out full anntoation bundles");
        System.err.println("\t-e\t: echo parser events directly");
        System.err.println("\tformat\t: format name. One of");
        System.err.println("\t\tthe name of a class in org.biojava.bio.program.format");
        System.err.println("\t\tfully qualified class name");
        System.err.println("\t\tEither way, the class must be castable to");
        System.err.println("\t\torg.biojava.bio.program.formats.Format.");
        System.exit(1);
    }

    private static Format createFormat(String formatName) throws Exception {
        Class<?> formatClass;
        try {
            formatClass = Parser.class.getClassLoader().loadClass(formatName);
        }
        catch (ClassNotFoundException cnfe1) {
            System.err.println("Could not find class named: " + formatName);
            formatName = "org.biojava.bio.program.formats." + formatName;
            try {
                formatClass = Parser.class.getClassLoader().loadClass(formatName);
            }
            catch (ClassNotFoundException cnfe2) {
                System.err.println("Could not find class named: " + formatName);
                throw cnfe2;
            }
        }
        return (Format)formatClass.newInstance();
    }
}

