#
#
# NOTE: Building DLL versions of the libraries
# is still in beta stadium.
#
# Do it on your own risk.
# If you encounter difficulties use nt.mak and
# build static versions.
#
#

#
# START OF CONFIGURATION SECTION.
#
# You may need to customize this section.
#

# Where do you want to install the software?
PROGRAMS=C:\Programs
VENDOR=Krause
PREFIX=$(PROGRAMS)\$(VENDOR)

# Which programs to use for compiling and linking?
CC=CL
LD=LINK

#
# Where is Visual C?
# Directories lib, include and bin must be beyound this.
#
VC=$(PROGRAMS)\DevStudio\Vc

# ### CAN NOT BUILD WITHOUT PNGLIB
PNG_DEF=-DHAVE_LIBPNG=1
PNG_DIR=-I$(PROGRAMS)\LibPNG\Include
PNG_LIB=$(PROGRAMS)\LibPNG\Lib\libpng.lib

# JPEGLIB
JPEG_DEF=-DHAVE_JPEGLIB_H=0
# JPEG_DEF=-DHAVE_JPEGLIB_H=1
# JPEG_DIR=-I$(PROGRAMS)\LibJPEG\Include
# JPEG_LIB=$(PROGRAMS)\LibJPEG\Lib\libjpeg.lib
# JPGEPSOBJ=jpgeps.obj

# TIFFLIB - maybe in June 2003
TIFF_DEF=-DHAVE_TIFF_H=0
# TIFF_DEF=-DHAVE_TIFF_H=1
# TIFF_DIR=-I$(PROGRAMS)\LibTIFF\Include
# TIFF_LIB=$(PROGRAMS)\LibTIFF\Lib\libtiff.lib
# TIFEPSOBJ=tifeps.obj

# NETPBM
PNM_DEF=-DHAVE_PNM_H=0
# PNM_DEF=-DHAVE_PNM_H=1
# PNM_DIR=-I$(PROGRAMS)\NetPBM\Include
# PNM_LIB=$(PROGRAMS)\NetPBM\Lib\netpbm.lib
# PNMEPSOBJ=pnmeps.obj

# ### CAN NOT BUILD WITHOUT ZLIB
# ------------------------------
ZL_DEF=-DHAVE_ZLIB=1
ZL_DIR=-I$(PROGRAMS)\Zlib\Include
ZL_LIB=$(PROGRAMS)\Zlib\lib\zlib.lib

#
# Where is the system configuration directory?
#

SCD=	-DSYSCONFDIR=\"C:\\ETC\"

#
# Toggle the following section to specify german
# as the default language.
#

# LANG=de
LANG=en

#
# END OF CONFIGURATION SECTION.
#
# No changes should be necessary below this line.
#

all:	progs libs

install:	all
	-mkdir $(PREFIX)
	-mkdir $(PREFIX)\include
	-mkdir $(PREFIX)\lib
	-mkdir $(PREFIX)\lib\stc
	-mkdir $(PREFIX)\bin
	-xcopy stc.exe $(PREFIX)\bin
	-xcopy tracecc.exe $(PREFIX)\bin
	-xcopy dkconfig.exe $(PREFIX)\bin
	-xcopy *.h $(PREFIX)\include
	.\dkconfig.exe > $(PREFIX)\include\dkconfig.h
	-xcopy lib\*.* $(PREFIX)\lib /S
	-xcopy *.lib $(PREFIX)\lib
	-xcopy *.dll $(PREFIX)\bin
	-.\stc $(STCOPT) -p stc.str $(PREFIX)\lib\stc
	-.\stc $(STCOPT) -p dkapp.str $(PREFIX)\lib
	-.\stc $(STCOPT) -p dkappd.str $(PREFIX)\lib
	-xcopy $(PREFIX)\lib\en\dkapp.* $(PREFIX)\lib
	-xcopy $(PREFIX)\lib\en\dkappd.* $(PREFIX)\lib
	-xcopy $(PREFIX)\lib\stc\en\stc.* $(PREFIX)\lib\stc
	-mkdir $(PREFIX)\docu
	-xcopy docu\*.pdf $(PREFIX)\docu
	-.\winsetup $(PREFIX) $(LANG)

progs:	bmeps.exe

libs:	bmeps.dll

DLLOBJ=	bmeps.obj \
	bmepsoe.obj \
	pngeps.obj \
	$(JPGEPSOBJ) \
	$(PNMEPSOBJ)
	# $(TIFEPSOBJ) - maybe in June 2003

IMGLIBS=	$(PNG_LIB) $(JPEG_LIB) $(PNM_LIB) # $(TIFF_LIB) - maybe in June 2003

bmeps.dll:	$(DLLOBJ) bmeps.def
	$(LD) /nologo /NODEFAULTLIB /INCREMENTAL:NO /RELEASE /dll /pdb:none /machine:I386 /def:"bmeps.def" /out:"bmeps.dll" /implib:"bmeps.lib" $(DLLOBJ) $(IMGLIBS) $(ZL_LIB) advapi32.lib msvcrt.lib kernel32.lib

bmeps.exe:	bmepsm.obj bmeps.dll
	$(LD) /nologo /out:bmeps.exe bmepsm.obj .\bmeps.lib msvcrt.lib advapi32.lib kernel32.lib

IMGDIRS=	$(PNG_DIR) $(JPEG_DIR) $(PNM_DIR) # $(TIFF_DIR)
IMGDEFS=	$(PNG_DEF) $(JPEG_DEF) $(PNM_DEF) # $(TIFF_DEF)

.c.obj:
	$(CC) /nologo -DWIN32 -D_WIN32 -D_MT -D_DLL $(SCD) -MD -O -I. $(IMGDIRS) $(IMGDEFS) $(ZL_DIR) $(ZL_DEF) $(CFLAGS) $(VERSNO) -DHAVE_STRICMP=0 -DHAVE__STRICMP=1 -DHAVE_GETPID=0 -DHAVE__GETPID=1 -DHAVE_UNLINK=0 -DHAVE__UNLINK=1 -c $*.c

