
#
# START OF CONFIGURATION
#

# Base directory for applications
# PROGRAMS=C:\Programme
PROGRAMS=C:\Programs

# Directory for bmeps installation
PREFIX=$(PROGRAMS)\Krause

# Directory where the binary should be installed.
# You might want to change this to point to your Windows directory.
# BINDIR=C:\WinNT
BINDIR=$(PREFIX)\bin

Z_DIR=$(PROGRAMS)\Zlib
Z_DEF=-DHAVE_ZLIB=1
Z_INC=-I$(Z_DIR)\include
Z_LIB=$(Z_DIR)\lib\zlib.lib

PNG_DIR=$(PROGRAMS)\Libpng
PNG_DEF=-DHAVE_LIBPNG=1
PNG_INC=-I$(PNG_DIR)\include
PNG_LIB=$(PNG_DIR)\lib\libpng.lib

# maybe in June 2003
# TIFF_DIR=$(PROGRAMS)\Libtiff
# TIFF_DEF=-DHAVE_TIFF_H=1
# TIFF_INC=-I$(TIFF_DIR)\include
# TIFF_LIB=$(TIFF_DIR)\lib\libtiff.lib

JPEG_DIR=$(PROGRAMS)\Libjpeg
JPEG_DEF=-D_HAVE_JPEGLIB_H=1
JPEG_INC=-I$(JPEG_DIR)\include
JPEG_LIB=$(JPEG_DIR)\lib\jpeg.lib

NETPBM_DIR=$(PROGRAMS)\Netpbm
NETPBM_DEF=-DHAVE_PNM_H=1
NETPBM_INC=-I$(NETPBM_DIR)\include
NETPBM_LIB=$(NETPBM_DIR)\lib\netpbm.lib

# Where does Visual C++ reside on your system
VC=$(PROGRAMS)\DevStudio\VC

# For "Home" Windows change the xcopy flags
# XCOPYFLAGS=/Y
XCOPYFLAGS=

#
# END OF CONFIGURATION
#


LD=LINK
LDFLAGS=$(CFLAGS) /nologo

IMGINC=	$(PNG_INC) $(JPEG_INC) $(NETPBM_INC) # $(TIFF_INC) - maybe in June 2003
.c.obj:
	$(CC) /nologo -DWIN32 -D_WIN32 -D_MT -I. $(VERSNO) $(Z_INC) $(IMGINC) -c $*.c


OBJECTS= \
	bmeps.obj \
	pngeps.obj \
	jpgeps.obj \
	pnmeps.obj \
	bmepsoe.obj
#	tifepsojb - maybe in June 2003


WL1=$(VC)\lib\advapi32.lib
IMGLIBS= $(PNG_LIB) $(JPEG_LIB) $(NETPBM_LIB) # $(TIFF_LIB) - maybe in June 2003

bmeps.lib: $(OBJECTS)
	LIB /OUT:bmeps.lib $(OBJECTS)

bmeps.exe: $(OBJECTS) bmepsm.obj
	$(LD) $(LDFLAGS) /out:bmeps.exe /NODEFAULTLIB /INCREMENTAL:NO /RELEASE bmepsm.obj bmeps.lib $(IMGLIBS) $(Z_LIB) advapi32.lib msvcrt.lib kernel32.lib

install:	bmeps.exe
	-mkdir $(BINDIR)
	xcopy bmeps.exe $(BINDIR)\bmeps.exe $(XCOPYFLAGS)

