;
;    bomb - automatic interactive visual stimulation
;    Copyright (C) 1994  Scott Draves <spot@cs.cmu.edu>
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

(define fill-hramp  0)
(define fill-vramp  1)
(define fill-grid   2)
(define fill-noise  3)
(define fill-vnoise 4)
(define fill-sparse 5)
(define nfills      6)

(define rule-rug            0)
(define rule-rug2           1)
(define rule-static         2)
(define rule-rotorug        3)
(define rule-acidlife1      4)
(define rule-acidlife2      5)
(define rule-rug-anneal     6)
(define rule-rug-anneal2    7)
(define rule-rug-rug        8)
(define rule-rug-brain      9)
(define rule-shade         10)
(define rule-wave          11)
(define rule-rug-image     12)
(define rule-slip          13)
(define rule-fuse          14)
(define rule-rug-multi     15)
(define rule-rd            16)
(define rule-rd2           17)
(define rule-quad          18)
(define nrules             19)

(define cmap-mono   0)
(define cmap-mono4  1)
(define cmap-loop   2)
(define cmap-path   3)
(define cmap-heat   4)
(define cmap-plain  5)
(define cmap-split  6)
(define cmap-noise  7)
(define cmap-black  8)
(define cmap-ramp   9)

(define fill bomb-fill)
(define (frame . a)
  (bomb-do-frame (if (null? a) 1 (car a))))
(define pulse bomb-pulse)
(define pulse-driver bomb-pulse-driver)
(define random-flame-shape bomb-random-flame-cp)
(define random-flame-dir bomb-random-flame-dir)
(define srandom bomb-srandom)
(define file-to-image bomb-file-to-image)
(define drive-with-image bomb-drive-with-image)

(define (concat-symbols a b)
  (string->symbol
   (string-append (symbol->string a)
		  (symbol->string b))))

; (x (x)) == id
(defmacro define-var (name)
  `(define (,name . a)
     (if (null? a)
	 (,(concat-symbols 'bomb-get- name))
	 (,(concat-symbols 'bomb-set- name) (car a)))))

(define-var color)         ; palette index ~ 0-100
(define-var color-type)    ; cmap-*
(define-var rule)          ; rule-*
(define-var speed)
(define-var mask)
(define-var remap)
(define-var randomized-underflow)
(define-var brain)
(define-var brain-shift)
(define-var drift)
(define-var drift-speed)
(define-var drift-time)
(define-var pen-size)
(define-var hot)           ; in rule-rug, nframes heating (allow underflow)
(define-var cool)          ; in rule-rug, nframes cooling (clamp at zero)
(define-var cycle-bkg)     ; bool, effects rule-rug

(define (bomb-flame-shape-gen get set)
  (lambda a
    (if (null? a)
	(let* ((s (with-input-from-string 
		      (string-append "(" (get) ")")
		    read)))
	  s)
	(let ((list-of-strings
	       (let loop ((l (car a)))
		 (if (null? l)
		     '(";")
		     (let ((a (car l)))
		       (cons (if (number? a)
				 (number->string a)
				 (symbol->string a))
			     (cons " " (loop (cdr l)))))))))
	  (set (apply string-append list-of-strings))))))

(define flame-shape (bomb-flame-shape-gen bomb-get-flame-cp bomb-set-flame-cp))
(define flame-dir (bomb-flame-shape-gen bomb-get-flame-dir bomb-set-flame-dir))

(define (show-image n)
  (bomb-file-to-image n 0)
  (bomb-drive-with-image 0))

(define (repeat n f)
  (if (= 0 n) 'ok (begin (f) (repeat (- n 1) f))))
